/*
 * Decompiled with CFR 0.152.
 */
package net.w3p.simplevokabel.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.w3p.simplevokabel.model.Lektion;
import net.w3p.simplevokabel.model.Serializer;
import net.w3p.simplevokabel.model.SerializerFactory;
import net.w3p.simplevokabel.model.Word;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LektionSerializer
implements Serializer {
    public Element serialize(Document document, Object o) {
        if (!(o instanceof Lektion)) {
            return null;
        }
        Lektion l = (Lektion)o;
        if (l.getLastlearned() == null) {
            l.setLastlearned(new Date());
        }
        Element root = document.createElement("Lektion");
        root.appendChild(document.createTextNode("\n  "));
        Element description = document.createElement("Description");
        description.appendChild(document.createTextNode(l.getDescription()));
        root.appendChild(description);
        root.appendChild(document.createTextNode("\n  "));
        Element lastlearned = document.createElement("Lastlearned");
        lastlearned.appendChild(document.createTextNode(new SimpleDateFormat("yyyy-mm-dd").format(l.getLastlearned())));
        root.appendChild(lastlearned);
        Object[] words = l.getBackup();
        Serializer ser = SerializerFactory.getInstance().getSerializer(words[0]);
        for (int i = 0; i < words.length; ++i) {
            root.appendChild(document.createTextNode("\n  "));
            root.appendChild(ser.serialize(document, (Word)words[i]));
        }
        root.appendChild(document.createTextNode("\n"));
        return root;
    }
}

