/***************************************************************************
 *      ________    _______     ______
 *     /       /|  / _____/|   /___  /|                                     
 *    /   //  / / / /___ _|/  _|__/ / /                                     
 * __/_______/___/____ _/|___/_____/___________/ /  /  /   /    /     /     
 *  /   / ___|/  |___/ / /  / /___ |/          /  /  /   /   /     /      / 
 * /___/ /     /______/ /  /_____/|                                         
 * |___|/      |______|/   |_____|/                                         
 *                                                                          
 *
 * Projekt:                   PS2
 * Filename:                  ps2drv.h
 * Autor:                     Fabian Heusser / Pascal Nf www.w3p.ch/ps2
 * Compiler, Language:        HIWARE V5.0  C
 * Target:                    Medusa-Trainer
 *
 *--------------------------------------------------------------------------
 * nderungen:
 * 
 * CVS: $Revision: 1.3 $ $date$
 *
 *   Version  Datum     Autor  Beschreibung der nderung
 *
 *   1.0     2002-06-13 hef    Erstellung
 *
 *--------------------------------------------------------------------------
 * Kurzbeschreibung:
 *
 * Dieser Treiber erlaubt das einfache anschliessen und ansteuern einer 
 * MF-II resp. PS/2 Tastatur.
 * 
 * Dieses Modul implementiert die Serielle bertragung von un zur Tastatur
 * Plus einige User Funktionen wie getch() welches der ASCII-Code der 
 * gedrckten Taste zurckliefert.
 * 
 *--------------------------------------------------------------------------
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 *
 **************************************************************************/

#ifndef ps2drv_h
#define ps2drv_h

/*************************************************************************************
 UEBERTRAGUNGS PROTOKOLL FUNKTIONEN
**************************************************************************************/



/**************************************************************************
 *  void WRITE(data) - bertrgt eine Zeichen zur Tastatur.
 *
 *  Diese Prozedur signalisiert der Tastatur, dass der Host senden will.
 *  Dann wird der Clock der Tastatur bergeben und die Daten gesendet.
 *
 *
 *
 *  @param data (unsigned char) Zeichen dass zur Tastatur gesendet werden soll.
 */
void write(unsigned char data);

/*****************************************************************
 *  char READ() - Liest Zeichen vom der Tastatur
 *
 *  Diese Prozedur setzt den Host auf ready, wartet bis ein Zeichen
 *  empfangen wurde (also Blockierend), und setzt dann der Host wieder auf Busy.
 *
 *  Ist die bertragung gescheitert wird 0x00 zurckgegeben. 
 *  (Die Tastatur selbst sendet bei einem Fehler 0x00 oder 0xFF)
 *
 *
 *  @return unsigned char Zeichen, das gelesen wurde.
 */
unsigned char read();


/*************************************************************************************
USER FUNCTIONS
**************************************************************************************/

/*************************************************************************
 * unsigned char getScanCode() - Liest das erste Zeichen im Tastatur Buffer
 *
 * Dies Prozedur liest ein Zeichen mittels der read() Funktion ein und liefert es zurck. 
 * falls die Tastatur oder die read methode einen Fehler generiert wird die Tastatur aufgefordert
 * das letzte Zeichen erneut zu senden. Geht das 10 mal schief wir das letzte
 * gelesene Zeichen zurckgegeben.
 *
 *
 */

unsigned char getScanCode();



/*************************************************************************
 * unsigned char GETCH() - Liest Zeichen von der Tastatur und liefert das ASCII equivalent zurck.
 *
 * Dies Prozedur liest ein Zeichen mittels der getScanCode() Funktion ein und bersetzt diesen mittels 
 * dem scancodes[] Arrays in ASCII-Codes zurck.
 * Wurde die gedrckte Taste nicht im Scancodes Array gefunden liefert die Prozedur 0x00 zurck, so
 * auch bei erweiterten scancodes.
 *
 * Wird ein Break-Code empfangen wird er ignoiert.
 *
 *
 */
unsigned char getch();

/*************************************************************************
 * unsigned char scancode2ascii(unsigned char scancode) - wandelt ein Scan Code in ein ASCII Zeichen um
 *
 * return ASCII-Code welcher durch dem Scancode representiert wird oder 0 fals das nicht mglich ist.
 *
 */
unsigned char scancode2ascii(unsigned char scancode);

/*************************************************************************
 * void setLED(code) - Setz die NumLock CapsLock und ScrollLock LED auf der Tastatur
 *
 * Diese Funktion setzt mittels Kommando 0xED die LEDs auf der Tastatur
 * Der zu bergebende Parameter setzt sich wie folgt zusammen:
 *
 *  XXXX XCNS
 *        ||-Scroll Lock
 *        |--Num Lock
 *        ---Caps Lock
 *           
 */
void setLED(unsigned char code);

/*************************************************************************
 * unsigned char testKB() - Testet ob eine Tastatur vorhanden ist und ob diese funktioniert.
 *
 * Es wird eine Echo Request (0xEE an die Tastatur gesendet. Kommt eine Echo Response (0xEE) 
 * zurck war der Test erfolgreich und die Prozedur liefer 0 zurck, sonst irgend eine Zahl grsser 0
 * 
 * @return (unsigned char) 0 wenn der Test erfolgreich war, sonst eine Zahl != 0
 */
unsigned char testKB();


/*************************************************************************
 * void reset() - setzt die Tastatur zurck
 *
 * Diese Funktion setzt die Tastatur mittels Kommando 0xFF zurck
 *           
 */
void reset();

/*************************************************************************
 * void init() - initialisiert den Tastatur Treiber
 *
 * Diese Funktion setzt den Host auf nicht bereit, so dass die Tastatur 
 * alle Zeichen Buffert. 
 *           
 */
void init();

/*************************************************************************
 * unsigned char extendedInit() - initialisiert den Tastatur Treiber mit Funktionstest
 *
 * Diese Funktion setzt den Host auf nicht bereit, so dass die Tastatur 
 * alle Zeichen Buffert. Weiter wird ein Reset durchgefhrt und mit Echo
 * die Tastatur getestet. 
 *
 * @return (unsigned char) fals der Test erfolgreich war 0 sonst Zahl != 0
 *           
 */
unsigned char extendedInit();



#endif 