/***************************************************************************
 *      ________    _______     ______
 *     /       /|  / _____/|   /___  /|                                     
 *    /   //  / / / /___ _|/  _|__/ / /                                     
 * __/_______/___/____ _/|___/_____/___________/ /  /  /   /    /     /     
 *  /   / ___|/  |___/ / /  / /___ |/          /  /  /   /   /     /      / 
 * /___/ /     /______/ /  /_____/|                                         
 * |___|/      |______|/   |_____|/                                         
 *                                                                          
 *
 * Projekt:                   PS2
 * Filename:                  ps2.c
 * Autor:                     Fabian Heusser / Pascal Nf www.w3p.ch/ps2
 * Compiler, Language:        HIWARE V5.0  C
 * Target:                    Medusa-Trainer
 *
 *--------------------------------------------------------------------------
 * nderungen:
 *
 *   Version  Datum     Autor  Beschreibung der nderung
 *
 *   1.0     2002-06-13 hef    Erstellung
 *
 *--------------------------------------------------------------------------
 * Kurzbeschreibung:
 *
 * Wird das Programm gestartet erscheint der Keyboardtest auf dem Display.
 * Dieser endet mit OK, wenn das Programm die Tastatur erfolgreich  
 * initialisierte. Die Tastatur sollte dabei den Reset signalisieren, 
 * indem die 3 LEDs kurz aufleuchten. Danach stehen folgende Funktionen zur
 * Verfgung.
 *
 *     mit F12: Initialisierung mit Test wie beim Starten.
 *     Tasten a-z und 0-9 erscheinen auf dem Display.
 *     Backspace und Return funktionieren erwartungsgemss.
 *     Capslock, Numlock und Scrolllock schalten die entsprechenden LEDs ein oder aus.
 *
 *
 *--------------------------------------------------------------------------
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 *
 **************************************************************************/


#include<hc11f1.h>
#include "Lcdrv_PC.h"
#include "ps2drv.h"


/**************************************************************************
   Hauptprogramm
 **************************************************************************/

void main(void) {
  long i;
  int z = 0;
  unsigned char ch;
  unsigned char led = 0x00;
  unsigned char run = 0x00;
  
  //initialize Display an Enable Interrupt
  LCDInit();
  EnableInterrupts;
  
  while (1){
      LCDClear();
      //ausgabe eines schnen schriftzuges mit anschliessendem 
      //'extended Init' und status ausgabe
	  LCDGoto(0,0);
	  LCDWriteString("Iinitializing");
	  LCDGoto(0,1);
	  LCDWriteString("Keyboard:");
	  
	  ch = extendedInit();
	  
	  LCDGoto(11, 1);
	  if (ch == 0x00){
	    LCDWriteString("OK");
	  } else {
	    LCDWriteString("Error");
	  }
	  
	  // eine Pause das man das obige auch zu gesicht bekommt
	  for (i=0; i<40000;i++){}
	  
	  // Lschen
	  LCDClear();
	  LCDGoto(0,0);  
	  
	  z=0;
	  run = 0x00;
	  led = 0x00;
	  while (run == 0x00)
	  {
	    //wir lesen ein zeichen
	    ch = getScanCode();
	    if (ch == 0xf0){ //if it is a break code dont count it!
	      ch = getScanCode();
          ch = getScanCode();
	    }
	    
	    //numlock capslock scrollock setzten lschen und weiter
	    if (ch == 0x77 || ch == 0x7E || ch == 0x58){
			switch (ch)
			{ 	
			    case 0x77: led = led ^ 0x02;break;
				case 0x7E: led = led ^ 0x01;break;
				case 0x58: led = led ^ 0x04;break;
			}
	     	setLED(led);
	        continue;
	    }
	    
	    // f12 -> reset
	    if (ch == 0x07){
	       run = 0x01;
	       continue;
	    }
	    
	   
	        
	    //sonst was wir ausgedruck fals es auflsbar ist.
	    ch = scancode2ascii(ch);
	    
	    if (ch == 0x0D){
	       LCDGoto(0, ((z / 16)+1) % 2);
	       LCDWriteString("                 ");
	       LCDGoto(0, ((z / 16)+1) % 2);
	       z = (((z / 16)+1) % 2) * 16;
	       continue;
	    }
	    
	    if (ch == 8){
	      z--;
	      LCDGoto((z % 16), (z / 16) % 2);
	      LCDWrite(0x20);
		  LCDGoto((z % 16), (z / 16) % 2);
	      continue;	    
	    }
	    
	    
	    if(ch != 0){
		    LCDGoto((z % 16), (z / 16) % 2);
		    LCDWrite(ch);
		    z++;
		    continue;
	    }

	  }
	}

};