/**********************************************************************
                HC11 Small and medium memory model; 
                standard startup-code.
--------------------------------------------------------------------*/
#include <non_bank.sgm>
#include <hidef.h>

#ifdef __BANKED__
#ifdef __cplusplus
extern "C" {
#endif
extern void NEAR InitBank (void);
extern void NEAR _CALL_Y (void);
#ifdef __cplusplus
}
#endif
#endif

#include <startup.h>
/**********************************************************************/

struct _tagStartup _startupData;    /* read-only:
                                     _startupData is allocated in ROM and
                                     initialized by the linker */
                                     
#pragma NO_FRAME

static void NEAR Init(void) {
/* purpose:     1) zero out RAM-areas where data is allocated
                2) copy initialization data from ROM to RAM
   parameters:  EK  page where '_startupData' is allocated
   called from: _Startup, LibInits
*/
   asm {
ZeroOut:     LDX   _startupData.pZeroOut    ; *pZeroOut
             LDY   _startupData.nofZeroOuts ; nofZeroOuts     
             BEQ   CopyDown                 ; if nothing to zero out
NextZeroOut: PSHX                           ; save *pZeroOut
             LDD   2,X                      ; byte count    
             LDX   0,X                      ; start address   
NextWord:    CLR   0,X                      ; clear memory byte               
             INX                            ; inc address
             ADDD  #-1                      ; dec byte count   
             BNE   NextWord                 ;     
             PULX                           ; restore *pZeroOut
#if 0 /* 1 byte shorter */
             INX                            ; advance *pZeroOut
             INX
             INX
             INX
#else
             LDAB #4
             ABX
#endif
             DEY                            ; dec nofZeroOuts   
             BNE   NextZeroOut              ; 
#ifdef __ELF_OBJECT_FILE_FORMAT__ /* in ELF toCopyDownBeg is only 16 bit */
CopyDown:    LDX   _startupData.toCopyDownBeg ; load address of copy down desc.
#else
CopyDown:    LDX   _startupData.toCopyDownBeg:2 ; load address of copy down desc.
#endif
NextBlock:   LDD   0,X                      ; size of init-data -> D
             BEQ   FuncInits                ; end of copy down desc.
             INX
             INX
             LDY   0,X                      ; destination address -> Y
             INX
             INX
Copy:        PSHB
             LDAB  0,X                      ; load a word from ROM and
             STAB  0,Y                      ; store it in the data area
             PULB
             INX                            ; increment addresses
             INY
             ADDD  #-1                      ; decrement word counter
             BNE   Copy
             BRA   NextBlock
FuncInits:
#if defined(__cplusplus) && !defined(__ELF_OBJECT_FILE_FORMAT__)
#ifdef __BANKED__
             LDX   _startupData.mInits      ; load address of first module to initialize
nextInit:    LDY   0,X                      ; load address of initialization function
             BEQ   done                     ; stop when address  == 0
                                            ; in common environments the offset of a function is never 0, so this test could be avoided
             PSHX                           ; push address of address of current function
             INX
             INX
             INX
             INX
#ifdef __InitFunctionsMayHaveOffset0__
             BRCLR -1,X, done, 0xff         ; stop when address  == 0
#endif  /* __InitFunctionsMayHaveOffset0__ */
             PULY                           ; pop address address of current function
             PSHX                           ; save address of next function to initialize
             JSR _CALL_Y                    ; call current function
#else  /* __BANKED__ */
             LDX   _startupData.mInits      ; load address of first module to initialize
nextInit:
             LDY   0,X                      ; load address of first module to initialize
             BEQ   done                     ; stop when address of function == 0
             INX
             INX
             PSHX                           ; save actual address
             JSR   0,Y                      ; call initialization function
#endif /* __BANKED__ */
             PULX                           ; restore actual address
             BRA   nextInit             
done:   
#endif /* __cplusplus */
   }  
}

#ifdef __BANKED__
static long tmp;
#endif

#pragma NO_FRAME 
  
#ifdef __cplusplus
  extern "C"
#endif
  void NEAR _Startup(void) { /* set reset vector with _Startup() function */
/*  purpose:    1)  initialize the stack
                2)  initialize the RAM, copy down init dat etc (Init)
                3)  call main;
    parameters: NONE
    called from: _PRESTART-code generated by the Linker
*/
#ifdef __ELF_OBJECT_FILE_FORMAT__
  DisableInterrupts;  /* in HIWARE format, this is done in the prestart code */
#endif
  for(;;) { /* forever: initialize the program; call the root-procedure */      
    asm {
      /* put your target specific initialisation (e.g. CHIP SELECTS) here */
    }
    if (!(_startupData.flags&STARTUP_FLAGS_NOT_INIT_SP)) {
      /* initialize the stack pointer */
      INIT_SP_FROM_STARTUP_DESC(); /* HLI macro definition in hidef.h */
    }
    asm{
#ifdef __BANKED__
      JSR  InitBank 
#endif                       

Initialize: JSR  Init                        ;       

CallMain:
      }
#ifdef __BANKED__
      {
          tmp = (long)_startupData.main;
          *(int *)&tmp |= 0x8000;
          (*(void (*) (void)) tmp) ();
      }
#else
      (* _startupData.main) ();
#endif
   } /* end loop forever */
}
