/***************************************************************************
 **************** Hochschule Technik + Architektur Luzern ******************
 ****************       Fachbereich Computertechnik       ******************
 ***************************************************************************
 * Projekt:                   
 * Filename:                  LCDrv_PC.H
 * Autor:                     P. Rsli   / R
 * Compiler, Language:        HiCross V2.7  C
 * Target:                    CC11 mit Motorola 68HC11,
 *                            MEDUSA-Trainer, Pinboardadapter mit Keyboard
 *--------------------------------------------------------------------------
 * Aenderungen:
 *
 *   Version  Datum     Autor  Beschreibung der Aenderung
 *
 *   1.0      24.04.98   R    Erstellung
 *   1.1      03.05.00   Kp    Prefix in Interfacefunktionsnamen eingefgt
 *   1.2      08.02.01   M    Singlechip-Anschluss an PORTC und PORTB
 *                             Praeprozessoranweisungen, fuer den Fall, dass
 *                             das Modul bereits importiert wurde
 *   1.3      03.03.01   Kp    kleine Anpassungen
 *	 1.4	  03.03.02	 Kp	   kleine Anpassungen
 *
 *--------------------------------------------------------------------------
 * Kurzbeschreibung:
 *   Diese Datei stellt Routinen fr die Ansteuerung des 2x16 Charakter
 *   LC-Displays (LCD-Controller) HD44780 zur Verfgung. 
 *   Das Display wird im Zweizeilenmodus initialisiert.Fr eine genaue 
 *   Beschreibung des Displays siehe Datenbltter.
 *
 *	 Anschluss des Displays an folgenden HC-11 Ports:
 *		Datenbus am PORTC
 *		Controlbus:	RS  an PORTB.PB0
 *					R_W an PORTB.PB1
 *					EN  an PORTB.PB2
 *
 *	 Systemvoraussetzungen: CC-11 mit bestckter PRU   
 ***************************************************************************/

#ifndef Lcdrv_h
#define Lcdrv_h

/*** Konstanten und Structs ************************************************/
/***************************************************************************/
typedef unsigned char TSoftChar [8] ;
/***************************************************************************
   Type:        Dieser Datentyp wird fr die Definition eines SoftCharakters
                bentigt. Bsp. eines 5x8 SoftCharakters:

                  Bit  4 3 2 1 0
                      ___________   
               Line0  | |X|X|X| |    ->  01110  ->  0x0E  
                      -----------    
               Line1  | |X| |X| |    ->  01010  ->  0x0A  
                      -----------    
               Line2  | |X|X|X| |    ->  01110  ->  0x0E  
                      -----------    
               Line3  | | |X| | |    ->  00100  ->  0x04  
                      -----------    
               Line4  |X|X|X|X|X|    ->  11111  ->  0x1F  
                      -----------    
               Line5  | | |X| | |    ->  00100  ->  0x04  
                      -----------    
               Line6  | |X| |X| |    ->  01010  ->  0x0A
                      -----------
               Line7  |X| | | |X|    ->  10001  ->  0x11  
                      -----------    
   *************************************************************************/


/***************************************************************************/
void LCDInit();
/***************************************************************************
   Funktion:    initialisiert das LCD.
   Parameter:
     In         -
     Out        -
     InOut      -            
   *************************************************************************/

/***************************************************************************/
void LCDClear();
/***************************************************************************
   Funktion:    lscht das Display und setzt den Cursor auf
                den Anfang der ersten Zeile.
   
   Parameter:
     In         -
     Out        -
     InOut      -            
   *************************************************************************/

/***************************************************************************/
void LCDHome();
/***************************************************************************
   Funktion:    Setzt den Cursor auf den Anfang der ersten Zeile
   Parameter:
     In         -
     Out        -
     InOut      -   
   *************************************************************************/

/***************************************************************************/
void LCDCursor (unsigned char On);
/***************************************************************************
   Funktion:    schaltet den Cursor ein (On != 0) oder aus (On = 0). 
                
   Parameter:
     In         On      : On=0 -> Cursor aus , On!=0 -> Cursor ein
     Out        -
     InOut      -   
   *************************************************************************/

/***************************************************************************/
void LCDGoto (unsigned char X, unsigned char Y);
/***************************************************************************
   Funktion:    setzt den Cursor an die angegebene Position.
   Parameter:
     In         X       : X-Position auf dem Display
                Y       : Y-Position auf dem Display
     Out        -
     InOut      -   
   *************************************************************************/

/***************************************************************************/
void LCDShift (unsigned char Right);
/***************************************************************************
   Funktion:    Weil eine Zeile 40 Zeichen lang sein kann, davon aber nur
                16 Zeichen angezeigt werden, kann mit dieser Funktion der
                sichtbare Bereich nach rechts (bei Right!=0) oder links (bei
                Right=0) geschoben werden. Die aktuelle Cursorposition wird
                dabei nicht verndert.
   Parameter:
     In         Right   : =0 -> links schieben;  !=0 -> rechts schieben
     Out        -
     InOut      -   
   *************************************************************************/

/***************************************************************************/
void LCDWrite (char Ch);
/***************************************************************************
   Funktion:    gibt das Zeichen Ch an der aktuellen Cursorposition 
                des Displays aus.
   Parameter:
     In         Ch      : auszugebendes Zeichen
     Out        -
     InOut      -   
   *************************************************************************/

/***************************************************************************/
void LCDWriteLn();
/***************************************************************************
   Funktion:    Setzt den Cursor auf den Anfang der nchsten Zeile.    
   Parameter:
     In         -
     Out        -
     InOut      -   
   *************************************************************************/

/***************************************************************************/
void LCDWriteString (char* Str);
/***************************************************************************
   Funktion:    gibt die Zeichenkette Str (0-terminiert) ab
                der aktuellen Cursorposition auf das Display aus.
   Parameter:
     In         Str     : Zeiger auf eine nullterminierte Zeichenkette
     Out        -
     InOut      -   
   *************************************************************************/

/***************************************************************************/
void LCDLoadSoftChar (unsigned char CharCode, unsigned char SoftChar[]);
/***************************************************************************
   Funktion:    ldt ein anwenderspezifisches Zeichen (Soft-Charakter) 
                in das CG-RAM des Displays.
                Das Zeichen kann danach wie ein vordefiniertes Zeichen mit
                seinem CharCode benutzt werden.
   Parameter:
     In         CharCode:   Code des Spezialzeichens (0..7)
                SoftChar:   Definition des Spezialzeichens
     Out        -
     InOut      -   
   *************************************************************************/

#endif // Lcdrv_h