package mastermind;

import java.awt.Color;
import java.awt.datatransfer.*;
import java.io.*;

/**
 * TransferableTack -
 * Eine Spezielle Klasse welche eine Tack Transportierbar macht. Wird fr das Drag und Drop und Copy und Paste bentigt.
 *
 * Mind Blowing Master Mind ein klein Projekt des Informatik Unterrichts Programmieren II
 * Authors <a href="mailto:ianaef@hta.fhz.ch">Pascal Naef</a>; <a href="mailto:iaheusse@hta.fhz.ch">Fabian Heusser</a>
 * Teacher: H. J. Diethlem
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;
 * Project Homepage: <a href="http://www.w3p.ch/mastermind/">http://www.w3p.ch/mastermind/</a>
 *
 * supported features:
 * OYOAHA Look and feel;
 * Transparen Pictures;
 * Drag & Drop;
 * Copy & Paste;
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.
 *
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).
 *
 *
 * @author Fabian Heusser
 * @author Pascal Naef
 * @version 1.0 $Date: 2001/12/05 15:37:25 $ $Revision: 1.2 $
 * @(#) MasterMindView.java
 */


public class TransferableTack implements Transferable {

  // uesed when we transfer Tack objects directly
  protected static DataFlavor tackFlavor =  new DataFlavor(Tack.class, "Tack Object from MasterMind");

  //The supported flavours
  //this here cost me a sunday. d'nd only works with a minimum of two flavors
  //so you have to put here my flavor plus another flavor. if there is only one
  //the d'n d sink get an dragOver dragEnter and so on but NO drop event!
  //diffucult to find...
  // i don't now actualy if this is a bug or so.
  protected static DataFlavor[] supportedFlavors = {
    tackFlavor, DataFlavor.stringFlavor
  };

  Tack tack; //actually the oject we're dancing for

  /**
   * Erstellt eine Neuen Tack-Packet
   *  @param tack Tack, der Eingepackt werden soll.
   */
  public TransferableTack(Tack tack) {this.tack = tack;}

  /**
   * Return a list of supported Flavors
   * @return DataFlavor[], eine Liste von Data Geschmcker welche untersttzt werden.
   */
  public DataFlavor[] getTransferDataFlavors() { return supportedFlavors;}

  /**
   * Prft ob ein DatenGeschmack untersttzt wird.
   * @param flavor DataFlavor, Der Geschmack der Untersucht werden soll.
   * @return boolean, true wahr wenn der DatenGeschmack untertzt wird.
   */
  public boolean isDataFlavorSupported(DataFlavor flavor) {
    if (flavor.equals(tackFlavor)) return true;
    return false;
  }

  /**
   * bertrgt die Daten ber die d'n d und c'n p schnittstelle
   * wenn das nicht geht schmeissen wir ein exeption.
   * @return Object, der verpackte Tack.
   */
  public Object getTransferData(DataFlavor flavor)
    throws UnsupportedFlavorException, IOException {
    if (flavor.equals(tackFlavor)) return tack;
    else throw new UnsupportedFlavorException(flavor);
  }
}
