package mastermind;


import java.awt.*;
import java.awt.event.*;
import java.awt.datatransfer.*;
import java.awt.dnd.*;
import javax.swing.*;
import javax.swing.border.*;
import java.io.*;

/**
 * TackSorce -
 * Von Hier knnen wir tacks kopieren entweder per drag &drop oder per copy und paste
 *
 * Mind Blowing Master Mind ein klein Projekt des Informatik Unterrichts Programmieren II
 * Authors <a href="mailto:ianaef@hta.fhz.ch">Pascal Naef</a>; <a href="mailto:iaheusse@hta.fhz.ch">Fabian Heusser</a>
 * Teacher: H. J. Diethlem
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;
 * Project Homepage: <a href="http://www.w3p.ch/mastermind/">http://www.w3p.ch/mastermind/</a>
 *
 * supported features:
 * OYOAHA Look and feel;
 * Transparen Pictures;
 * Drag & Drop;
 * Copy & Paste;
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.
 *
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).
 *
 *
 * @author Fabian Heusser
 * @author Pascal Naef
 * @version 1.0 $Date: 2001/12/05 14:46:54 $ $Revision: 1.1.1.1 $
 * @(#) MasterMindView.java
 */

// The following 3 lines of code must be
 // on the same line

 public class TackSource extends JComponent
  implements ClipboardOwner, DragGestureListener,  DragSourceListener {

  DragSource dragSource;

  ImageIcon im;
  Tack tack;
  TransferableTack ttack; //the tack for delivery

  /**
   * Creates a new TrackSource Component.
   * @param tack Tack, tack that he represent.
   */
  public TackSource(Tack tack) {
    this.tack = tack;
    ttack = new TransferableTack(tack);

    //register mouse listener vor c'n p support
    this.addMouseListener(new MouseAdapter() {
      public void mouseClicked(MouseEvent e){ copy(); }
    });

    //register a default DragGestureRecognizer for d'n d support
    dragSource = new DragSource();
    dragSource.createDefaultDragGestureRecognizer(
              this, DnDConstants.ACTION_COPY_OR_MOVE, this);
    im = new ImageIcon("gfx/default/c" + tack.getColor() + ".png");
  }

  //that we have a component
  protected static Dimension mysize = new Dimension(39,45);
  public Dimension getMinimumSize() { return mysize; }
  public Dimension getPreferredSize() {return mysize; }
  public void paintComponent(Graphics g) {
    g.drawImage(im.getImage(),0,0,null);
  }

  // c'n p

  /**
   * Copies the tack to the clipbord and set a border that we now it is in.
   */
  public void copy(){
    //get systzem clipbord
    Clipboard c = this.getToolkit().getSystemClipboard();

    //copy it and set who to be nofied if we lost the clipbord
    c.setContents(ttack, this);

    //now our special border came in action
    this.setBorder(new LineBorder(new Color(0,0,255,100),1 ));
  }

  /**
   * This ClipbordOwner method is called when some other place his shit in it an
   * our color has gone to nirvana. Then whe can set a normal border.
   */
  public void lostOwnership(Clipboard clipbord, Transferable contnets){
    this.setBorder(null);
  }

  //d'n d

  /**
   * This event is called when a drag begins.
   */
  public void dragGestureRecognized(

   DragGestureEvent evt) {
     Transferable t = new TransferableTack(tack);
     dragSource.startDrag (
       evt, DragSource.DefaultMoveDrop, t, this);
  }

  public void dragEnter(DragSourceDragEvent evt) { }
  public void dragOver(DragSourceDragEvent evt) { }
  public void dragExit(DragSourceEvent evt) { }
  public void dropActionChanged(DragSourceDragEvent evt) { }
  public void dragDropEnd(DragSourceDropEvent evt) { //System.out.println(evt.getDropSuccess());
  }
}
