package mastermind;


import java.awt.*;
import java.awt.event.*;
import java.awt.datatransfer.*;
import java.awt.dnd.*;
import javax.swing.*;
import javax.swing.border.*;
import java.io.*;


/**
 * TackSink -
 * Ein Loch im Spielbrett, als JComponente. Ist empfglich fr drag'n drop und cut'n paste von TransferableTack objekten.
 * Geichzeitig kann es als Source fr drag und drop Operationen fungieren. Dies erlaubt eine sehr intuitive Bedienung.
 *
 * Mind Blowing Master Mind ein klein Projekt des Informatik Unterrichts Programmieren II
 * Authors <a href="mailto:ianaef@hta.fhz.ch">Pascal Naef</a>; <a href="mailto:iaheusse@hta.fhz.ch">Fabian Heusser</a>
 * Teacher: H. J. Diethlem
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;
 * Project Homepage: <a href="http://www.w3p.ch/mastermind/">http://www.w3p.ch/mastermind/</a>
 *
 * supported features:
 * OYOAHA Look and feel;
 * Transparen Pictures;
 * Drag & Drop;
 * Copy & Paste;
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.
 *
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).
 *
 *
 * @author Fabian Heusser
 * @author Pascal Naef
 * @version 1.0 $Date: 2001/12/05 14:46:54 $ $Revision: 1.1.1.1 $
 * @(#) MasterMindView.java
 */

public class TackSink extends JComponent
          implements DropTargetListener, DragGestureListener,  DragSourceListener {

  //Tack tack;
  DragSource dragSource;
  MasterMindModel mmd;
  int x,y;

  /**
   * Simple Constructor for this JComponent
   * @param mmd MasterMindModel, the model this component is assigned to.
   * @param x int, the position in the mmd to manipulate
   * @param y int, the position in the mmd to manipulate
   */
  public TackSink(MasterMindModel mmd,int x,int y) {

    this.x = x;
    this.y = y;
    this.mmd = mmd;


    new DropTarget(this, this);

    addMouseListener(new MouseAdapter() {
      public void mouseClicked(MouseEvent e){
        paste();}
    });

    dragSource = new DragSource();
    dragSource.createDefaultDragGestureRecognizer(
              this, DnDConstants.ACTION_COPY_OR_MOVE, this);

  }

  protected static Dimension mysize = new Dimension(39,45);
  public Dimension getMinimumSize() { return mysize; }
  public Dimension getPreferredSize() {return mysize; }
  public void paintComponent(Graphics g) {
  ImageIcon im;
    if (mmd.getTack(x,y)>0){
       im = new ImageIcon("gfx/default/s" + mmd.getTack(x,y) + ".png");
    } else {
       im = new ImageIcon("gfx/default/hole.png");
    }
    g.drawImage(im.getImage(),this.getWidth()/2-im.getIconWidth()/2,this.getHeight()/2-im.getIconHeight()/2,null);
    super.paintComponent(g);
  }

  public void setMasterMindModel(MasterMindModel mmd) {this.mmd = mmd;}

  // c'n p

  /**
   * This Methode is responsible for the paste of an object.
   * This is normaly the action when a user clicks on us.
   */
  public void paste() {
    //first we get the data
    Clipboard c = this.getToolkit().getSystemClipboard();
    Transferable t = c.getContents(this);
    if (t == null) {
      this.getToolkit().beep();
      return;
    }
    try {
      //if we have a Tack -> set it
      if (t.isDataFlavorSupported(TransferableTack.tackFlavor)) {
        Tack tack = (Tack) t.getTransferData(TransferableTack.tackFlavor);
        mmd.setTack(x,y,tack.color);
        repaint();
      }
      //otherwise we don't know what to do
      else this.getToolkit().beep();
    }
    catch (UnsupportedFlavorException e) { this.getToolkit().beep(); }
    catch (IOException e) { this.getToolkit().beep(); }
  }


  // d'n d sink

  /**
   * a d'n d funtion where we tell that we are interested in d'n d action,
   * ignoring the data flavor
   * an event called by the d'n d system.
   */
  public void dragEnter(DropTargetDragEvent e) {
    // Called when the user is dragging and enters
    // this drop target.
    e.acceptDrag(DnDConstants.ACTION_COPY_OR_MOVE);
  }

  public void dragOver(DropTargetDragEvent e) { }
  public void dragExit(DropTargetEvent e) { }
  public void dropActionChanged(DropTargetDragEvent e) { }

  /**
   * This is where the drop is handeld.
   * if someone drops something on us we use it if it is a tack.
   * else we reject it.
   * an event called by the d'n d system.
   */
  public void drop(DropTargetDropEvent e) {
    // Called when the user finishes or cancels
    // the drag operation.
    try {
      Transferable t = e.getTransferable();
      Tack tack = (Tack) t.getTransferData(TransferableTack.tackFlavor);
      mmd.setTack(x,y,tack.color);
      repaint();
      e.dropComplete(true);
    } catch (Exception ex) {
      e.rejectDrop();
      ex.printStackTrace();
    }
  }

  // d'n d source
  /**
   * this is for the d'n d source, so the user not just can put things in, he can get tacks out.
   * an event called by the d'n d system.
   */
  public void dragGestureRecognized(DragGestureEvent evt) {
     Transferable t = new TransferableTack(new Tack(mmd.getTack(x,y)));
     dragSource.startDrag (
       evt, DragSource.DefaultMoveDrop, t, this);
  }

  public void dragEnter(DragSourceDragEvent evt) { }
  public void dragOver(DragSourceDragEvent evt) { }
  public void dragExit(DragSourceEvent evt) { }
  public void dropActionChanged(DragSourceDragEvent evt) { }
  public void dragDropEnd(DragSourceDropEvent evt) { //System.out.println(evt.getDropSuccess());
  }
}