package mastermind;

/**
 * Tack -
 * Eine Spiel tggel. Sorry fr die Englische dokumentation.
 *
 * Mind Blowing Master Mind ein klein Projekt des Informatik Unterrichts Programmieren II
 * Authors <a href="mailto:ianaef@hta.fhz.ch">Pascal Naef</a>; <a href="mailto:iaheusse@hta.fhz.ch">Fabian Heusser</a>
 * Teacher: H. J. Diethlem
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;
 * Project Homepage: <a href="http://www.w3p.ch/mastermind/">http://www.w3p.ch/mastermind/</a>
 *
 * supported features:
 * OYOAHA Look and feel;
 * Transparen Pictures;
 * Drag & Drop;
 * Copy & Paste;
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.
 *
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).
 *
 *
 * @author Fabian Heusser
 * @author Pascal Naef
 * @version 1.0 $Date: 2001/12/05 14:46:54 $ $Revision: 1.1.1.1 $
 * @(#) MasterMindView.java
 */

public class Tack {

  int color = -1;
  int prevousPlaceX = -1;
  int prevousPlaceY = -1;

  /**
   * Makes a new Tack - full featured Constructor
   * @param color, int color of the tack. color <= 10
   * @param previousPlaceX, int where it was befor, -1 if not in a real place
   * @param previousPlaceY, int where it was befor, -1 if not in a real place
   */
  public Tack(int color, int previousPlaceX, int previousPlaceY ) {
    this.prevousPlaceX = previousPlaceX;
    this.prevousPlaceY = previousPlaceY;
    this.color = color;
  }

 /**
   * Makes a new Tack
   * @param color, int color of the tack. color <= 10
   */
  public Tack(int color) {
    this(color, -1, -1);
  }

  /**
   * Makes a new Tack - full featured Constructor
   * @param color, int color of the tack. color <= 10
   * @param previousPlaceX, int where it was befor, -1 if not in a real place
   */
  public Tack(int color, int PreviousPlaceX){
    this(color, PreviousPlaceX, -1);
  }

  /**
   * Returns the color
   * @return int, color <= 10
   */
  public int getColor(){ return color; }

  /**
   * Returns the place it was in x direction
   * @return int, 0.. the place from where the tack was draged or copied. -1 if it comes from a container
   */
  public int getPreviousPlaceX(){return prevousPlaceX;}

  /**
   * Returns the place it was in y direction
   * @return int, 0.. the place from where the tack was draged or copied. -1 if it comes from a container
   */
  public int getPreviousPlaceY(){return prevousPlaceY;}

  /**
   * Sets the color of the Tack
   * @param color int, color 0..10, -1 if no color (ghost)
   */
  public void setColor(int color){ this.color = color; }

  /**
   * sets the previous Place
   * @param prevousPlaceX int, 0..x, -1 if no previous place, p.e. from a container
   */
  public void setPreviousPlaceX(int previousPlaceX){ this.prevousPlaceX = prevousPlaceX;}

  /**
   * sets the previous Place
   * @param prevousPlaceY int, 0..x, -1 if no previous place, p.e. from a container
   */
  public void setPreviousPlaceY(int previousPlaceY){ this.prevousPlaceY = prevousPlaceY;}

  /**
   * Gets the String Representation of this object namly the int as a string.
   * @return a string who represents the color.
   */
  public String toString() {return new Integer(color).toString();}

}