package mastermind;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * SolutionFrame -
 * Ein kleines PopUp Frame welche bei einem allflligen verlieren der Partie der Richtige Code Zeigt
 * Dazu werden TackSources auf das frame geladen,
 *
 * Mind Blowing Master Mind ein klein Projekt des Informatik Unterrichts Programmieren II
 * Authors <a href="mailto:ianaef@hta.fhz.ch">Pascal Naef</a>; <a href="mailto:iaheusse@hta.fhz.ch">Fabian Heusser</a>
 * Teacher: H. J. Diethlem
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;
 * Project Homepage: <a href="http://www.w3p.ch/mastermind/">http://www.w3p.ch/mastermind/</a>
 *
 * supported features:
 * OYOAHA Look and feel;
 * Transparen Pictures;
 * Drag & Drop;
 * Copy & Paste;
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.
 *
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).
 *
 *
 * @author Fabian Heusser
 * @author Pascal Naef
 * @version 1.0 $Date: 2001/12/05 14:46:54 $ $Revision: 1.1.1.1 $
 * @(#) MasterMindView.java
 */

public class SolutionFrame extends JFrame
{
  JPanel spanel;
  JPanel cpanel;
  JButton butt;
  SolutionFrame sf;

  /**
   * Setzt das Fenster zusammen.
   * @param mmd MasterMindModel, welches den code beinhaltet der dargestellt wird.
   */
  public SolutionFrame(MasterMindModel mmd)
  {
    this.getContentPane().setLayout(new GridLayout(2,1));
    this.getContentPane().add(spanel = new PicturePanel (new ImageIcon("gfx\\default\\code.png"), new FlowLayout(FlowLayout.CENTER)));

    sf = this;
    this.setTitle("Code");


    for(int i = 0; i< mmd.getCode().length(); i++) {
      spanel.add(new TackSource(new Tack(mmd.getCode().charAt(i) - 0x30)));
    }

    this.getContentPane().add(cpanel = new JPanel(new FlowLayout(FlowLayout.CENTER)));
    cpanel.add(butt = new JButton("OK"));

    butt.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e){
        sf.dispose();
      }
    });
    this.pack();
  }

  /**
   * Pictre Panel welches eine Einfaches JPanel mit der funktionalitt
   * eines Hintergrund Bildes erweitert
   */
  class PicturePanel extends JPanel{
      ImageIcon im;

    /**
     * Contruktor welcher das Bild entgegen nimmt.
     * @param im ImageIcon, Hintergrundbild
     */
    public PicturePanel(ImageIcon im){
      this.im = im;
    }

    /**
     * Construktor welcher zustzliches ein LayaoutManager
     * @param im ImageIcon, HinterGrundBild
     * @param lm LayoutManager, LayoutManager der das Layout dieses Panel setzt.
     */
    public PicturePanel(ImageIcon im, LayoutManager lm){
      super(lm);
      this.im = im;
    }

    /**
     * Zeichnet das Panel, insbesondere das HintergrundBild
     * @param g Graphics, Worauf gezeichnet wird.
     */
    public void paintComponent(Graphics g)
      {
        super.paintComponent(g);
        g.drawImage(im.getImage(),0,0,this.getWidth(),this.getHeight(),null);
      }
    }
}