package mastermind;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


/**
 * ScorePanel -
 * Zeigt mit Stiften an welche Farben und Pltze richtig sind. Das ganze ist mit einer Flotte
 * von JLabels welche ein Loch oder einen weissen oder schwarzen Stift darstellen. *
 *
 * Mind Blowing Master Mind ein klein Projekt des Informatik Unterrichts Programmieren II
 * Authors <a href="mailto:ianaef@hta.fhz.ch">Pascal Naef</a>; <a href="mailto:iaheusse@hta.fhz.ch">Fabian Heusser</a>
 * Teacher: H. J. Diethlem
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;
 * Project Homepage: <a href="http://www.w3p.ch/mastermind/">http://www.w3p.ch/mastermind/</a>
 *
 * supported features:
 * OYOAHA Look and feel;
 * Transparen Pictures;
 * Drag & Drop;
 * Copy & Paste;
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.
 *
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).
 *
 *
 * @author Fabian Heusser
 * @author Pascal Naef
 * @version 1.0 $Date: 2001/12/05 14:46:53 $ $Revision: 1.1.1.1 $
 * @(#) MasterMindView.java
 */

public class ScorePanel extends JPanel {
  MasterMindModel mmd;
  int y;
  JLabel[] jlbs;
  ImageIcon im_hole = new ImageIcon("gfx/default/hole_kl.png");
  ImageIcon im_black = new ImageIcon("gfx/default/schwarz.png");
  ImageIcon im_white = new ImageIcon("gfx/default/weiss.png");


  /**
   * Initialisiert Das Panal im GridLayaout je nach Model
   * @param mmd MasterMindModel, Model welches fr die dargestellten Informationen verantwortlich ist
   * @param asassociatedRow int, Reihe welche mit diesem Panel representiert wird.
   */
  public ScorePanel(MasterMindModel mmd, int associatedRow) {
    this.mmd = mmd;
    this.y = associatedRow;

    this.setOpaque(false);

    jlbs = new JLabel[mmd.getWidth()];
    this.setLayout(new GridLayout(2, mmd.getWidth() / 2 + mmd.getWidth() % 2));
    for (int i = 0; i< jlbs.length ;i++){
      this.add(jlbs[i] = new JLabel(im_hole));
    }
  }

  /**
   * Zeichnet die ganze Geschichte.
   * @param g Graphics, das worauf gezeichnet wird.
   */
  public void paintComponent(Graphics g){
    super.paintComponent(g);
    int score = mmd.getScore(y);
    //System.out.println(score + ":" + y);
    for (int i = 0; i< jlbs.length; i++){
      if (score >= 100) {
        jlbs[i].setIcon(im_black);
        score -= 100;
      }
      else if (score % 100 > 0){
        jlbs[i].setIcon(im_white);
        score -= 1;
      }
      else {
        jlbs[i].setIcon(im_hole);
      }
    }
  }
}