package mastermind;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

/**
 * MasterMindView -
 * Stellt das Spielbrett dar - Dazu benutzt eine Flotte von TackSinks. Auch ist es mglich ein Hintergrundbild anzugeben.
 *
 * Mind Blowing Master Mind ein klein Projekt des Informatik Unterrichts Programmieren II
 * Authors <a href="mailto:ianaef@hta.fhz.ch">Pascal Naef</a>; <a href="mailto:iaheusse@hta.fhz.ch">Fabian Heusser</a>
 * Teacher: H. J. Diethlem
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;
 * Project Homepage: <a href="http://www.w3p.ch/mastermind/">http://www.w3p.ch/mastermind/</a>
 *
 * supported features:
 * OYAAHA Look and feel;
 * Transparen Pictures;
 * Drag & Drop;
 * Copy & Paste;
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.
 *
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).
 *
 *
 * @author Fabian Heusser
 * @author Pascal Naef
 * @version 1.0 $Date: 2001/12/05 14:46:53 $ $Revision: 1.1.1.1 $
 * @(#) MasterMindView.java
 */
public class MastermindView extends JPanel {

  ImageIcon bg;
  MasterMindModel mmd;
  TackSink[][] tacksinks;

  /**
   * Full featured Constructor
   * @param mmd MasterMindModel, Model welches gezeichnet werden soll
   * @param bg String, Das Hintergrundbild, kann zum beispiel ein
   *                   Spielbrett oder eine schne Frau darstellen
   */
  public MastermindView(MasterMindModel mmd, String bg) {
    this.mmd = mmd;
    if (bg=="") bg = "gfx/default/bg.png";
    this.bg = new ImageIcon(bg);

    //adding the TackSinks
    this.setLayout(new GridLayout(mmd.getHeight(),mmd.getWidth()+1));
    for ( int y = mmd.getHeight(); --y>=0;){
      for (int x = 0; x<mmd.getWidth(); x++){
        this.add(new TackSink(mmd,x,y));
      }
      this.add(new ScorePanel(mmd, y));
    }
  }

  /**
   * Construktor ohne Hintergrund Bild
   * @param mmd MasterMindModel, das Model das gezeichnet werden soll.
   */
  public MastermindView(MasterMindModel mmd) {
      this(mmd, null);
  }

  /**
   * Zeichnet alles, speziel das Hintergrundbild.
   * @param g Graphics, worauf gezeichnet wird.
   */
  public void paintComponent(Graphics g){
    super.paintComponent(g);
    if (bg != null)g.drawImage(bg.getImage(),0,0,this.getWidth(),this.getHeight(),null);
  }

  /**
   * Setzt das Model das gezeichnet wird
   * @param mmd MasterMindModel, welche das Logische Spielbrett enthlt.
   */
  public void setMasterMindModel(MasterMindModel mmd){
   this.mmd = mmd;
   for ( int y = mmd.getHeight(); --y>=0;){
      for (int x = 0; x<mmd.getWidth(); x++){
        tacksinks[x][y].setMasterMindModel(mmd);
      }
    }
    repaint();
  };

  /**
   * Setzt das Hintergrunbild das gezeichnet werden soll
   * @param bg String, Pfad zum Hintergrundbild.
   */
  public void setBg(String bg){ this.bg = new ImageIcon(bg);};
}