package mastermind;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
//import javax.swing.filechooser.FileFilter.*;

/**
 * MastermindMain -
 * Hauptfenster, alle spielrelevanten Variablen und Panels werden gesetzt.
 *
 * Mind Blowing Master Mind ein klein Projekt des Informatik Unterrichts Programmieren II
 * Authors <a href="mailto:ianaef@hta.fhz.ch">Pascal Naef</a>; <a href="mailto:iaheusse@hta.fhz.ch">Fabian Heusser</a>
 * Teacher: H. J. Diethlem
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;
 * Project Homepage: <a href="http://www.w3p.ch/mastermind/">http://www.w3p.ch/mastermind/</a>
 *
 * supported features:
 * OYAAHA Look and feel;
 * Transparen Pictures;
 * Drag & Drop;
 * Copy & Paste;
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.
 *
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).
 *
 *
 * @author Pascal Naef
 * @author Fabian Heusser
 * @version 1.01 $Date: 2001/12/05 15:37:24 $ $Revision: 1.2 $
 * @(#) MastermindMain.java
 */

public class MastermindMain extends JFrame
{
  //Variabeln zur Inizialisierung des MasterMindModels
  private int width = 4, height = 8, color = 4;
  private String background="";

  //playground
  public MasterMindModel playGround = new MasterMindModel(width, height , color);

  //Content- Panel Variablen
  private JPanel contentPanel;
  private BorderLayout borderLayout1 = new BorderLayout();

  //Menu
  private JMenuBar mmMenu = new JMenuBar();
  private JMenu fileMenu = new JMenu("Game");
  private JMenuItem newMenu = new JMenuItem("New");
  private JMenuItem exitMenu = new JMenuItem("Exit");

  private JMenu optionMenu = new JMenu("Options");
  private JMenuItem pgMenu = new JMenuItem("Change background");
  private JMenuItem whMenu = new JMenuItem("Change dimension");

  private JMenu helpMenu = new JMenu("Help");
  private JMenuItem aboutMenu = new JMenuItem("About");

  //Panels fr View und Controll
  private MastermindView viewPanel = new MastermindView(playGround,background);
  private MasterProgressBar masterBar = new MasterProgressBar(playGround);
  private MastermindControll controlPanel = new MastermindControll(playGround,viewPanel,masterBar,this);
  private tackSourcePanel tackSourceP = new tackSourcePanel(playGround);

  JFrame thisframe;

  /**
  * Der Konstruktor erstellt das Mainframe.
  * Er setzt alle Panels (View, Controll, Tack) an die richtige Stelle im BoderLayout.
  * Auch die MenueBar wird konsturiert.
  */
  public MastermindMain()
  {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);

    this.setSize(new Dimension(300, 360));
    this.setTitle("Mastermind");

    thisframe = this;

    contentPanel = (JPanel) this.getContentPane();
    contentPanel.setLayout(borderLayout1);

    //Menu
    fileMenu.add(newMenu);
    newMenu.addActionListener(new MenuListener());
    fileMenu.add(exitMenu);
    exitMenu.addActionListener(new MenuListener());
    fileMenu.add(fileMenu);
    mmMenu.add(fileMenu);

    optionMenu.add(pgMenu);
    pgMenu.addActionListener(new MenuListener());
    optionMenu.add(whMenu);
    whMenu.addActionListener(new MenuListener());
    mmMenu.add(optionMenu);

    aboutMenu.addActionListener(new MenuListener());
    helpMenu.add(aboutMenu);
    mmMenu.add(helpMenu);

    //ShortCuts fuer Menu
    newMenu.setAccelerator(KeyStroke.getKeyStroke('N', java.awt.Event.CTRL_MASK,false));
    exitMenu.setAccelerator(KeyStroke.getKeyStroke('X', java.awt.Event.CTRL_MASK,false));
    pgMenu.setAccelerator(KeyStroke.getKeyStroke('B', java.awt.Event.CTRL_MASK,false));
    whMenu.setAccelerator(KeyStroke.getKeyStroke('D', java.awt.Event.CTRL_MASK,false));
    aboutMenu.setAccelerator(KeyStroke.getKeyStroke('A', java.awt.Event.CTRL_MASK,false));

    this.setJMenuBar(mmMenu);

    //Leere Panels
    contentPanel.add(new JPanel(),borderLayout1.NORTH);

    masterBar.setOrientation(JProgressBar.VERTICAL);
    contentPanel.add(masterBar,borderLayout1.WEST);

    //TackSource
    contentPanel.add(tackSourceP,borderLayout1.EAST);

    //View initialisieren
    contentPanel.add(viewPanel,borderLayout1.CENTER);

    //Controll initalisieren
    contentPanel.add(controlPanel,borderLayout1.SOUTH);

    this.pack();
  }

  /**Overridden so we can exit when window is closed*/
  protected void processWindowEvent(WindowEvent e)
  {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING)
    {
      System.exit(0);
    }
  }

  /**
   * Setzt die Breite des Spielfeldes (muss zuerst neu erzeugt werden)
   *  @param width int
   */
   public void setWidth(int w) {width = w;}

  /**
   * Setzt die Hoehe des Spielfeldes (muss zuerst neu erzeugt werden)
   *  @param heigth int
   */
   public void setHeight(int h) {height = h;}

  /**
   * Setzt die Fraben des Spielfeldes (muss zuerst neu erzeugt werden)
   *  @param color int
   */
   public void setColor(int c) {color = c;}

  /**
   * Initialisert alle Variablen fr ein neues Game
   */
   public void newGame()
   {
      playGround = new MasterMindModel(width, height , color);
      contentPanel.remove(viewPanel);

      viewPanel = new MastermindView(playGround,background);
      contentPanel.add(viewPanel,borderLayout1.CENTER);

      contentPanel.remove(masterBar);
      masterBar = new MasterProgressBar(playGround);
      masterBar.setOrientation(JProgressBar.VERTICAL);
      contentPanel.add(masterBar,borderLayout1.WEST);

      contentPanel.remove(tackSourceP);
      tackSourceP = new tackSourcePanel(playGround);
      contentPanel.add(tackSourceP,borderLayout1.EAST);

      thisframe.validate();
      thisframe.pack();
      controlPanel.setMasterMindModel(playGround);
      controlPanel.setMastermindView(viewPanel);
      controlPanel.setMasterProgressBar(masterBar);
      controlPanel.okButton.setEnabled(true);
   }

  /**
   * Erkennt die Menu- Aufrufe.
   * Enhlt Anweisungen fr jeden Menupunkt.
   */
  class MenuListener implements ActionListener
  {
    public void actionPerformed(ActionEvent e)
    {
      if (e.getSource() == newMenu)
      {
        newGame();
      }
      if (e.getSource() == exitMenu)
      {
        System.exit(0);
      }
      if (e.getSource() == pgMenu)
      {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showDialog(contentPanel, "OK");
        if (returnVal == JFileChooser.APPROVE_OPTION)
        {
          background = fc.getSelectedFile().getPath();
          viewPanel.setBg(background);
        }
      }
      if (e.getSource() == whMenu)
      {
        DimensionFrame dFrame = new DimensionFrame(thisframe, width, height, color);
        dFrame.setLocation(thisframe.getX()+((thisframe.getWidth()-dFrame.getWidth())/2),thisframe.getY()+((thisframe.getHeight()-dFrame.getHeight())/2));
        dFrame.setVisible(true);
      }
      if (e.getSource() == aboutMenu)
      {
        AboutFrame aboutF = new AboutFrame();
        aboutF.setLocation(thisframe.getX()+((thisframe.getWidth()-aboutF.getWidth())/2),thisframe.getY()+((thisframe.getHeight()-aboutF.getHeight())/2));
        aboutF.setVisible(true);
      }
    }
  }
}