package mastermind;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 * MastermindControll -
 * Kontrolliert das Spiel. Wenn der Spielzug abgeschlossen ist, wird das Model aktualisert und alle Sichen neu gezeichnet.
 *
 * Mind Blowing Master Mind ein klein Projekt des Informatik Unterrichts Programmieren II
 * Authors <a href="mailto:ianaef@hta.fhz.ch">Pascal Naef</a>; <a href="mailto:iaheusse@hta.fhz.ch">Fabian Heusser</a>
 * Teacher: H. J. Diethlem
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;
 * Project Homepage: <a href="http://www.w3p.ch/mastermind/">http://www.w3p.ch/mastermind/</a>
 *
 * supported features:
 * OYAAHA Look and feel;
 * Transparen Pictures;
 * Drag & Drop;
 * Copy & Paste;
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.
 *
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).
 *
 *
 * @author Pascal Naef
 * @author Fabian Heusser
 * @version 1.0 $Date: 2001/12/05 14:46:53 $ $Revision: 1.1.1.1 $
 * @(#) MastermindControll.java
 */

class MastermindControll extends JPanel
{
  //GUI - Komponenten
  public JButton okButton = new JButton("OK");
  private MastermindMain mainframe;
  private JPanel thispanel;

  private MasterMindModel playGround;
  private JPanel view;
  private MasterProgressBar masterBar;

  /**
   * Konstruiert den MastermindControll
   * @param _playGround MastermindModel, Spielflche
   * @param _view MastermindView, Spielflchenansicht
   * @param _mpb ProgressBar, Anzeige der Spielschritte
   * @param _mainframe MastermindMain, HauptFrame
   */
  public MastermindControll(MasterMindModel _playGround, MastermindView _view, MasterProgressBar _mpb, MastermindMain _mainframe)
  {
    mainframe = (MastermindMain) _mainframe;
    thispanel = this;

    playGround = _playGround;
    view = _view;
    masterBar = _mpb;

    this.setLayout(new FlowLayout());

    this.add(okButton);

    okButton.addActionListener(new ButtonListener());
  }
  /**
   * bergibt dem Controll die Adresse des MasterMindModels
   * @param _playGround MasterMindModel, Adresse des MasterMindModels
   */
  public void setMasterMindModel(MasterMindModel _playGround)
  {
    playGround = _playGround;
  }
  /**
   * bergibt dem Controll die Adresse des ViewPanels
   * @param _view MastermindView, Adresse des Views
   */
  public void setMastermindView(MastermindView _view)
  {
    view = _view;
  }
  /**
   * bergibt dem Controll die Adresse des ProgressBars
   * @param _mgb MasterProgressBar, Adress der ProgessBar
   */
  public void setMasterProgressBar(MasterProgressBar _mgb)
  {
    masterBar = _mgb;
  }

  /**
   * Erkennt wenn der Button im Controllpanel gedrueckt ist und fuehrt die Auwertung aus.
   */
  class ButtonListener implements ActionListener
  {
    public void actionPerformed(ActionEvent e)
    {
      if (e.getSource() == okButton)
      {
        if (playGround.isTurnComplete())
          {
          view.repaint();
          masterBar.repaint();
          playGround.incrementTurn();
          if (playGround.getWon())
          {
            okButton.setEnabled(false);
            JOptionPane.showMessageDialog(view,"You've won!","Mastermind  Win", JOptionPane.INFORMATION_MESSAGE);
          }
          else if (playGround.getLoose())
          {
            okButton.setEnabled(false);
            SolutionFrame solutionF = new SolutionFrame(playGround);
            solutionF.setLocation(mainframe.getX()+((mainframe.getWidth()-solutionF.getWidth())/2), mainframe.getY()+(mainframe.getY()-thispanel.getHeight())/2);
            JOptionPane.showMessageDialog(view,"You've lost!","Mastermind  Lose", JOptionPane.ERROR_MESSAGE);
            solutionF.setVisible(true);
          }
        }
      }
    }
  }
}