package mastermind;

import javax.swing.UIManager;
import java.awt.*;
import com.oyoaha.swing.plaf.oyoaha.*;
import java.io.File;
import java.net.*;

/**
 * Mastermind -
 * Startklasse, Initialiserung des Spiels. Setzen des LookAndFeel.
 *
 * Mind Blowing Master Mind ein klein Projekt des Informatik Unterrichts Programmieren II
 * Authors <a href="mailto:ianaef@hta.fhz.ch">Pascal Naef</a>; <a href="mailto:iaheusse@hta.fhz.ch">Fabian Heusser</a>
 * Teacher: H. J. Diethlem
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;
 * Project Homepage: <a href="http://www.w3p.ch/mastermind/">http://www.w3p.ch/mastermind/</a>
 *
 * supported features:
 * OYAAHA Look and feel;
 * Transparen Pictures;
 * Drag & Drop;
 * Copy & Paste;
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.
 *
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).
 *
 *
 * @author Pascal Naef
 * @author Fabian Heusser
 * @version 1.0 $Date: 2001/12/05 15:37:23 $ $Revision: 1.2 $
 * @(#) Mastermind.java
 */

public class Mastermind
{
  boolean packFrame = false;

  /**Initialiserung der Applikation*/
  public Mastermind()
  {
  System.out.println("MasterMind Revision: Version 1.01");
    MastermindMain frame = new MastermindMain();
    //Validate frames that have preset sizes
    //Pack frames that have useful preferred size info, e.g. from their layout
    if (packFrame)
    {
      frame.pack();
    }
    else
    {
      frame.validate();
    }
    //Center the window
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = frame.getSize();
    if (frameSize.height > screenSize.height)
    {
      frameSize.height = screenSize.height;
    }
    if (frameSize.width > screenSize.width)
    {
      frameSize.width = screenSize.width;
    }
    frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    frame.setVisible(true);
  }
  /**Main method
   * Auswahl des LookAndFeel
   */
  public static void main(String[] args)
  {
    try
    {
      File file1 = new File("slushy.otm");
      OyoahaLookAndFeel lnf = new OyoahaLookAndFeel();
      if(file1.exists())
      {
        lnf.setOyoahaTheme(file1);
      }
      //UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
      UIManager.setLookAndFeel(lnf);
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
    new Mastermind();
  }
}