package mastermind;

import java.awt.*;
import javax.swing.JFrame;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 * DimensionFrame -
 * Dient zum ndern der Spieldimensionen (Breite, Hhe und Fraben).
 *
 * Mind Blowing Master Mind ein klein Projekt des Informatik Unterrichts Programmieren II
 * Authors <a href="mailto:ianaef@hta.fhz.ch">Pascal Naef</a>; <a href="mailto:iaheusse@hta.fhz.ch">Fabian Heusser</a>
 * Teacher: H. J. Diethlem
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;
 * Project Homepage: <a href="http://www.w3p.ch/mastermind/">http://www.w3p.ch/mastermind/</a>
 *
 * supported features:
 * OYAAHA Look and feel;
 * Transparen Pictures;
 * Drag & Drop;
 * Copy & Paste;
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.
 *
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).
 *
 *
 * @author Pascal Naef
 * @author Fabian Heusser
 * @version 1.0 $Date: 2001/12/05 14:46:52 $ $Revision: 1.1.1.1 $
 * @(#) DimensionFrame.java
 */

public class DimensionFrame extends JFrame implements ActionListener
{
  MastermindMain mainFrame;
  JPanel contentPanel;

  //Optionen- Sliders
  JSlider widthSlider, heightSlider, colorSlider;

  //Label zu Sliders
  JLabel widthLabel = new JLabel("Width");
  JLabel heightLabel = new JLabel("Height");
  JLabel colorLabel = new JLabel("Color");

  JButton okButton = new JButton("OK");
  JButton cancelButton = new JButton("Cancel");
  JButton newGameButton = new JButton("New Game");

  /**
   * Frame zu ndern der Dimensionen des Mastermindspielfeldes.
   * Es knnen die Breite, Lnge und die Anzahl Fraben verndert werden.
   * @param _mainFrame MastermindMain, Hauptfenster
   * @param width int, Breite des Spielfeldes
   * @param height int, Hhe des Spielfeldes
   * @param color int, Anzahl Fraben
   */
  public DimensionFrame(JFrame _mainFrame,int width, int height, int color)
  {
    mainFrame = (MastermindMain) _mainFrame;

    this.getContentPane().setLayout ( new GridLayout(9,1));

    //Optionen- Sliders
    widthSlider = new JSlider(3,10,width);
    heightSlider = new JSlider(6,20,height);
    colorSlider = new JSlider(3,9,color);

    this.setTitle("Mastermind  Dimension");

    contentPanel = (JPanel) this.getContentPane();


    contentPanel.add(widthLabel);
    contentPanel.add(widthSlider);
    widthSlider.setPaintLabels(true);
    widthSlider.setLabelTable(widthSlider.createStandardLabels(1,3));
    contentPanel.add(heightLabel);
    contentPanel.add(heightSlider);
    heightSlider.setPaintLabels(true);
    heightSlider.setLabelTable(heightSlider.createStandardLabels(2,6));
    contentPanel.add(colorLabel);
    contentPanel.add(colorSlider);
    colorSlider.setPaintLabels(true);
    colorSlider.setLabelTable(colorSlider.createStandardLabels(1,3));

    contentPanel.add(newGameButton);
    newGameButton.addActionListener(this);
    contentPanel.add(okButton);
    okButton.addActionListener(this);
    contentPanel.add(cancelButton);
    cancelButton.addActionListener(this);

    this.pack();
  }

  /**
   * Erkennt wenn der Button geklickt ist und schliesst das Fenster.
   */
  public void actionPerformed(ActionEvent e)
  {
    if ((e.getSource() == okButton) || (e.getSource() == newGameButton))
    {
      mainFrame.setWidth(widthSlider.getValue());
      mainFrame.setHeight(heightSlider.getValue());
      mainFrame.setColor(colorSlider.getValue());
      if (e.getSource() == newGameButton)
        mainFrame.newGame();
    }
    this.dispose();
  }
}