package mastermind;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.JFrame;
import javax.swing.JPanel;

/**
 * AboutFrame -
 * Zeigt die Spielinfo an.
 *
 * Mind Blowing Master Mind ein klein Projekt des Informatik Unterrichts Programmieren II
 * Authors <a href="mailto:ianaef@hta.fhz.ch">Pascal Naef</a>; <a href="mailto:iaheusse@hta.fhz.ch">Fabian Heusser</a>
 * Teacher: H. J. Diethlem
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;
 * Project Homepage: <a href="http://www.w3p.ch/mastermind/">http://www.w3p.ch/mastermind/</a>
 *
 * supported features:
 * OYAAHA Look and feel;
 * Transparen Pictures;
 * Drag & Drop;
 * Copy & Paste;
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.
 *
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).
 *
 *
 * @author Pascal Naef
 * @author Fabian Heusser
 * @version 1.0 $Date: 2001/12/05 15:37:22 $ $Revision: 1.3 $
 * @(#) AboutFrame.java
 */

public class AboutFrame extends JFrame implements ActionListener
{
  private JPanel contentPanel;
  private PicturePanel picPanel = new PicturePanel();
  private JButton okButton = new JButton("OK");
  private ImageIcon picture = new ImageIcon("gfx/default/about.png");

  /**
   * Konstruiert das AboutPanel.
   */
  public AboutFrame()
  {
    this.setTitle("Mastermind  About");

    contentPanel = (JPanel) this.getContentPane();
    contentPanel.setLayout(new BorderLayout());

    contentPanel.add(picPanel, BorderLayout.CENTER);
    picPanel.setLayout(new FlowLayout(FlowLayout.TRAILING));
    picPanel.add(new JLabel("<html><br><br><br><br><br><font face=sans-serif></font><h2 align=\"right\">Version 1 (R3)<br>" +
                            "Pascal Nf &amp; Fabian Heusser</h2><p align=\"right\">HTA Luzern Programmieren II<br>" +
                            "Projekt Homepage: www.w3p.ch/mastermind/<br><small> $Revision: 1.3 $ </small></p></font></html>"));

    contentPanel.add(okButton, BorderLayout.SOUTH);
    okButton.addActionListener(this);

    this.pack();
  }

  /**
   * Erkennt wenn der Button geklickt ist und schliesst das Fenster.
   * @param e ActionEvent
   */
  public void actionPerformed(ActionEvent e)
  {
    this.dispose();
  }

  /**
   * Panel zum Anzeigen das Bildes.
   */
  class PicturePanel extends JPanel
  {
  protected Dimension mysize = new Dimension(350,262);
  public Dimension getMinimumSize() { return mysize; }
  public Dimension getPreferredSize() {return mysize; }

    public void paintComponent(Graphics g)
    {
      super.paintComponent(g);
      g.drawImage(picture.getImage(),0,0,null);
    }
  }
}