package net.w3p.simplevokabel.model;

import javax.xml.parsers.*;
import org.w3c.dom.*;

/**
 * Serializes a Word. Word Object -> XML
 *
 * Projekt   SimpleVokabelTrainer
 * Author    Fabian Heusser <f.heusser@w3p.ch>
 * Homepage  http://www.w3p.ch/
 *
 *
 * LEGAL NOTICE
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,USA. *
 *
 * @author Fabian Heusser <f.heusser@w3p.ch>
 * @version 1.0
 */

public class WordSerializer implements Serializer{

  public WordSerializer() {
  }

  public Element serialize(Document document, Object o) {
    Word w = (Word) o;
    Element root = (Element) document.createElement("Word");
    root.appendChild(document.createTextNode("\n    "));

    Element state = (Element) document.createElement("State");
    state.appendChild(document.createTextNode("" + w.getState()));
    root.appendChild(state);
    root.appendChild(document.createTextNode("\n    "));

    Element nativeWord = (Element) document.createElement("NativeWord");
    nativeWord.appendChild(document.createTextNode(w.getNativeWord()));
    root.appendChild(nativeWord);
    root.appendChild(document.createTextNode("\n    "));

    Element foreignWord = (Element) document.createElement("ForeignWord");
    foreignWord.appendChild(document.createTextNode(w.getForeignWord()));
    root.appendChild(foreignWord);
    root.appendChild(document.createTextNode("\n  "));

    return root;
  }
}