package net.w3p.simplevokabel.model;

import javax.xml.parsers.*;
import org.w3c.dom.*;
import java.text.*;
import java.util.*;

/**
 * Serializes an Object. Object -> XML
 *
 * Projekt   SimpleVokabelTrainer
 * Author    Fabian Heusser <f.heusser@w3p.ch>
 * Homepage  http://www.w3p.ch/
 *
 *
 * LEGAL NOTICE
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,USA. *
 *
 * @author Fabian Heusser <f.heusser@w3p.ch>
 * @version 1.0
 */

public class LektionSerializer implements Serializer{

  public LektionSerializer() {
  }

  public Element serialize(Document document, Object o)  {
    if (!(o instanceof Lektion)) return null;
    Lektion l = (Lektion) o;
    if (l.getLastlearned() == null) l.setLastlearned(new Date());
    Element root = (Element) document.createElement("Lektion");
    root.appendChild(document.createTextNode("\n  "));

    Element description = (Element) document.createElement("Description");
    description.appendChild(document.createTextNode(l.getDescription()));
    root.appendChild(description);
    root.appendChild(document.createTextNode("\n  "));

    Element lastlearned = document.createElement("Lastlearned");
    lastlearned.appendChild(document.createTextNode(
               new SimpleDateFormat("yyyy-mm-dd").format(l.getLastlearned())));
    root.appendChild(lastlearned);

    //serializing objects
    Object[] words = l.getBackup();
    Serializer ser = SerializerFactory.getInstance().getSerializer(words[0]);
    for (int i=0; i< words.length; i++){
       root.appendChild(document.createTextNode("\n  "));
       root.appendChild(ser.serialize(document,((Word) words[i])));
    }

    root.appendChild(document.createTextNode("\n"));
    return root;
  }
}