package net.w3p.simplevokabel.model;

/**
 * Returns the right deserializer for a given object
 *
 * Projekt   SimpleVokabelTrainer
 * Author    Fabian Heusser <f.heusser@w3p.ch>
 * Homepage  http://www.w3p.ch/
 *
 *
 * LEGAL NOTICE
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,USA. *
 *
 * @author Fabian Heusser <f.heusser@w3p.ch>
 * @version 1.0
 */
public class DeserializerFactory {

  private static DeserializerFactory instance = new DeserializerFactory();

  private DeserializerFactory() {
  }

  public Deserializer getDeserializer(String s){
    if (s.equals(new String("net.w3p.simplevokabel.model.Lektion"))) return new LektionDeserializer();
    if (s.equals(new String("net.w3p.simplevokabel.model.Word"))) return new WordDeserializer();
    return null;
  }

  public static DeserializerFactory getInstance(){
    return instance;
  }
}