package net.w3p.simplevokabel.main;


import java.io.*;
import java.util.*;
import javax.xml.parsers.*;
import org.apache.xml.serialize.*;
import org.w3c.dom.*;
import net.w3p.simplevokabel.model.*;

/**
 * This is not used in the window application but in the text version in the program.
 * Start this one if you wanna learn a module in the console.
 * but try it out first, windows consoles have some problems with umlauts.
 *
 * Projekt   SimpleVokabelTrainer
 * Author    Fabian Heusser <f.heusser@w3p.ch>
 * Homepage  http://www.w3p.ch/
 *
 *
 * LEGAL NOTICE
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,USA. *
 *
 * @author Fabian Heusser <f.heusser@w3p.ch>
 * @version 1.0
 */

public class Main {

  public Main(File f, InputStream in , PrintStream out, PrintStream err) {
    int kasten = 0, richtig = 0;

    try {
      //Deserializing
      DocumentBuilderFactory dbf = javax.xml.parsers.DocumentBuilderFactory.newInstance();
      DocumentBuilder db = dbf.newDocumentBuilder();
      Document d = db.parse(f);
      Element root = d.getDocumentElement();
      Deserializer deser = DeserializerFactory.getInstance().getDeserializer(Lektion.class.getName());
      Lektion l = (Lektion) deser.deserialize(root);
      l.shuffle();

      BufferedReader breader = new BufferedReader(new InputStreamReader(in));

      //Lektions details ausgeben
      out.println();
      out.println("Lektion       " + f.getName());
      out.println("Beschreibung  " + l.getDescription());
      out.println();
      for (int i = 0; i < 5; i++){
        out.println("Kasten " + (i+1) + " enthlt " + l.getNumWords(i) + " Karten" );
      }
      out.println();


      //nach Kasten fragen
      do {
        try {
          out.print("Welche Kasten soll gebt werden: (1-5) ");
          String s = breader.readLine();
          kasten = Integer.parseInt(s);
          if (kasten > 5 || kasten < 1) throw new Exception("Fehler in der Eingabe");
        }
        catch (Exception ex) {
          System.err.println("Fehler bei der Eingabe");
        }
      } while (kasten > 5 || kasten < 1);
      kasten--; //kleine korrektur;

      //hat der depp einen leeren kasten gewhlt..
      if (l.getNumWords(kasten) == 0) {
        System.err.println("Keine Wrter in diesem Kasten");
        System.exit(1);
      }

      //Wrter ben
      ListIterator li = l.listIterator();
      int numWords = l.getNumWords(kasten);
      while (li.hasNext()){
        Word w = (Word) li.next();
        if (w.getState() != kasten) continue;
        out.println(w.getNativeWord());
        String s = breader.readLine();
        if (s.equals(w.getForeignWord())){
          w.setState(w.getState()+1);
          out.println("> Richtig");
          richtig++;
        } else {
          w.setState(w.getState()-1);
          System.err.println("> Falsch; Richtig wre '" + w.getForeignWord());
        }
        out.println();
      }
      out.println("-------------------------");
      out.println("Statistik:");
      out.println(richtig + " von " + numWords + " Richtig!");

      //Serializing
      d = db.newDocument();
      net.w3p.simplevokabel.model.Serializer ser =
         net.w3p.simplevokabel.model.SerializerFactory.getInstance().getSerializer(l);
      d.appendChild(ser.serialize(d, l));

      OutputFormat format  = new OutputFormat(d);
      format.setPreserveSpace(true);  //wird gebraucht dass man das xml schn rausschreiben kann...
      format.setEncoding("ISO-8859-1");
      format.setIndent(1);
      format.setIndenting(true);
      format.setDoctype(null,"Lektion.dtd");


      File neu = new File(f.getName()); //sicherheiskopie..
      f.renameTo(new File(f.getName()+"_"));

      FileWriter fileOut = new FileWriter(neu);
      XMLSerializer serial = new XMLSerializer(fileOut, format);
      serial.asDOMSerializer();
      serial.serialize(d.getDocumentElement());
      fileOut.close();

    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
  }

  public static void main(String[] args) {
    try {
      Process p = Runtime.getRuntime().exec("cmd");


    if (args.length != 1 ) printUsage("To few or many arguments");
    File f = new File(args[0]);
    if (!f.exists()) printUsage("File not Found");
    //Main main1 = new Main(f, System.in, System.out, System.err);
    Main m = new Main (f, p.getInputStream(), new PrintStream(p.getOutputStream()), System.err );
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }

  }

  private static void printUsage(String s) {
    System.err.println(s);
    System.err.println("usage: voktrainer.jar wordfile.xml");
    System.exit(1);
  }
}