package net.w3p.simplevokabel.main;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.borland.jbcl.layout.*;
import javax.xml.parsers.*;
import org.apache.xml.serialize.*;
import org.w3c.dom.*;
import net.w3p.simplevokabel.model.*;
import java.io.*;
import javax.swing.border.*;
import java.util.*;
import ExampleFileFilter;
import javax.swing.table.*;
import javax.swing.event.*;

/**
 * jMainFrame - Its the Control Point.
 * every menus action take place here.
 * so the thing with this jTable too.
 *
 * Projekt   SimpleVokabelTrainer
 * Author    Fabian Heusser <f.heusser@w3p.ch>
 * Homepage  http://www.w3p.ch/
 *
 *
 * LEGAL NOTICE
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,USA. *
 *
 * @author Fabian Heusser <f.heusser@tic.ch>
 * @version 1.0
 */

public class JFrameMain extends JFrame {
  JPanel contentPane;
  JMenuBar jMenuBar1 = new JMenuBar();
  JMenu jMenuFile = new JMenu();
  JMenuItem jMenuFileExit = new JMenuItem();
  JMenuItem jMenuFileOpen = new JMenuItem();
  JMenuItem jMenuFileSaveAs = new JMenuItem();
  JMenuItem jMenuFileSave = new JMenuItem();
  JMenuItem jMenuFileEditModul = new JMenuItem();
  JMenu jMenuHelp = new JMenu();
  JMenuItem jMenuHelpAbout = new JMenuItem();
  JLabel statusBar = new JLabel();
  BorderLayout borderLayout1 = new BorderLayout();
  TitledBorder titledBorder1;
  boolean[] lernKasten = new boolean[5];
  {for (int i=0; i<lernKasten.length; i++){lernKasten[i] = false;}}
  ListIterator wordIterator;
  Lektion l = null;
  Word wordIsLearning;
  int richtige = 0;
  File f = null;
  JPanel jPanelModul = new JPanel();
  JLabel jLabelDescription = new JLabel();
  JTextField jTextFieldDescription = new JTextField();
  JScrollPane jScrollPaneInput = new JScrollPane();
  JTable jTable1 = new JTable();
  JMenuItem jMenuNewModul = new JMenuItem();

  //Construct the frame
  public JFrameMain() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  //Component initialization
  private void jbInit() throws Exception  {
    //setIconImage(Toolkit.getDefaultToolkit().createImage(jFrameMain.class.getResource("[Your Icon]")));
    contentPane = (JPanel) this.getContentPane();
    titledBorder1 = new TitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED,Color.white,Color.white,new Color(178, 178, 178),new Color(124, 124, 124)),"Kasten whlen");
    contentPane.setLayout(borderLayout1);
    this.setSize(new Dimension(400, 300));
    this.setTitle("VokTrainer by w3p.ch");
    statusBar.setText(" ");
    jMenuFile.setText("File");
    jMenuFileOpen.setText("Open");
    jMenuFileOpen.setAccelerator(KeyStroke.getKeyStroke('O', java.awt.Event.CTRL_MASK, false));
    jMenuFileOpen.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuFileOpen_actionPerformed(e);
      }
    });
    jMenuFileExit.setText("Exit");
    jMenuFileExit.setAccelerator(KeyStroke.getKeyStroke('Q', java.awt.Event.CTRL_MASK, false));
    jMenuFileExit.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuFileExit_actionPerformed(e);
      }
    });
    jMenuHelp.setText("Help");
    jMenuHelpAbout.setText("About");
    jMenuHelpAbout.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuHelpAbout_actionPerformed(e);
      }
    });
    jLabelDescription.setText("Beschreibung");
    jTextFieldDescription.setColumns(25);
    jTable1.setDoubleBuffered(true);
    jMenuNewModul.setText("Neues Modul");
    jMenuNewModul.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jMenuNewModul_actionPerformed(e);
      }
    });
    jMenuFileSaveAs.setText("Speichern unter");
    jMenuFileSaveAs.setEnabled(false);
    jMenuFileSaveAs.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jMenuFileSaveAs_actionPerformed(e);
      }
    });

    jMenuFileSave.setText("Speichern");
    jMenuFileSave.setEnabled(false);
    jMenuFileSave.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jMenuFileSave_actionPerformed(e);
      }
    });

    jMenuFileEditModul.setText("Modul Editieren");
    jMenuFileEditModul.setAccelerator(KeyStroke.getKeyStroke('E', java.awt.Event.CTRL_MASK, false));
    jMenuFileEditModul.setEnabled(true);
    jMenuFileEditModul.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jMenuFileEditModul_actionPerformed(e);
      }
    });

    jMenuFile.add(jMenuFileOpen);
    jMenuFile.add(jMenuFileEditModul);
    jMenuFile.add(jMenuNewModul);
    jMenuFile.add(jMenuFileSave);
    jMenuFile.add(jMenuFileSaveAs);
    jMenuFile.addSeparator();
    jMenuFile.add(jMenuFileExit);
    jMenuHelp.add(jMenuHelpAbout);
    jMenuBar1.add(jMenuFile);
    jMenuBar1.add(jMenuHelp);
    this.setJMenuBar(jMenuBar1);
    contentPane.add(statusBar, BorderLayout.SOUTH);
    contentPane.add(jPanelModul, BorderLayout.NORTH);
    jPanelModul.add(jLabelDescription, null);
    jPanelModul.add(jTextFieldDescription, null);
    jPanelModul.setVisible(false);
    contentPane.add(jScrollPaneInput, BorderLayout.CENTER);
    jScrollPaneInput.getViewport().add(jTable1, null);
    jScrollPaneInput.setVisible(false);
    jTable1.setColumnSelectionAllowed(false);
    jTable1.setRowSelectionAllowed(false);

    jTable1.addKeyListener(new KeyAdapter(){
      public void keyTyped(KeyEvent e){
         if (e.getKeyChar() == '\t') {
           if (jTable1.getSelectedRow() == 0
               && jTable1.getSelectedColumn() == 0){
             ((LektionTableModel)jTable1.getModel()).getLektion().add(new Word());
             ((LektionTableModel)jTable1.getModel()).update();
              jTable1.getSelectionModel().setAnchorSelectionIndex(jTable1.getRowCount()-1);
              jTable1.getColumnModel().getSelectionModel().setAnchorSelectionIndex(0);
              Thread.yield();
              jScrollPaneInput.getVerticalScrollBar().setValue(jScrollPaneInput.getVerticalScrollBar().getMaximum()+1);
           }
         }
      }
    });


  }
  //File | Exit action performed
  public void jMenuFileExit_actionPerformed(ActionEvent e) {
    System.exit(0);
  }

  //File | Open action performed
  public void jMenuFileOpen_actionPerformed(ActionEvent e) {
    try {
      JFileChooser chooser = new JFileChooser();
      ExampleFileFilter xmlFilter = new ExampleFileFilter("xml", "Lektionen");
      chooser.addChoosableFileFilter(xmlFilter);

      File dir = new File("lernmodule");
      if (dir.isDirectory())
        chooser.setCurrentDirectory(dir);
      else
        chooser.setCurrentDirectory(new File("."));

      chooser.showOpenDialog(this);
      f = chooser.getSelectedFile();
      if (f == null || !f.exists()) return;
      if (!f.canWrite()){
        JOptionPane.showMessageDialog(this, "Datei ist Schreibgeschtzt!", "", JOptionPane.ERROR_MESSAGE);
        return;
      }

      DocumentBuilderFactory dbf = javax.xml.parsers.DocumentBuilderFactory.newInstance();
      dbf.setValidating(true);
      dbf.setIgnoringElementContentWhitespace(true);
      DocumentBuilder db = dbf.newDocumentBuilder();
      Document d = db.parse(f);
      Element root = d.getDocumentElement();
      Deserializer deser = DeserializerFactory.getInstance().getDeserializer(Lektion.class.getName());
      l = (Lektion) deser.deserialize(root);
      if (l==null){
        JOptionPane.showMessageDialog(this, "Fehler in der Datei\n", "", JOptionPane.ERROR_MESSAGE);
        return;
      }

      l.shuffle();

      statusBar.setText("Fach whlen");
      DialogTrayChooser dtc = new DialogTrayChooser(l, this, "Fach whlen", true);
      dtc.show();
      lernKasten = dtc.getTrays();

      richtige = 0;
      int total = 0;
      wordIterator = l.listIterator();
      DialogWordLearner dwl;
      while (wordIterator.hasNext()){
        wordIsLearning = (Word) wordIterator.next();
        if (!lernKasten[wordIsLearning.getState()]) continue;
        dwl = new DialogWordLearner(wordIsLearning, this, "", true);
        dwl.show();

        if (dwl.isAborted()) break;

        total++;
        if (dwl.getResultat()){
          wordIsLearning.setState(wordIsLearning.getState()+1);
          richtige++;
        } else {
          wordIsLearning.setState(wordIsLearning.getState()-1);
        }
      }

      //Statistik
      if (total > 0)
        JOptionPane.showMessageDialog(this, "" + richtige + " von " + total + " Richtig ("+ (richtige*100/total)  +"%)");

      //Serializing
      d = db.newDocument();
      net.w3p.simplevokabel.model.Serializer ser =
         net.w3p.simplevokabel.model.SerializerFactory.getInstance().getSerializer(l);
      d.appendChild(ser.serialize(d, l));

      OutputFormat format  = new OutputFormat(d);
      format.setPreserveSpace(true);  //wird gebraucht dass man das xml schn rausschreiben kann...
      format.setEncoding("ISO-8859-1");
      format.setIndent(1);
      format.setIndenting(true);
      format.setDoctype(null,"Lektion.dtd");


      FileWriter fileOut = new FileWriter(f);
      XMLSerializer serial = new XMLSerializer(fileOut, format);
      serial.asDOMSerializer();
      serial.serialize(d.getDocumentElement());
      fileOut.close();
    } catch (Exception ex) {
      ex.printStackTrace();
    }
  }

  //Help | About action performed
  public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
    JFrameMain_AboutBox dlg = new JFrameMain_AboutBox(this);
    Dimension dlgSize = dlg.getPreferredSize();
    Dimension frmSize = getSize();
    Point loc = getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.setModal(true);
    dlg.show();
  }
  //Overridden so we can exit when window is closed
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      jMenuFileExit_actionPerformed(null);
    }
  }

  void jMenuNewModul_actionPerformed(ActionEvent e) {
    jTable1.setModel(new LektionTableModel(new Lektion()));
    jMenuFileOpen.setEnabled(false);
    jMenuNewModul.setEnabled(false);
    jMenuFileEditModul.setEnabled(false);
    jMenuFileSaveAs.setEnabled(true);
    statusBar.setText("Neues Modul");
    jPanelModul.setVisible(true);
    jScrollPaneInput.setVisible(true);
  }

  void jMenuFileSaveAs_actionPerformed(ActionEvent e) {
    try {
      if (jTable1.isEditing()) {
        JOptionPane.showMessageDialog(this, "Sicherung nicht mglich wenn eine\nZelle editiert wird","Speichern nicht mglich",JOptionPane.ERROR_MESSAGE);
        return;
      }

      Lektion lektion  = ((LektionTableModel)jTable1.getModel()).getLektion();
      lektion.setDescription(jTextFieldDescription.getText());

      JFileChooser chooser = new JFileChooser();
      ExampleFileFilter xmlFilter = new ExampleFileFilter("xml", "Lektionen");
      chooser.addChoosableFileFilter(xmlFilter);

      File dir = new File("lernmodule");
      if (dir.isDirectory())
        chooser.setCurrentDirectory(dir);
      else
        chooser.setCurrentDirectory(new File("."));

      chooser.showSaveDialog(this);
      f = null;
      while (f == null){
        f = chooser.getSelectedFile();
        if (f == null) {
          return;
        }
        if (!f.getName().endsWith(".xml")) f = new File (f.getAbsoluteFile()+".xml");
        if (f.exists()) {
          int i = JOptionPane.showConfirmDialog(this,
                     "Datei existiert! Soll sie berschrieben werden?",
                     "Datei exisitert",JOptionPane.YES_NO_CANCEL_OPTION);
          switch (i){
            case JOptionPane.YES_OPTION: break;
            case JOptionPane.NO_OPTION:{ f = null; break;}
            case JOptionPane.CANCEL_OPTION: return;
          }
        }
      }



      //Serializing
      DocumentBuilderFactory dbf = javax.xml.parsers.DocumentBuilderFactory.newInstance();
      DocumentBuilder db = dbf.newDocumentBuilder();
      Document d = db.newDocument();
      net.w3p.simplevokabel.model.Serializer ser =
         net.w3p.simplevokabel.model.SerializerFactory.getInstance().getSerializer(lektion);
      d.appendChild(ser.serialize(d, lektion));

      OutputFormat format  = new OutputFormat(d);
      format.setPreserveSpace(true);  //wird gebraucht dass man das xml schn rausschreiben kann...
      format.setEncoding("ISO-8859-1");
      format.setIndent(1);
      format.setIndenting(true);
      format.setDoctype(null,"Lektion.dtd");


      FileWriter fileOut = new FileWriter(f);
      XMLSerializer serial = new XMLSerializer(fileOut, format);
      serial.asDOMSerializer();
      serial.serialize(d.getDocumentElement());
      fileOut.close();

      JOptionPane.showMessageDialog(this, "Erfolgreich gespeichert");

      jPanelModul.setVisible(false);
      jScrollPaneInput.setVisible(false);
      jMenuFileOpen.setEnabled(true);
      jMenuNewModul.setEnabled(true);
      jMenuFileEditModul.setEnabled(true);
      jMenuFileSaveAs.setEnabled(false);
      statusBar.setText("");
    } catch (Exception ex) { ex.printStackTrace();}
  }

  public void jMenuFileEditModul_actionPerformed(ActionEvent e) {
    try {
      JFileChooser chooser = new JFileChooser();
      ExampleFileFilter xmlFilter = new ExampleFileFilter("xml", "Lektionen");
      chooser.addChoosableFileFilter(xmlFilter);

      File dir = new File("lernmodule");
      if (dir.isDirectory())
        chooser.setCurrentDirectory(dir);
      else
        chooser.setCurrentDirectory(new File("."));

      chooser.showOpenDialog(this);
      f = chooser.getSelectedFile();
      if (f == null || !f.exists()) return;
      if (!f.canWrite()){
        JOptionPane.showMessageDialog(this, "Datei ist Schreibgeschtzt!", "", JOptionPane.ERROR_MESSAGE);
        return;
      }

      DocumentBuilderFactory dbf = javax.xml.parsers.DocumentBuilderFactory.newInstance();
      dbf.setValidating(true);
      dbf.setIgnoringElementContentWhitespace(true);
      DocumentBuilder db = dbf.newDocumentBuilder();
      Document d = db.parse(f);
      Element root = d.getDocumentElement();
      Deserializer deser = DeserializerFactory.getInstance().getDeserializer(Lektion.class.getName());
      l = (Lektion) deser.deserialize(root);
      if (l==null){
        JOptionPane.showMessageDialog(this, "Fehler in der Datei\n", "", JOptionPane.ERROR_MESSAGE);
        return;
      }


      jTable1.setModel(new LektionTableModel(l));
      jTextFieldDescription.setText(l.getDescription());
      jMenuFileOpen.setEnabled(false);
      jMenuNewModul.setEnabled(false);
      jMenuFileEditModul.setEnabled(false);
      jMenuFileSave.setEnabled(true);
      jMenuFileSaveAs.setEnabled(true);
      statusBar.setText("Modul Editieren");
      jPanelModul.setVisible(true);
      jScrollPaneInput.setVisible(true);

    } catch (Exception ex) { ex.printStackTrace(); }
  }

  void jMenuFileSave_actionPerformed(ActionEvent e) {
    try {
      if (jTable1.isEditing()) {
        JOptionPane.showMessageDialog(this, "Sicherung nicht mglich wenn eine\nZelle editiert wird","Speichern nicht mglich",JOptionPane.ERROR_MESSAGE);
        return;
      }

      Lektion lektion  = ((LektionTableModel)jTable1.getModel()).getLektion();
      lektion.setDescription(jTextFieldDescription.getText());

      //Serializing
      DocumentBuilderFactory dbf = javax.xml.parsers.DocumentBuilderFactory.newInstance();
      DocumentBuilder db = dbf.newDocumentBuilder();
      Document d = db.newDocument();
      net.w3p.simplevokabel.model.Serializer ser =
         net.w3p.simplevokabel.model.SerializerFactory.getInstance().getSerializer(lektion);
      d.appendChild(ser.serialize(d, lektion));

      OutputFormat format  = new OutputFormat(d);
      format.setPreserveSpace(true);  //wird gebraucht dass man das xml schn rausschreiben kann... HUMBUG!
      format.setEncoding("ISO-8859-1");
      format.setIndent(1);
      format.setIndenting(true);
      format.setDoctype(null,"Lektion.dtd");


      FileWriter fileOut = new FileWriter(f);
      XMLSerializer serial = new XMLSerializer(fileOut, format);
      serial.asDOMSerializer();
      serial.serialize(d.getDocumentElement());
      fileOut.close();

      JOptionPane.showMessageDialog(this, "Erfolgreich gespeichert");

      jPanelModul.setVisible(false);
      jScrollPaneInput.setVisible(false);
      jMenuFileOpen.setEnabled(true);
      jMenuNewModul.setEnabled(true);
      jMenuFileEditModul.setEnabled(true);
      jMenuFileSave.setEnabled(false);
      jMenuFileSaveAs.setEnabled(false);
      statusBar.setText("");
    } catch (Exception ex) { ex.printStackTrace();}
  }
}