package ch.w3p.currgrid;

 /**
 * Lst eine Matrix nach der Gausselimination <br>
 * Simulates a Current Grid. Mathematic Project I2<br>
 * Authors <a href="mailto:schroeterd@freesurf.ch">Daniel Schrter</a>; <a href="mailto:f.heusser@tic.ch">Fabian Heusser</a><br>
 * Teacher: Dr. Josef F. Brgler<br>
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;<br>
 * Project Homepage: <a href="http://www.w3p.ch/currgrid/">http://www.w3p.ch/currgrid/</a><br>
 * Project Maillist: <a href="mailto:currgrid@w3p.ch">currgrid@w3p.ch</a><br>
 * <br>
 * supported features:<br>
 * interpolatet Plot:<br>
 * interpolatet VoltageOutput;<br>
 * change Voltage Points;<br>
 * delete Voltage Points;<br>
 * delete a Singel Voltage Point;<br>
 * drawLevelLinesM;<br>
 * Matrix ScrPrintOut<br>
 * <br>
 *
 * LEGAL NOTICE<br>
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.<br>
 *<br>
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).<br>
 *
 *<br>
 * @author Daniel Schrter
 * @author Fabian Heusser
 * @version 1.02, 07/03/01
 * @(#) Matrix.java
 */
public class Matrix{

private double[][] matrix;
private double[] x;
private int n;


//Konstruktor
/**
 * Construktor, erstellt ein Objekt.
 * @param numberOfUnknown int, die Anzahl unbekannte des Systems
 */
public Matrix(int numberOfUnknown) {
  if (numberOfUnknown>0){ //eventuel noch max Grsse einbauen
    n = numberOfUnknown;
    x = new double[n];
    matrix = new double[n+1][n];
    //Explizit setzen auf 0
    for(int zY = 0;zY<matrix[0].length;zY++){
      for(int zX = 0;zX<matrix.length;zX++){
        matrix[zX][zY]=0;
      }
    }
    for(int z = 0;z<x.length;z++){
      x[z]=0;
    }
  }
  else {
    System.out.println("numberOfUnknown out of boundaries Error while creating Matrix-Object");
  }
}

/**
 * Liefert die Grsse der Matrix zurck.
 * @return int, die Anzahl unbekannten im System
 */
public int getSize(){
  return n;
}

/**
 * Setzt eine Punkt in der Matrix.
 * @param zX int, x Position des Punktes
 * @param zY int, y Position des Punktes
 * @param value int, Wert des Punktes
 */
public void setElement(int zX,int zY,double value) {
  if ((zX<matrix.length) && (zY<matrix[0].length)) {
    matrix[zX][zY]=value;
  }
  else {System.out.println("Error while accessing method matrix.setElement");}
}
/**
 * Liefert den Wert eines Punktes in der Matrix
 * @param zX int, X Position
 * @param zY int, Y Position
 * @return double, Wert des Elementes.
 */
public double getElement(int zX,int zY){
  if ((zX<matrix.length) && (zY<matrix[0].length)) {
    return matrix[zX][zY];
  }
  else {
    System.out.println("Error while accessing method Matrix.getElement"+" X="+zX+" Y="+zY);
    return Double.NaN;
  }
}

/**
 * Liefert eine unbekannte zurck
 * @param z int, zeile der unbekannten.
 * @return wert der Unbekannten
 */
public double getX(int z){
if (z<x.length) {
    return x[z];
  }
  else {System.out.println("Error while accessing method matrix.getX"+" X="+z);return Double.NaN;}
}

/**
 * Setzt eine Unbekannte
 * @param z int, zeile der unbekannten.
 */
public void setX(int z,double value){
if (z<x.length) {
    x[z] = value;
  }
  else {System.out.println("Error while accessing method matrix.setX"+" X="+z);}
}


/**
 * Gauss Elimination des Systems ohne Pivotisierung;
 * lst das System
 */
public void gaussEliminate() {
  /* Gausselimination ohne Pivotisierung
  Ax=C Matrix

  double[x][y] matix; fr A und c
  double[y]    x;     fr x
     [A]   k,j     c             x
      0    x       n
k   0 **********   *        0    *
      **********   *             *
 i y  ** n*n ***   *             *
      **********   *             *
(n-1) **********   *       (n-1) *

  */

  //Elimination
  double factor;
  for(int k=0;k<n-1;k++){    //"Rechteck" fr Gausselimination
    for(int i=k+1;i<n;i++){ //Zeilen
      factor = matrix[k][i]/matrix[k][k];
      for(int j=k;j<=n;j++){ //alle Elemente der Zeile bearbeiten incl. c)
        matrix[j][i] -= factor*matrix[j][k];
      }
    }
    //Testausgabe
 //   System.out.println("matrix Schritt "+k);
 //   for(int zY = 0;zY<matrix[0].length;zY++){
 //     int zX;
 //     for(zX = 0;zX<matrix.length-1;zX++){
 //       System.out.print(" #"+matrix[zX][zY]);
 //     }
 //     System.out.println(" #"+matrix[zX][zY]);
 //   }
 //   //ende Testausgabe
 }

  //Rckwrtseinsetzen
  double sum;
  x[n-1] = matrix[n][n-1]/matrix[n-1][n-1]; //x in letzter Zeile ausrechnen
  for(int i = (n-2);i>=0;i--){ //Zeilen
    sum = 0;
    for(int j = n-1;j>=i+1;j--) {
      sum += matrix[j][i]*x[j];
    }
    x[i]=(matrix[n][i]-sum)/matrix[i][i];
  }
  //Testausgabe Resultat
  //  for(int z = 0;z<x.length;z++) {System.out.println("x"+z+"= "+x[z]);}
  }


/**Kopiert die Matrix
 * @return die die Kopie als Matrixobjekt
 */
  public Matrix copy() {
    Matrix clone = new Matrix(n);
    for(int zY = 0;zY<matrix[0].length;zY++){
      for(int zX = 0;zX<matrix.length;zX++){
        clone.setElement(zX,zY,matrix[zX][zY]);
      }
    }
    for(int z = 0;z<x.length;z++){
      clone.setX(z,x[z]);
    }
    return clone;
  }
}