package ch.w3p.currgrid;

import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

/**
 * Applet zur Berechnung von Strmen in einem Gitter
 * Bestehend aus Kontrol und View die Berechnungen werden durch das CurrSim Objekt gettigt<BR>
 * <BR>
 * Simulates a Current Grid. Mathematic Project I2<br>
 * Authors <a href="mailto:schroeterd@freesurf.ch">Daniel Schrter</a>; <a href="mailto:f.heusser@tic.ch">Fabian Heusser</a><br>
 * Teacher: Dr. Josef F. Brgler<br>
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;<br>
 * Project Homepage: <a href="http://www.w3p.ch/currgrid/">http://www.w3p.ch/currgrid/</a><br>
 * Project Maillist: <a href="mailto:currgrid@w3p.ch">currgrid@w3p.ch</a><br>
 * <br>
 * supported features:<br>
 * interpolatet Plot:<br>
 * interpolatet VoltageOutput;<br>
 * change Voltage Points;<br>
 * delete Voltage Points;<br>
 * delete a Singel Voltage Point;<br>
 * drawLevelLinesM;<br>
 * Matrix ScrPrintOut<br>
 * <br>
 *
 * LEGAL NOTICE<br>
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.<br>
 *<br>
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).<br>
 *<br>
 *
 * @author Daniel Schrter
 * @author Fabian Heusser
 * @version 1.04, 07/03/01
 * @(#) CurrSimLet.java
 */

 /*
    ACHTUNG! cols und rows sind durcheinandergeraten es ist kein verlass mehr auf die natrliche asozation der beiden begriffe!

 */
public class CurrSimLet extends Applet
  implements ActionListener, AdjustmentListener, MouseListener, MouseMotionListener {

//Titel
  private Label titel = new Label("Simgrid by Heusser & Schrter");
//Panels
  private Panel controlPanel;
  private Panel gridPanel;
//Grsse des Gitters
  private Label rowsLabel;
  private Label colsLabel;
  private Label rowsActualLabel;
  private Label colsActualLabel;
  private Scrollbar rowsBar;
  private Scrollbar colsBar;
//Definieren eines Punktes
  private Label vLabel;
  private TextField vTextField;
  private int mouseKlickedX = 0;
  private int mouseKlickedY = 0;
  private Button randomButton;
  private Button setDefButton;
  private Choice setDefChoice;
  private Button resetButton;
//Berechnen
  private Button calcButton;
//Frame fr ausgabe
  private OutputFrame outputFrame1;
//Grafik fr Schnellere Bildwiedergabe
  //Ausgabe auf das Applet (hier die Spannungswerte)
  private Image simImage;
  private Graphics simGraphics;
  private boolean simImageCreated = false;
  private boolean simImageChanged = false;
  //Ausgabe der Berechneten Daten =>Frame
  //Frame hat sein eigenes Bild!!
//das Gitter
  private SimGrid grid;
  private static int gridCols = 20;
  private static int gridRows = 20;
//Quickinfo
  private String quickinfo;
  private int quickinfoX = 0;
  private int quickinfoY = 0;

/** Initialisierung des Applets<BR>
 *  -GUI initialisieren<BR>
 *  -CurrSim Obj mit Standarteinstellungen generieren<BR>
 */
  public void init( ){
  //Grsse des Applets
    this.setEnabled(true);
    this.setBackground(Color.lightGray);
    //this.setSize(504,600);
  //Panels
    controlPanel = new Panel(null);add(controlPanel);
    controlPanel.setBounds(0,0,503,90);
    //gridPanel = new Panel();
  //titel
    controlPanel.add(titel);
    titel.setBounds(170,5,250,20);
    this.setName("Projekt Simgrid by Heusser & Schrter");
  //Elemente zur Definition der Grsse des Gitters
    rowsLabel = new Label("cols:");
    controlPanel.add(rowsLabel);
    rowsLabel.setBounds(15,15,40,10);
    rowsBar = new Scrollbar(Scrollbar.HORIZONTAL,0,1,1,50);
    controlPanel.add(rowsBar);
    rowsBar.addAdjustmentListener(this);
    rowsBar.setBounds(15,35,60,15);
    colsLabel = new Label("rows:");
    controlPanel.add(colsLabel);
    colsLabel.setBounds(80,15,60,10);
    colsBar = new Scrollbar(Scrollbar.HORIZONTAL,0,1,1,50);
    controlPanel.add(colsBar);
    colsBar.addAdjustmentListener(this);
    colsBar.setBounds(80,35,60,15);
    rowsActualLabel = new Label(""+gridCols);
    controlPanel.add(rowsActualLabel);
    rowsActualLabel.setBounds(15,50,40,10);
    colsActualLabel = new Label(""+gridRows);
    controlPanel.add(colsActualLabel);
    colsActualLabel.setBounds(80,50,70,10);
    rowsBar.setValue(gridCols);
    colsBar.setValue(gridRows);
  //Elemente zur Definition eines Punktes im Gitter
    vLabel = new Label("U (in V):");
    controlPanel.add(vLabel);
    vLabel.setBounds(125,65,45,15);
    vTextField = new TextField("",5);
    controlPanel.add(vTextField);
    vTextField.addActionListener(this);
    vTextField.setBounds(170,60,70,20);
    vTextField.setText("0");

    //Zufallsmuster
    randomButton = new Button("random");
    controlPanel.add(randomButton);
    randomButton.addActionListener(this);
    randomButton.setBounds(250,60,60,20); //250,35,60,20);

    //vordefinierte Muster
    setDefButton = new Button("set");
    controlPanel.add(setDefButton);
    setDefButton.addActionListener(this);
    setDefButton.setBounds(360,35,40,20);
    setDefChoice = new Choice();
    controlPanel.add(setDefChoice);
    setDefChoice.setBounds(250,35,100,20);
    setDefChoice.add("Dr.J.B.Muster");
    setDefChoice.add("Muster2");
    setDefChoice.add("Muster3");
    //reset des Netzes (alle def Punkte lschen)
    resetButton = new Button("reset");
    controlPanel.add(resetButton);
    resetButton.addActionListener(this);
    resetButton.setBounds(430,10,60,20);

  //Gitter berechnen
    calcButton = new Button("calculate");
    controlPanel.add(calcButton);
    calcButton.addActionListener(this);
    calcButton.setBounds(430,60,60,20);
  //Frame fr Ausgabe
    outputFrame1 = new OutputFrame();


  //Gitter erstellen
    grid = new SimGrid(0,0,500,500,gridCols,gridRows);
    outputFrame1.setGrid(grid);
  //Mausbedienung
    addMouseListener(this);
    addMouseMotionListener(this);
  //Hintergrundfarbe
    this.setBackground(Color.lightGray);
  }

/** Zeichnen des Applets<BR>
 *  -Das bereitgestellte Bild des Grids wird gezeichnet (aus dem bebufferten Bild)<BR>
 *  -falls die Maus im Gridfenster ist wird ein Quickinfo mit den Spannungswerten angezeigt<BR>
 */
  public void paint(Graphics g ){//mit DoubleBuffering
    if (!simImageCreated) {
      simImage = createImage(500,500);
      simGraphics = simImage.getGraphics();
      simGraphics.setColor(this.getBackground());
      simGraphics.fillRect(0, 0, 500,500);
      grid.drawGridWithPoints(simGraphics,Color.black,Color.red);
      //grid.displayGrid(simGraphics); //wird hier zum ersten mal gezeichnet
                                  //und dann nur noch bei Vernderungen
    }
    if (simImageChanged){
      grid.drawGridWithPoints(simGraphics,Color.black,Color.red,0,0);
    }
    g.drawImage(simImage,1, 97, this);
    g.setColor(Color.darkGray);
    g.draw3DRect(0,96,501,501,true);
    //quickinfo anzeigen
    if (quickinfo != null) {
      Color col = new Color(255,255,0,150);//yellow Background with Alpha
      g.setColor(col);
      g.fillRect(quickinfoX,quickinfoY,100,15);
      g.setColor(Color.black);
      g.drawRect(quickinfoX,quickinfoY,100,15);
      g.drawString(quickinfo,quickinfoX+3,quickinfoY+12);
    }
  }

/**
 *  Die update methode wurde berschrieben, da mit DoubleBuffering gearbeitet wird
 */
  public void update(Graphics g) {
    paint(g);
  }


/**
 * Eingaben bearbeiten<BR>
 *
 * -Spannungs-TextField eingaben kontrollieren<BR>
 * -Button Benutzerdef Punkt setzen<BR>
 * -Button Berechnen des Grid<BR>
 * -Button Reset: Neues leeres Grid erstellen<BR>
 * -Button Random 8 Punkte mit Zufallskoordinaten und Spannung hinzufgen<BR>
 * -Button Muster: entsprechend dem ausgewhlten Muster Punkte hinzufgen<BR>
 */
  public void actionPerformed(ActionEvent e){
    boolean error=false;

    //Kontrolle der Werte (funktioniert nur wenn Enter gedrckt)
    if (e.getSource() == vTextField) {
      double v;
      try {
        v = Double.parseDouble(vTextField.getText());
      } catch (NumberFormatException exeption) {
        vTextField.setText("0");//Textfeld das einen nicht gltigen inhalt hat auf 0
        v=0;
      }
      if ((v<-100000d) || (v>100000d)){ //Falls v-Wert ausserhalb des def. Bereichs
        vTextField.setText("0");
      }
    }


    //dem Grid werden 8 Punkte mit Zuflligen Koordinaten und Spannungswerten hinzugefgt
    if (e.getSource() == randomButton) {
      for (int i = 0;i<8;i++){
        grid.setVoltage((int)(Math.random()*(colsBar.getValue()+1)),(int)(Math.random()*(rowsBar.getValue()+1)),(Math.random()-.5)*2000);
      }
    simImageChanged = true;
    repaint();
    }

    //Die Verschiedenen Muster
    //je nach ausgew. Muster werden die Punkte dem Grid hinzugefgt
    if (e.getSource() == setDefButton) {
      if (setDefChoice.getSelectedItem()=="Muster3") {
        grid.setVoltage(0,0,100d);
        grid.setVoltage(rowsBar.getValue(),colsBar.getValue(),100d);
        grid.setVoltage(rowsBar.getValue(),0,-100d);
        grid.setVoltage(0,colsBar.getValue(),-100d);
      }
      if (setDefChoice.getSelectedItem()=="Muster2") {
        grid.setVoltage(0,0,-100d);
        grid.setVoltage(rowsBar.getValue(),colsBar.getValue(),-100d);
        grid.setVoltage(rowsBar.getValue(),0,100d);
        grid.setVoltage(0,colsBar.getValue(),100d);
        grid.setVoltage((rowsBar.getValue())/2,(colsBar.getValue())/2,100d);
      }
      if (setDefChoice.getSelectedItem()=="Dr.J.B.Muster") { //brglers muster
        for (int i = 0;i<rowsBar.getValue()/2+1;i++){
          grid.setVoltage(i,0,5);
        }
        for (int i = rowsBar.getValue()/2;i<=rowsBar.getValue();i++){
          grid.setVoltage(i,colsBar.getValue(),0);
        }


      }
      simImageChanged = true;
      repaint();
    }


    if (e.getSource() == calcButton) {
      outputFrame1.newCalc(true);
      outputFrame1.repaint();
      outputFrame1.setVisible(true);
      outputFrame1.setEnabled(true);
    }
    if (e.getSource() == resetButton) {
      //altes Obj freigeben (wird vom Garbage Collector entfernt)
      //und ein neues Obj mit der richtigen Grsse erschaffen
      grid = new SimGrid(0,0,500,500,rowsBar.getValue(),colsBar.getValue());
      outputFrame1.setGrid(grid);
      simImageChanged = true;
      repaint();
    }
  }

/**
 *  Eingaben bearbeiten<BR>
 *  colsBar,rowsBar Regler
 */
  public void adjustmentValueChanged(AdjustmentEvent e){
    if (e.getSource() == rowsBar) {
      rowsActualLabel.setText(""+(rowsBar.getValue()));
      //bei genderter Grsse altes Obj freigeben (wird vom Garbage Collector entfernt)
      //und ein neues Obj mit der richtigen Grsse erschaffen
      grid = new SimGrid(0,0,500,500,rowsBar.getValue(),colsBar.getValue());
      outputFrame1.setGrid(grid);
    }
    if (e.getSource() == colsBar) {
      colsActualLabel.setText(""+(colsBar.getValue()));
      //bei genderter Grsse altes Obj freigeben (wird vom Garbage Collector entfernt)
      //und ein neues Obj mit der richtigen Grsse erschaffen
      grid = new SimGrid(0,0,500,500,rowsBar.getValue(),colsBar.getValue());
      outputFrame1.setGrid(grid);
    }
    simImageChanged = true;
    repaint();
  }


  /**
   * unbenutzt (muss wegen MousListener eingebunden werden)
   */
  public void mouseClicked(MouseEvent e) {  }

  /**
   * Bei Linksklick Ausgewhlter Bereich mit V vom Textfeld setzten<BR>
   * Bei Rechsklick alle Punkte im Bereich lschen
   *
   */
  public void mouseReleased(MouseEvent e) {
  if ((mouseKlickedX > -1) && (mouseKlickedY > -1)) { //Mouseclicked inside Grid
    double v = Double.NaN;
    boolean error = false;

        //linksklick spannungen setzen
        if (e.getModifiers() == e.BUTTON1_MASK){
          //System.out.println("leftmousebklicked");
          //Add a point with current voltage
          try {
            v = Double.parseDouble(vTextField.getText());
          } catch (NumberFormatException exeption) {
            vTextField.setText("0");//Textfeld das einen nicht gltigen inhalt hat auf 0
            v=0;
            error = true;
          }
          if ((v<-100000d) || (v>100000d)){ //Falls v-Wert ausserhalb des def. Bereichs
            vTextField.setText("0");
            error = true;
          }
        }

        //Mittelklick keine aktion
        if (e.getModifiers() == e.BUTTON2_MASK){
          //System.out.println("middlemousebklicked");
        }

        //rechtsklick Punkte lschen
        if (e.getModifiers() == e.BUTTON3_MASK){
          v = Double.NaN;
        }

        if (!error){  //rewritten by fabian heusser

            //auslesen der Mauskoordinaten
            int rowEnd = grid.getVoltagePointX(e.getX()-1);
            int colEnd = grid.getVoltagePointY(e.getY()-97);
            int rowStart = grid.getVoltagePointX(mouseKlickedX-1);
            int colStart = grid.getVoltagePointY(mouseKlickedY-97);

            //berprfend der Gitter Grenze
            if (rowEnd > (rowsBar.getValue())) rowEnd = rowsBar.getValue();
            if (colEnd > (colsBar.getValue())) colEnd = colsBar.getValue();
            if (rowStart > (rowsBar.getValue())) rowStart = rowsBar.getValue();
            if (colStart > (colsBar.getValue())) colStart = colsBar.getValue();

            // Cords sortieren fr schleife
            if (rowEnd < rowStart) { int tmp = rowEnd; rowEnd = rowStart; rowStart = tmp;}
            if (colEnd < colStart) { int tmp = colEnd; colEnd = colStart; colStart = tmp;}

            //System.out.println("SetArea: ("+rowEnd+","+colEnd+"),("+rowStart+","+colStart+");");

            for (int rowI = rowStart;rowI<=rowEnd;rowI++){
              for(int colI = colStart;colI<=colEnd;colI++){
                //System.out.println("setPoint ("+colI+","+rowI+") = "+v);
                grid.setVoltage(rowI,colI,v);
              }
            }


            mouseKlickedX = 0;
            mouseKlickedY = 0;
            simImageChanged = true;
            repaint();
        }
     }
  }

  /**
   * unbenutzt (muss wegen MousListener eingebunden werden)
   */
  public void mousePressed(MouseEvent e) {
    if ((e.getX() >= 1)&&(e.getX()<=501)&&(e.getY()>=97)&&(e.getY()<=97+500)){ //Mouseclicked inside Grid
      mouseKlickedX = e.getX();
      mouseKlickedY = e.getY();
      //System.out.println(mouseKlickedX+" "+mouseKlickedY);
    }
    else {
      mouseKlickedX = -1;
      mouseKlickedY = -1;
    }
  }

  /**
   * unbenutzt (muss wegen MousListener eingebunden werden)
   */
  public void mouseEntered(MouseEvent e) { }

  /**
   * unbenutzt (muss wegen MousListener eingebunden werden)
   */
  public void mouseExited(MouseEvent e) { }

  /**
   * Falls die Maus ber dem Grid ist wird das Quickinfo angezeigt.
   */
  public void mouseMoved(MouseEvent e) {
    if ((e.getX() >= 1)&&(e.getX()<=501)&&(e.getY()>=97)&&(e.getY()<=97+500)){ //Mouse inside Grid }
      double v = grid.getDefVoltage(grid.getVoltagePointX(e.getX()-1),grid.getVoltagePointY(e.getY()-97));
      if (Double.isNaN(v)) {
        quickinfo = new String("("+grid.getVoltagePointX(e.getX()-1)+","+grid.getVoltagePointY(e.getY()-97)+")");
      }
      else {
        v = Math.round(v*10000)/10000d;
        quickinfo = new String("("+grid.getVoltagePointX(e.getX()-1)+","+grid.getVoltagePointY(e.getY()-97)+")="+v);
      }
      try{
         quickinfo = quickinfo.substring(0,15);
        }
      catch (StringIndexOutOfBoundsException f){}
      quickinfoX = e.getX()+10;
      quickinfoY = e.getY()+20;
      if (quickinfoY >= 97+500-20) quickinfoY -= 35;
      if (quickinfoX >= 501 - 70) quickinfoX -= 80;
    }
    else {
      quickinfo = null;
    }
    repaint();
  }

 /**
  * unbenutzt (muss wegen MouseListener eingebunden werden)
  */
  public void mouseDragged(MouseEvent e) { }
}