package ch.w3p.currgrid;

import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;

/**
 * SimGrid - a flexible current grid simulation object<br>
 * Simulates a Current Grid. Mathematic Project I2<br>
 * Authors <a href="mailto:schroeterd@freesurf.ch">Daniel Schrter</a>; <a href="mailto:f.heusser@tic.ch">Fabian Heusser</a><br>
 * Teacher: Dr. Josef F. Brgler<br>
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;<br>
 * Project Homepage: <a href="http://www.w3p.ch/currgrid/">http://www.w3p.ch/currgrid/</a><br>
 * Project Maillist: <a href="mailto:currgrid@w3p.ch">currgrid@w3p.ch</a><br>
 * <br>
 * supported features:<br>
 * interpolatet Plot:<br>
 * interpolatet VoltageOutput;<br>
 * change Voltage Points;<br>
 * delete Voltage Points;<br>
 * delete a Singel Voltage Point;<br>
 * drawLevelLinesM;<br>
 * Matrix ScrPrintOut<br>
 * <br>
 *
 * LEGAL NOTICE<br>
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.<br>
 *<br>
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).<br>
 *<br>
 *
 * @author Fabian Heusser
 * @author Daniel Schrter
 * @version 1.02, 07/03/01
 * @(#) SimGrid.java
 */
public class SimGrid
{

	private boolean calculated = false;     //True wenn die Matrix gerechnet wurde.
	private boolean changed = false;        //ist True wenn das Grid gendert wurde
	private double[] voltagePoints;       //Enthlt die Punkte mit Spannugen dran
                                                //[][0] [][1] [][2]
                                                //row  | col | value
                                                //     |     |
        private double[] voltage;
        private int xPos,yPos,height,width,col,row;  //Die parameter des Gitters
        private final boolean debug = true;       //if true debug messages will printed to the System.out.
        private long timeToCalculate, timeToDraw, timeToAssamble, timeToDrawLevelLine;
        private Matrix unSolvedMatrix;
        private Matrix solvedMatrix;

        /**
         * assembliert und gibt die matrix in auftrag.
         */
private void calculate() { //Berechnet die Matrix
        long timeCalulationBase = System.currentTimeMillis();
        System.out.println("gone to calculate:" + (System.currentTimeMillis()-timeCalulationBase));
        Matrix currentMatrix;           //Hlt das Stromgitter.
        int[] unknowPoints = new int[(col+1)*(row+1)];           //[x+y*col]

        int pointNr=0;
        //wir gehen hier zuerst alle punkte durch und nummerieren sie. --> array unknowPoints wird gefllt
        for (int i = 0; i<=row;i++){for(int k = 0; k<=col;k++){
          if (Double.isNaN(getDefVoltage(k,i))){
            unknowPoints[i*(col+1)+k]=pointNr++;
          }
        }}
        if (debug){System.out.println("point list generated. gone to assamble:" + (System.currentTimeMillis()-timeCalulationBase));}

        if (pointNr != 0){
          //dann suchen wir die nachbarn und tragen sie in die matrix ein.
          currentMatrix = new Matrix(pointNr);//da wir sonst das nullte element vergessen (d.h. das matrix objeckt braucht die anzahl elemente)
          int matrixSize = currentMatrix.getSize();

          int nrOfNeighbors = 0;
          pointNr=0;
          for (int i = 0; i<=row; i++){for(int k = 0; k<=col;k++){
            if (Double.isNaN(getDefVoltage(k,i))){ //herausfinden ob der punkt eine festspannung ist wenn nein matrix fllen
            // wir holen zuerst mal die nummer des punktes;
            pointNr = unknowPoints[i*(col+1)+k];
            // zuerst oberer nachbar
              if (i>0){if (Double.isNaN(getDefVoltage(k,i-1))){          // wenn der obere nachbar vorhanden ist und keine festspannung eine 1 hineinschreiben
                 currentMatrix.setElement(unknowPoints[(i-1)*(col+1)+k], // wir setzten eine 1 in der zeile des elements und an der stelle des nachbars
                                          pointNr,
                                          1);
              } else {  // es ist eine festspannung, das heisst fr uns wir setzten in der B spalte der Matrix das negative der spannung
                 currentMatrix.setElement(matrixSize,pointNr,
                                          currentMatrix.getElement(matrixSize,pointNr)-getDefVoltage(k,i-1)
                                          );} //fr den fall das da schon eine spannung ist mssen wir sie subtrahieren
              nrOfNeighbors++;} // wir habe einen Nachbar gefunden

            // linker nachbar
              if (k>0){if (Double.isNaN(getDefVoltage(k-1,i))){          // wenn der obere nachbar vorhanden ist und keine festspannung eine 1 hineinschreiben
                 currentMatrix.setElement(unknowPoints[i*(col+1)+k-1], // wir setzten eine 1 in der zeile des elements und an der stelle des nachbars
                                          pointNr,
                                          1);
              } else {  // es ist eine festspannung, das heisst fr uns wir setzten in der B spalte der Matrix das negative der spannung
                 currentMatrix.setElement(matrixSize,pointNr,
                                          currentMatrix.getElement(matrixSize,pointNr)-getDefVoltage(k-1,i));}
              nrOfNeighbors++;} // wir habe einen Nachbar gefunden


            // rechter nachbar
              if (k<col){if (Double.isNaN(getDefVoltage(k+1,i))){          // wenn der obere nachbar vorhanden ist und keine festspannung eine 1 hineinschreiben
                 currentMatrix.setElement(unknowPoints[i*(col+1)+k+1], // wir setzten eine 1 in der zeile des elements und an der stelle des nachbars
                                          pointNr,
                                          1);
              } else {  // es ist eine festspannung, das heisst fr uns wir setzten in der B spalte der Matrix das negative der spannung
                 currentMatrix.setElement(matrixSize,pointNr,
                                          currentMatrix.getElement(matrixSize,pointNr)-getDefVoltage(k+1,i));}
              nrOfNeighbors++;} // wir habe einen Nachbar gefunden


            // untermieter
              if (i<row){if (Double.isNaN(getDefVoltage(k,i+1))){          // wenn der obere nachbar vorhanden ist und keine festspannung eine 1 hineinschreiben
                 currentMatrix.setElement(unknowPoints[(i+1)*(col+1)+k], // wir setzten eine 1 in der zeile des elements und an der stelle des nachbars
                                          pointNr,
                                          1);
              } else {  // es ist eine festspannung, das heisst fr uns wir setzten in der B spalte der Matrix das negative der spannung
                 currentMatrix.setElement(matrixSize,pointNr,
                                          currentMatrix.getElement(matrixSize,pointNr)-getDefVoltage(k,i+1));}
              nrOfNeighbors++;} // wir habe einen Nachbar gefunden

            // nun muss die anzahl nachbarn noch in die matrix und zwar an der stelle des untersuchten punktes.
            currentMatrix.setElement(pointNr,
                                     pointNr,
                                     -nrOfNeighbors);
            nrOfNeighbors = 0;}
          }}
          timeToAssamble = System.currentTimeMillis()-timeCalulationBase;
          if (debug){System.out.println("assambled. gone to solve system:" + (System.currentTimeMillis()-timeCalulationBase));}
          unSolvedMatrix = currentMatrix.copy();
          currentMatrix.gaussEliminate();
          solvedMatrix = currentMatrix.copy();
          timeToCalculate = System.currentTimeMillis()-timeCalulationBase-timeToAssamble;
          if (debug){System.out.println("system solved." + (System.currentTimeMillis()-timeCalulationBase));}

          for (int i = 0; i<=row;i++){for(int k = 0; k<=col;k++){
            if (Double.isNaN(getDefVoltage(k,i))){
              voltage[i*(col+1)+k] = currentMatrix.getX(unknowPoints[i*(col+1)+k]);
            } else {
              voltage[i*(col+1)+k] = getDefVoltage(k,i);
            }
          }}
        } else {
         for (int i = 0; i<=row;i++){for(int k = 0; k<=col;k++){
            if (!Double.isNaN(getDefVoltage(k,i))){
              voltage[i*(col+1)+k] = getDefVoltage(k,i);
            }
        }}
          unSolvedMatrix = new Matrix(1);
          solvedMatrix = new Matrix(1);
        }

        //aufrumen;
        currentMatrix = null;

        calculated = true;
        changed = false;

	}
/******************************************************************************
 * the DRAW function
 ******************************************************************************/


        // hef 15/05/01
        /**
         * zeichnet das spannungsgitter, wenn es noch nicht berechnet ist wird es.
         * Das zeichnen funktioniert mit der quadratischer Interpollation.
         * @param g Graphics Objekt in welches das Spannungsgitter gezeichnet werden soll.
         */
public void display(Graphics g){ //Zeichnet das Grid
          if (!calculated || changed) {
              calculate();}
          long timeCalculationBase = System.currentTimeMillis();
          double maxVoltage = getMaxVoltage();
          double minVoltage = getMinVoltage();
          double deltaVoltage = maxVoltage - minVoltage;
          double v0,v1,v2,v3,vP,w,h;
          for (int i = 0; i<row;i++){for (int k=0; k<col;k++){ //wir durchlaufen alle gitter punkte
            v0 = getVoltage(k,i);
            v1 = getVoltage(k+1,i);
            v3 = getVoltage(k,i+1);
            v2 = getVoltage(k+1,i+1);
            h = (double)(height)/(double)(row);
            w = (double)(width)/(double)(col);
            for (int l=0; l<=h; l++){ // wir durschlaufen alle zeilen in einem quadrat
              for (int m=0 ; m<=w; m++){ // wir durchlaufen alle pixel auf einer zeile des quadrates
                vP = (v2-v3-v1+v0)*(m/w)*((l/h))+(v1-v0)*(m/w)+(v3-v0)*((l/h))+v0;
                g.setColor(new Color(
                               (int)(255*((vP-minVoltage)/deltaVoltage)),
                               0,
                               (int)(255-(255*((vP-minVoltage)/deltaVoltage)))));
                g.drawLine((int)(xPos+(k*w)+m),
                           (int)(yPos+(i*h)+l),
                           (int)(xPos+(k*w)+m),
                           (int)(yPos+(i*h)+l)); // pixel zeichnen
            }}
          }}
          timeToDraw = System.currentTimeMillis() - timeCalculationBase;
          System.out.println("System drawn. " + timeToDraw + "ms");
          //for (int i = (int)getMinVoltage(); i<getMaxVoltage(); i += (getMaxVoltage()-getMinVoltage())/40){
            // drawLevelLine(i,Color.white,g);}
        }


        /**
         * Zeichnet das Gitternetz. ntersttzt zustzlich noch ein anders offset als dem grid zugewisen wurde
         * @param g Graphics, das Fenster in das es gezeichnet werden soll.
         * @param c Color, Farbe des Gitters
         * @param xPos int, alternatives x offset
         * @param yPos int, alternatives y offset
         * @see #drawGrid(Graphics g, Color c)
         * @see #drawGrid(Graphics g)
         *
         */
public void drawGrid(Graphics g, Color c,int xPos, int yPos){
          g.setColor(c);
          for (int i = col; (--i)>0;){g.drawLine(xPos+width*i/col,yPos,xPos+ width*i/col,yPos+height);}
          for (int i = row; (--i)>0;){g.drawLine(xPos,yPos+height*i/row,xPos+width,yPos+height*i/row);}
        }
        /**
         * Zeichnet das Gitternetz
         * @param g Graphics, das Fenster in das es gezeichnet werden soll.
         * @param c Color, Farbe des Gitters
         * @see #drawGrid(Graphics g, Color c,int xPos, int yPos)
         * @see #drawGrid(Graphics g)
         */
        public void drawGrid(Graphics g, Color c){
          g.setColor(c);
          for (int i = col; (--i)>0;){g.drawLine(xPos+width*i/col,yPos,xPos+ width*i/col,yPos+height);}
          for (int i = row; (--i)>0;){g.drawLine(xPos,yPos+height*i/row,xPos+width,yPos+height*i/row);}
        }

        /**
         * Zeichnet das Gitternetz. berschreibt die Funktion bei der zustzlich noch die Farbe angegeben werden kann
         * @param g Graphics, das Fenster in das es gezeichnet werden soll.
         * @see #drawGrid(Graphics g, Color c)
         * @see #drawGrid(Graphics g, Color c,int xPos, int yPos)
         */
         public void drawGrid(Graphics g){
           drawGrid(g,Color.gray);
         }

        /**
         * Zeichnet das Gitternetz mit den Punkten welche sich im array befinden.
         * diese Variante untersttzt zustzlich das setzten eines anderen Offset als dem Grid Obj. zugewisen wurde.
         * @param g Graphics, das Fenster in das es gezeichnet werden soll.
         * @param cGrid Color, die Farbe des Gitters.
         * @param cPoints Color, Die Farbe der Punkte.
         * @param xPos int, X Offset
         * @param yPos int, Y Offset
         * @see #drawGridWithPoints(Graphics g, Color cGrid,Color cPoints)
         * @see #drawGridWithPoints(Graphics g,Color cPoints)
         * @see #drawGridWithPoints(Graphics g)
         */
public void drawGridWithPoints(Graphics g,Color cGrid,Color cPoints, int xPos, int yPos){
          Color c = g.getColor();
          drawGrid(g,cGrid,xPos,yPos);
          g.setColor(cPoints);
          for (int i = 0; i<=row;i++){for (int k=0; k<=col;k++){
            if (!Double.isNaN((getDefVoltage(k,i))))
               g.fillOval((int)(xPos+(width*k/col)-width/col/4),(int)(yPos+(height*i/row)-height/row/4),(int)(width/col/2),(int)(height/row/2));
          }}
          g.setColor(c);
        }
        /**
         * Zeichnet das Gitternetz mit den Punkten welche sich im array befinden.berschreibt die sub welche ein anderes x,y offset untersttzt als das objeckt hat
         * @param g Graphics, das Fenster in das es gezeichnet werden soll.
         * @param cGrid Color, die Farbe des Gitters.
         * @param cPoints Color, Die Farbe der Punkte.
         * @see #drawGridWithPoints(Graphics g,Color cGrid,Color cPoints, int xPos, int yPos)
         * @see #drawGridWithPoints(Graphics g,Color cPoints)
         * @see #drawGridWithPoints(Graphics g)
         */
        public void drawGridWithPoints(Graphics g,Color cGrid,Color cPoints){
          drawGrid(g,cGrid);
          for (int i = 0; i<=row;i++){for (int k=0; k<=col;k++){
            if (!Double.isNaN((getDefVoltage(k,i))))
               g.fillOval((int)(xPos+(width*k/col)-width/col/8),(int)(yPos+(height*i/row)-height/row/8),(int)(width/col/4),(int)(height/row/4));
          }}
        }
        /**
         * Zeichnet das Gitternetz mit den Punkten welche sich im array befinden. berschreibt funktionen mit mehr Farboptionen
         * @param g Graphics, das Fenster in das es gezeichnet werden soll.
         * @param cPoints Color, Die Farbe der Punkte.
         * @see #drawGridWithPoints(Graphics g,Color cGrid,Color cPoints, int xPos, int yPos)
         * @see #drawGridWithPoints(Graphics g, Color cGrid,Color cPoints)
         * @see #drawGridWithPoints(Graphics g)
         */
        public void drawGridWithPoints(Graphics g,Color cPoints){
          drawGridWithPoints(g,Color.gray,cPoints);
        }
        /**
         * Zeichnet das Gitternetz mit den Punkten welche sich im array befinden. berschreibt funktionen mit mehr Farboptionen
         * @param g Graphics, das Fenster in das es gezeichnet werden soll.
         * @see #drawGridWithPoints(Graphics g, Color cGrid,Color cPoints)
         */
        public void drawGridWithPoints(Graphics g){
          drawGridWithPoints(g,Color.gray,Color.red);
        }

        /**
         * Verbindet Punkte mit dem Gleichen Spannungs Niveau.
         * Vorab version Kann noch Optimiertwerden in dem die der InterpollationsMechanismus direkt implementiert wird.
         * @param level double, hhe der spannung bei der eine linie gezeichnet werden soll
         * @param c Color, Farbe der Linie.
         * @param g Graphics, Objekt auf welches es gezeichnet werden soll.
         * @param toleranz double, die Toleranz der Linie in Prozent zum gesammten Wertebereich.
         * @see #drawLevelLine(double level, Color c, Graphics g)
         */
public void drawLevelLine(double level, Color c, Graphics g, double toleranzRelativ){
            long timeCalculationBase = System.currentTimeMillis();
            double vP;
            Color cBack = g.getColor();
            g.setColor(c);
            double toleranz = (getMaxVoltage()-getMinVoltage())*(toleranzRelativ/100);   // in volt
            for (int i = 0; i<row;i++){for (int k=0; k<col;k++){ //wir durchlaufen alle gitter punkte
            double v0 = getVoltage(k,i);
            double v1 = getVoltage(k+1,i);
            double v3 = getVoltage(k,i+1);
            double v2 = getVoltage(k+1,i+1);
            double h = (double)(height)/(double)(row);
            double w = (double)(width)/(double)(col);
            for (int l=0; l<=h; l++){ // wir durschlaufen alle zeilen in einem quadrat
              for (int m=0 ; m<=w; m++){ // wir durchlaufen alle pixel auf einer zeile des quadrates
                vP = (v2-v3-v1+v0)*(m/w)*((l/h))+(v1-v0)*(m/w)+(v3-v0)*((l/h))+v0; // siehe doku
                  if ((vP < (level+toleranz)) && (vP > (level-toleranz))) {
                     g.drawLine((int)(xPos+(k*w)+m),
                           (int)(yPos+(i*h)+l),
                           (int)(xPos+(k*w)+m),
                           (int)(yPos+(i*h)+l));} // pixel zeichnen
               }}
            }}
            g.setColor(cBack);
            timeToDrawLevelLine = System.currentTimeMillis() - timeCalculationBase;
        }

       /**
         * Verbindet Punkte mit dem Gleichen Spannungs Niveau. Es wird eine default Toleranz von 1 Promill gesetzt.
         * Vorab version Kann noch Optimiertwerden in dem die der InterpollationsMechanismus direkt implementiert wird.
         * @param level double, hhe der spannung bei der eine linie gezeichnet werden soll
         * @param c Color, Farbe der Linie.
         * @param g Graphics, Objekt auf welches es gezeichnet werden soll.
         * @see #drawLevelLine(double level, Color c, Graphics g, double toleranz)
         */
public void drawLevelLine(double level, Color c, Graphics g){
          drawLevelLine(level,c,g,0.1d);
        }

/*******************************************************************************
 * the GET procedures
 ******************************************************************************/


        /**
         * liefert die Spannung eines Punktes zurck.
         * @param row die Zeile in der sich der Spannungspunkt befindet
         * @param col die Spalte in der sich der Spannungspunkt befindet
         * @return double; Spannnung welche am angegebenen punkt anliegt. NaN falls es den Punkt nicht gibt
         */
public double getVoltage(int col, int row){ //Liefert die Spannung eines Punktes zurck
           int i = 0;
                //Punkt im Vektor Array Suchen...
         // if (()){ return Double.NaN;}
           if (!calculated){
             return getDefVoltage(col,row);

           } else {
             try{return voltage[row * (this.col+1) + col];}  // out of boudary exception ignorieren hef 06/17/01
               catch (Exception e){return Double.NaN;}
           }
	}

        /**
         * Liefert das array mit den Spannungen drin zrck
         * die spannung eines punktes errechnet sich demnach aus:
         * x * (col+1) + y
         * @return double[], ein array mit allen spannugen drin.
         */
public double[] getVoltagesForSave(){
         return voltage;
        }

        /**
         * liefert nur die Spannung eines FestSpannungPunktes zurck.
         * @param row die Zeile in der sich der Spannungspunkt befindet
         * @param col die Spalte in der sich der Spannungspunkt befindet
         * @return double; Spannnung welche am angegebenen punkt anliegt. NaN falls es den Punkt nicht gibt
         */
public double getDefVoltage(int col, int row){ //Liefert die Spannung eines Punktes zurck
            return voltagePoints[row*(this.col+1)+col];
	}

        /**
         * Liefert einen Interpollierten Spannungs wert einer X,Y Koordinate.
         * Es wird Linear Integriert.
         * ber den genauen vorgang verweise ich auf die spezielle doku zu diesem thema auf unserer Projeckt Homepage.
         * @param x int, x Koordinate
         * @param y int, y Koordinate
         * @return die interpollierte spannung,.
         */
public double getVoltageInterpolated(int x, int y){
          int i,k;  //punkt suchen
          for(k=0; k<=col;k++){if (x-(xPos+(width*k /col))<0) { break;}}
          for(i=0; i<=row;i++){if (y-(yPos+(height*i/row))<0) { break;}}
          k--;i--;
          double v0 = getVoltage(k,i);
          double v1 = getVoltage(k+1,i);
          double v3 = getVoltage(k,i+1);
          double v2 = getVoltage(k+1,i+1);
          double h = height/row;
          double w = width/col;
          int l = (y+1)-(yPos+(height*i/row));
          int m = (x)-(xPos+(width*k /col));
          return (v2-v3-v1+v0)*(m/h)*((l/w))+(v1-v0)*(m/h)+(v3-v0)*((l/w))+v0;
        }


        /**
         * liefert die maximale Spannung des Gitters.
         * @return double; Die  maximale Spannnung;
         */
public double getMaxVoltage(){
          double maxVoltage = 0;
          for(int i = voltage.length; (--i)>=0;){
            if (voltage[i] > maxVoltage) {maxVoltage = voltage[i];}
          }
          return maxVoltage;
        }

        /**
         * liefert die minimale Spannung des Gitters.
         * @return double; Die minimale Spannnung;
         */
public double getMinVoltage(){
          double minVoltage = 0;
          for(int i = voltage.length; (--i)>=0;){
            if (voltage[i] < minVoltage) {minVoltage = voltage[i];}
          }
          return minVoltage;
        }

        /**
         * Resetet das Array mit dem Spannungen auf null (alle punkte sind gelscht)
         * auch die timer werden gereseted.
         */
public void resetVoltagePoints() {
           voltagePoints = new double[row*col]; //@todo covers the maximum amount of possible voltage points -> too much and should replaced by a vector....
           voltage = new double[row*(col+1)+col+1]; // *WICHTIG* beim updated dieser 2 Zeilen Konstruktor updaten
           timeToCalculate =0;
           timeToAssamble =0;
           timeToDraw =0;
           timeToDrawLevelLine=0;
        }

       /**
         *  wie die gleichnamige ausser, dass die berflssige y koordinate nicht gegeben werden muss.
         *  @param x x koordinate
         *  @retrurn int, kolonne (col);
         */
        // hef 15/05/01
public int getVoltagePointX(int x){
          // we search for the col that is nearest the cliked point....
          for(int k = col+1; (--k)>=0;){
              if ( Math.abs(xPos+(width*k/col)-x) < Math.abs(xPos+(width*(k-1)/col)-x)) { return k;} //hef 06/17/01
          }
         return Integer.MAX_VALUE;
       }
       /**
         *  Linkt eine X,Y koordinate einer spalte zu.
         *  @param x x koordinate
         *  @param y y koordinate, obwohl diese berflssig ist.
         *  @retrurn int, die kollonne (col)
         *  @see #getVoltagePointX(int x)
         */
        // hef 15/05/01
        public int getVoltagePointX(int x, int y){return getVoltagePointX(x);}

       /**
         *  wie die Gleichnamige ausser, dass die berflssige x Koordinate nicht angegeben werden muss
         *  @param y y Koordinate
         *  @retrurn int die zeile
         */
        // hef 15/05/01
public int getVoltagePointY(int y){
          // we search for the row that is nearest the cliked point....
          for(int i = row+1; (--i)>=0;){
              if ( Math.abs(yPos+(height*i/row)-y) < Math.abs(yPos+(height*(i-1)/row)-y)) { return i; }  //hef 06/17/01
          }
          return Integer.MAX_VALUE;
        }
        /**
         *  Linkt eine X,Y Cord zu einer zeile
         *  @param x x koordinate, obwohl diese berflssig ist.
         *  @param y y koordinate
         *  @return int, die Zeile.
         *  @see #getVoltagePointY(int y)
         */
        // hef 15/05/01
        public int getVoltagePointY(int x, int y){return getVoltagePointY(y);}

        /**
         * Liefert die Zeit zurckt die zum Berechnen der Matrix bentigt wurde
         * @return long zeit in milisekunden
         */
public long getTimeToCalculate(){return timeToCalculate;}
        /**
         * Liefert die Zeit zurckt die zum zusammenstellen der Matrix bentigt wurde
         * @return long zeit in milisekunden
         */
public long getTimeToAssamable(){return timeToAssamble;}
        /**
         * Liefert die Zeit zurckt die zum Zeichnen bentigt wurde. inkl. interpollieren.
         * @return long zeit in milisekunden
         */
public long getTimeToDraw(){return timeToDraw;}
        /**
         * Liefert die Zeit zurckt die zum Berechnen und Zeichnen der Hhenlinien bentigt wurde
         * @return long zeit in milisekunden
         */
public long getTimeToDrawLevelLine(){return timeToDrawLevelLine;}

        /**
         * Es wird die Matrix Zurck gegeben wie sie NACH dem berechnen war.
         * @return Matrixobjeckt wie es vor dem berechnen war.
         */
public Matrix getSolvedMatrix() {
          return solvedMatrix;
        }

        /**
         * Es wird die Matrix Zurck gegeben wie sie VOR dem berechnen war.
         * @return Matrixobjeckt wie es vor dem berechnen war.
         */
public Matrix getUnSolvedMatrix() {
          return unSolvedMatrix;
        }

/*******************************************************************************
 * the SET procedures
 **************************************************************************** */
        //Setzt die Position hef 03.05.01
        /**
         * Setzt die linke obere Ecke des Gitters
         * @param x x Koordinate
         * @param y y Koordinate
         */
public void setPos( int xPos, int yPos ){ this.xPos = xPos; this.yPos = yPos; changed = true;}

        //Setzt die Dimensionen hef 03.05.01
        /**
         * Setzt die Grsse des Gitters
         * @param height hhe des Gitters
         * @param width Breite des Gitters
         */
public void setDimension( int height, int width ){ this.height = height; this.width = width; changed = true;}

        //Setzt den raster hef 03.05.01
        /**
         * Setzt die spalten und zeilen zahl und somit die auflsung
         * @param col spalten Zahl des Gitters
         * @param row zeilen zahl des gitters
         * @param voltage double Wert der Spannung auf die dieser punkt eingestellt werden soll.
         */
public void setGrid( int col, int row ){ this.col = col; this.row = row; changed = true;}

        /**
         * Setzt eine feste Spannung an einen Festen punkt.
         * @param row zeile in der sich der punkt befindet
         * @param col spalte in der sich der punkt befindet.
         * @param voltage double Wert der Spannung auf die dieser punkt eingestellt werden soll.
         */
        //Spannung Setzen hef 03.05.01
public void setVoltage(int col, int row, double voltage ){
          voltagePoints[row*(this.col+1)+col] = voltage;
          changed = true;
	}

        /**
         * Construktor mit allen mglichen angaben
         * @param xPos x cord der Linken oberen Ecke des Gitters
         * @param yPos y cord der Linken oberen Ecke des Gitters
         * @param width die breite des Gitters
         * @param height die hhe des Gitters
         * @param col die anzahl Spalten  - definiert die Virtuelle x Auflsung des Gitters
         * @param row die anzahl Zeilen   - definiert die Virtuelle y Auflsung des Gitters
         * @see  SimGrid( int xPos, int yPos, int width , int height )
         */
        //Primary Constructor hef 03.05.01
public SimGrid( int xPos, int yPos,  int width , int height , int col, int row ){
           setPos(xPos,yPos);
           setDimension(height,width);
           setGrid(col,row);
           voltagePoints = new double[(row+1)*(col+1)]; //@todo covers the maximum amount of possible voltage points -> too much and should replaced by a vector....
           for (int i=voltagePoints.length;--i>=0;){ voltagePoints[i] = Double.NaN;}
           voltage = new double[(row+1)*(col+1)]; // *WICHTIG* beim updated dieser 2 Zeilen resetVoltagePoints updaten
           changed = false;
           calculated = false;
           timeToAssamble =0;
           timeToCalculate =0;
           timeToDraw =0;
           timeToDrawLevelLine=0;
	}
        /**
         * Construktor nur mit angaben ber die physikalische grsse des Gitters. Als virtuelle Auflsung
         * wird ein zehntel (1/10) der breite und hhe genommen
         * @param xPos x cord der Linken oberen Ecke des Gitters
         * @param yPos y cord der Linken oberen Ecke des Gitters
         * @param width die breite des Gitters
         * @param height die hhe des Gitters
         */
         //secondary, lazy Constuctor hef 03.05.01
public SimGrid( int xPos, int yPos, int width , int height ){ //constructor mit
                                                                     //row = width
                                                                     //col = height
          this(xPos,yPos,height,width,height/10,width/10);
	}

}
