package ch.w3p.currgrid;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import javax.swing.event.TableModelEvent;

/**
 * Tablemodel spezifisch fr die Klasse ch.w3p.currgrid.Matrix - ermglicht die Darstellung eines Matrix Obj in einer Tabelle<BR>
 * berschreibt Zugriffsmethoden des AbstractTableModel
 * Simulates a Current Grid. Mathematic Project I2<br>
 * Authors <a href="mailto:schroeterd@freesurf.ch">Daniel Schrter</a>; <a href="mailto:f.heusser@tic.ch">Fabian Heusser</a><br>
 * Teacher: Dr. Josef F. Brgler<br>
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;<br>
 * Project Homepage: <a href="http://www.w3p.ch/currgrid/">http://www.w3p.ch/currgrid/</a><br>
 * Project Maillist: <a href="mailto:currgrid@w3p.ch">currgrid@w3p.ch</a><br>
 * <br>
 * supported features:<br>
 * interpolatet Plot:<br>
 * interpolatet VoltageOutput;<br>
 * change Voltage Points;<br>
 * delete Voltage Points;<br>
 * delete a Singel Voltage Point;<br>
 * drawLevelLinesM;<br>
 * Matrix ScrPrintOut<br>
 * <br>
 *
 * LEGAL NOTICE<br>
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.<br>
 *<br>
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).<br>
 *<br>
 *
 * @author Daniel Schrter
 * @author Fabian Heusser
 * @version 1.02, 07/03/01
 * @(#) MyTableModel.java
 * @see ch.w3p.currgrid.Matrix
 * @see javax.swing.table.AbstractTableModel
 */
public class MyTableModel extends AbstractTableModel {
  String[] columnNames = {};
  Vector   rows = new Vector();
  Matrix myMatrix;

  /**
   * Konstruktor<BR>
   * Generiert die bentigte Anzahl Spalten mit der Beschriftung.<BR>
   * Fllt die Tabelle mit den Werten der mitgelieferten Matrix
   * @param myMatrix Die Matrix fr die ein TableModel erzeugt werden soll
   * @see ch.w3p.currgrid.Matrix
   */
  public MyTableModel(Matrix myMatrix) {
    this.myMatrix = myMatrix;
    int numberOfColumns =  myMatrix.getSize()+2; //Ax=C matrix
    columnNames = new String[numberOfColumns];
    int column;
    for(column = 0; column < numberOfColumns-2; column++) {
      columnNames[column] = new String(""+column);
    }
    columnNames[column] = new String("x");
    columnNames[column+1] = new String("C");
    // Get all rows.
    rows = new Vector();
    for (int r = 0;r < myMatrix.getSize();r++) {
      Vector newRow = new Vector();
      for (int i = 0; i < (numberOfColumns-2); i++) {
        newRow.addElement(new Double(myMatrix.getElement(i,r)));
      }
      newRow.addElement(new Double(myMatrix.getX(r)));
      newRow.addElement(new Double(myMatrix.getElement(numberOfColumns-2,r)));
      rows.addElement(newRow);
    }
    fireTableChanged(null); // Tell the listeners a new table has arrived.
  }


  /**
   * Liefert den Namen einer Spalte zurck
   * @param column Spalte
   * @return Spaltenname als String
   * @see javax.swing.table.AbstractTableModel
   */
    public String getColumnName(int column) {
        if (columnNames[column] != null) {
            return columnNames[column];
        } else {
            return "";
        }
    }

    /*
    public Class getColumnClass(int column) {
        return Double.class; //all data = Double!!!
    }*/

    /*
    public boolean isCellEditable(int row, int column) {
        return true; //keine Ahnung
    }*/

    /**
     * Liefert die Anzahl Spalten zurck
     * @return int Spaltenanzahl
     * @see javax.swing.table.AbstractTableModel
     */
     public int getColumnCount() {
        return columnNames.length;
    }

    /**
     * Liefert die Anzahl Zeilen zurck
     * @return int Zeilenanzahl
     * @see javax.swing.table.AbstractTableModel
     */
    public int getRowCount() {
        return rows.size();
    }


    /**
     * Liefert das Objekt an der Stelle aRow aColumn zurck
     * @param aRow Zeile
     * @param aColumn Spalte
     * @return Objekt (respektive Double) mit dem Wert
     * @see javax.swing.table.AbstractTableModel
     */
    public Object getValueAt(int aRow, int aColumn) {
        Vector row = (Vector)rows.elementAt(aRow);
        return row.elementAt(aColumn);
    }

    /**
     * Wandelt einen Datentyp der Tabelle in einen String um<BR>
     * !!Achtung alle sind vom Typ Double da ein Matrixobj nur Doublewerte hat!!<BR>
     * @param column Spalte
     * @param value Das umzuwandelnde Objekt
     * @return String Den gewandelten Wert als String
     * @see javax.swing.table.AbstractTableModel
     */
    public String dbRepresentation(int column, Object value) {
      return value.toString();
    }


    /**
     * ndern eines Wertes in der darzustellenden Matrix<BR>
     * !!Wurde nicht implementiert, da die Matrix nicht verndert werden darf!!!!!<BR>
     * Muss zwingend vorhanden sein weil diese Klasse vom Abstrakten AbstractTableModel abstammt.
     * @see javax.swing.table.AbstractTableModel
     */
    public void setValueAt(Object value, int row, int column) {
      System.out.println("can not edit Matrix");
    }
}
