package ch.w3p.currgrid;

import java.awt.*;
import java.awt.event.*;
//import java.awt.image.*;

/**
 * OutputFrame - Displays the SimGrid<br>
 * Simulates a Current Grid. Mathematic Project I2<br>
 * Authors <a href="mailto:schroeterd@freesurf.ch">Daniel Schrter</a>; <a href="mailto:f.heusser@tic.ch">Fabian Heusser</a><br>
 * Teacher: Dr. Josef F. Brgler<br>
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;<br>
 * Project Homepage: <a href="http://www.w3p.ch/currgrid/">http://www.w3p.ch/currgrid/</a><br>
 * Project Maillist: <a href="mailto:currgrid@w3p.ch">currgrid@w3p.ch</a><br>
 * <br>
 * supported features:<br>
 * interpolatet Plot:<br>
 * interpolatet VoltageOutput;<br>
 * change Voltage Points;<br>
 * delete Voltage Points;<br>
 * delete a Singel Voltage Point;<br>
 * drawLevelLinesM;<br>
 * Matrix ScrPrintOut<br>
 * <br>
 *
 * LEGAL NOTICE<br>
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.<br>
 *<br>
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).<br>
 *
 *<br>
 * @author Daniel Schrter
 * @author Fabian Heusser
 * @version 1.02, 07/03/01
 * @(#) OutputFrame.java
 */
public class OutputFrame extends Frame implements WindowListener, ActionListener,ItemListener, MouseListener, MouseMotionListener {

//DoubleBuffer

//Bild fr Output
  private Image outputImage;
  private Graphics outputGraphics;
  private boolean outputImageCreated = false; //is needet because Image can only be created in paint()!!!
  private SimGrid grid;
//GUI
  private Panel controlPanel = new Panel(null);
  private Checkbox gridCheckbox = new Checkbox("grid",false);
  private Checkbox withPointsCheckbox = new Checkbox("points",false);
  private Checkbox levelLinesCheckbox = new Checkbox("hightlines",false);
  private Checkbox interpolQuickinfoCheckbox = new Checkbox("interp. Quickinfo");
  private Checkbox showMatrixCheckbox = new Checkbox("show Matrix");
  private TextField levelLinesTextField = new TextField("5",3);
  private Label timeToAssemble =  new Label("Assembling:  ms");
  private Label timeToCalculate = new Label("Calculating: ms");
  private Label timeToDraw =      new Label("Drawing:     ms");
//Bild fr Doublebuffer
  private Image doubleBufferImage;
  private boolean newCalcBoolean = false;
//Frames fr Matrix
  private MatrixOutputFrame unsolvedMatrixFrame;
  private MatrixOutputFrame solvedMatrixFrame;
//Quickinfo
  private String quickinfo;
  private int quickinfoX = 0;
  private int quickinfoY = 0;

  /**
   * Construktor des Frame-Objekt<BR>
   * -Framepos. definieren<BR>
   * -GUI Zeichnen
   *
   **/
  public OutputFrame() {
    //Einstellungen des Frames
    addWindowListener(this);
    this.setTitle("Ausgabe");
    this.setLocation(100,100);
    this.setSize(500+200+5,500+23+5+17);
    this.setResizable(false);
    this.setEnabled(true);
    this.setBackground(Color.lightGray);
    //Mausbedienung
    addMouseListener(this);
    addMouseMotionListener(this);
    //GUI
    this.setLayout(null);
    this.add(controlPanel);
    controlPanel.setBounds(505+5,280+23,200-5,220);
    controlPanel.setBackground(Color.lightGray);
    controlPanel.add(interpolQuickinfoCheckbox,null);
    //interpolQuickinfoCheckbox.addItemListener(this); braucht es nicht
    interpolQuickinfoCheckbox.setBounds(10,50,150,20);
    controlPanel.add(gridCheckbox, null);
    gridCheckbox.addItemListener(this);
    gridCheckbox.setBounds(10,10,60,20);
    controlPanel.add(withPointsCheckbox,null);
    withPointsCheckbox.addItemListener(this);
    withPointsCheckbox.setBounds(70,10,60,20);
    controlPanel.add(levelLinesCheckbox, null);
    levelLinesCheckbox.addItemListener(this);
    levelLinesCheckbox.setBounds(10,30,80,20);
    controlPanel.add(levelLinesTextField);
    levelLinesTextField.addActionListener(this);
    levelLinesTextField.setBounds(100,30,40,20);
    controlPanel.add(showMatrixCheckbox, null);
    showMatrixCheckbox.addItemListener(this);
    showMatrixCheckbox.setBounds(10,70,100,20);
    //Zeiten
    controlPanel.add(timeToAssemble);
    timeToAssemble.setBounds(10,160,180,20);
    controlPanel.add(timeToCalculate);
    timeToCalculate.setBounds(10,175,180,20);
    controlPanel.add(timeToDraw);
    timeToDraw.setBounds(10,190,180,20);
  }


  /**
   * Wenn das Grid neu berechnet wurde und neu gezeichnet werden soll.<BR>
   * @param b true zum neu zeichnen
   **/
  public void newCalc(boolean b) {
    newCalcBoolean = b;
  }

  /**
   * Teilt dem Frame mit zu welchem Grid-Objekt es gehrt.
   */
  public void setGrid(SimGrid g) {
    grid = g;
  }

  /**
   *  Graphics-Objekt fr das Bild (500*500 Pixels) indem
   *  die Ausgabe gezeichnet werden soll.
   **/
  public Graphics getOutputGraphics() {
    if (outputImageCreated) repaint();
    return outputGraphics;
  }

  /**
   * Zeichnet das Frame<BR>
   * -Bilder zur schnelleren Darstellung werden kreiert<BR>
   * -Quickinfo anzeigen<BR>
   * -Bar mit Max und Min Spannungswert == Farbe?<BR>
   * -Gitter, Punkte, Hhenlinien auf das Gitter zeichnen
   **/
  public void paint(Graphics g) {
    Graphics doubleBufferGraphics;
    setBackground(Color.lightGray);
    long timeToSayGoodBye=0;
    //Creating outputImage and doubleBufferImage
    if (!outputImageCreated){
      outputImage = createImage(500,500);
      outputGraphics = outputImage.getGraphics();
      outputImageCreated = true;
      doubleBufferImage = createImage(200,500+23+5);
      doubleBufferGraphics = doubleBufferImage.getGraphics();
      doubleBufferGraphics.setColor(this.getBackground());
      doubleBufferGraphics.fillRect(0,0,200,500+23+5);
    }
    //Bei neuere Berechnung Ausgabebild neu zeichnen
    if (newCalcBoolean) {
      outputGraphics.setColor(this.getBackground());
      outputGraphics.fillRect(0,0,500,500);
      doubleBufferGraphics = doubleBufferImage.getGraphics();
      doubleBufferGraphics.setColor(this.getBackground());
      doubleBufferGraphics.fillRect(0,0,200,500+23+5);
      g.setColor(this.getBackground());
      g.fillRect(0,0,this.getWidth(),this.getHeight());
      g.fill3DRect(3,23,501,501,false);
      g.setColor(Color.black);
      g.drawString("Calculating...",50,50+23);
      grid.display(getOutputGraphics());
      //Gitter zeichnen
      if (gridCheckbox.getState()){
        grid.drawGrid(getOutputGraphics());
        //grid.drawGridWithPoints(getOutputGraphics(),Color.gray,new Color(0,255,0,80),0,0);
      }
      //Punkte zeichnen
      if (withPointsCheckbox.getState()){
        grid.drawGridWithPoints(getOutputGraphics(),new Color(0,0,0,0),new Color(0,255,0,80),0,0);
      }
      //Hhenlinien zeichnen
      if (levelLinesCheckbox.getState()){
        int lines = 0;
        try {
            lines = Integer.parseInt(levelLinesTextField.getText());
        } catch (NumberFormatException exeption) {
          levelLinesTextField.setText("0");//Textfeld das einen nicht gltigen inhalt hat auf 0
        }
        if (lines < 0) {
          lines = 0;
          levelLinesTextField.setText("0");
        }
        if (lines > 100) {
          lines = 100;
          levelLinesTextField.setText("100");
        }
        double level = (grid.getMaxVoltage()-grid.getMinVoltage())/(lines+1);
        double currentLevel = grid.getMinVoltage()+level;
        for (int i = 0;i < lines;i++){
          grid.drawLevelLine(currentLevel,Color.yellow,getOutputGraphics());
          currentLevel += level;
          timeToSayGoodBye += grid.getTimeToDrawLevelLine();
        }
      }
      //Die Zeiten aktualisieren
      timeToAssemble.setText("Assembling: "+grid.getTimeToAssamable()+"ms");
      timeToCalculate.setText("Calculating: "+grid.getTimeToCalculate()+"ms");
      timeToDraw.setText("Drawing: "+(grid.getTimeToDraw()+timeToSayGoodBye)+"ms");
      //Die Frames fr die Matrizen erschaffen
      if (showMatrixCheckbox.getState()){
        unsolvedMatrixFrame.hide();
        unsolvedMatrixFrame = null;
        solvedMatrixFrame.hide();
        solvedMatrixFrame = null;
        unsolvedMatrixFrame = new MatrixOutputFrame("Unsolved Matrix",grid.getUnSolvedMatrix());
        unsolvedMatrixFrame.setLocation(0,0);
        unsolvedMatrixFrame.show();
        solvedMatrixFrame = new MatrixOutputFrame("Solved Matrix",grid.getSolvedMatrix());
        solvedMatrixFrame.setLocation(20,20);
        solvedMatrixFrame.show();
        this.requestFocus();
        this.toFront();
      }
      newCalcBoolean = false;
    }
    g.drawImage(doubleBufferImage,500+5,0,this);
    //Bar mit Farbe entspricht Wert ?
    doubleBufferGraphics = doubleBufferImage.getGraphics();
    doubleBufferGraphics.setColor(this.getBackground());
    doubleBufferGraphics.draw3DRect(20,40,20,257,false);
    for(int i = 0;i<=255;i++) {
      doubleBufferGraphics.setColor(new Color(255-i,0,i));
      doubleBufferGraphics.drawLine(21,41+i,39,41+i);
    }
    doubleBufferGraphics.setColor(Color.black);
    String str;
    str = ""+grid.getMaxVoltage();
    try{
       str = str.substring(0,10);
      }
    catch (StringIndexOutOfBoundsException f){}
    doubleBufferGraphics.drawString(str+" V",45,49);
    str = ""+grid.getMinVoltage();
    try{
       str = str.substring(0,10);
      }
    catch (StringIndexOutOfBoundsException f){}
    doubleBufferGraphics.drawString(str+" V",45,296);
    g.drawImage(outputImage,4,24, this);
    g.setColor(Color.darkGray);
    g.draw3DRect(3,23,501,501,true);
    //quickinfo anzeigen
    if (quickinfo != null){
      Color col = new Color(255,255,0,150);//yellow Background with Alpha
      g.setColor(col);
      g.fillRect(quickinfoX,quickinfoY,70,15);
      g.setColor(Color.black);
      g.drawRect(quickinfoX,quickinfoY,70,15);
      g.drawString(quickinfo,quickinfoX+3,quickinfoY+12);
    }
  }

  /**
  *  Die update methode wurde berschrieben, da mit DoubleBuffering gearbeitet wird
  **/
  public void update(Graphics g) {
    paint(g);
  }

  /**
   * Falls die Maus ber dem Grid ist wird das Quickinfo angezeigt.
   **/
  public void mouseMoved(MouseEvent e) {
    if ((e.getX() >= 4)&&(e.getX()<=500+4)&&(e.getY()>=25)&&(e.getY()<=500+25)){ //Mouse inside Grid }
      if (!interpolQuickinfoCheckbox.getState()) {
        quickinfo = new String(""+Math.round(grid.getVoltage(grid.getVoltagePointX(e.getX()-4),grid.getVoltagePointY(e.getY()-25))*100000d)/100000d);
      }
      else {
        quickinfo = new String(""+Math.round(grid.getVoltageInterpolated(e.getX()-4,e.getY()-25)*100000d)/100000d);
      }
      try{
      quickinfo = quickinfo.substring(0,10);
      }
      catch (StringIndexOutOfBoundsException f){}
      quickinfoX = e.getX()+10;
      quickinfoY = e.getY()+20;
      //Falls QI zu tief => oben an Mauszeiger
      if (quickinfoY > 510) quickinfoY -= 35;
      if ((quickinfoX > 439) && (quickinfoY > 295)) quickinfoX -= 70;
    }
    else {
      quickinfo = null;
    }
    repaint();
  }

  /**
   * unbenutzt (muss wegen MousListener eingebunden werden)
   **/
  public void mouseDragged(MouseEvent e) { }

  /**
   * unbenutzt (muss wegen MousListener eingebunden werden)
   **/
  public void mouseClicked(MouseEvent e) {
    //System.out.println("Clicked "+e.getX()+";"+e.getY());
  }

  /**
   * unbenutzt (muss wegen MousListener eingebunden werden)
   **/
  public void mouseExited(MouseEvent e) { }

  /**
   * unbenutzt (muss wegen MousListener eingebunden werden)
   **/
  public void mouseEntered(MouseEvent e) { }

  /**
   * unbenutzt (muss wegen MousListener eingebunden werden)
   **/
  public void mouseReleased(MouseEvent e) { }

  /**
   * unbenutzt (muss wegen MousListener eingebunden werden)
   **/
  public void mousePressed(MouseEvent e) { }

  /**
   * Bearbeitet die Benutzeranweisungen der Buttons und des Hhenlinien-Textfeldes
   */
  public void actionPerformed(ActionEvent e) {
      //neu Zeichnen; wieviele und ob Hhenlinien gezeichnet werden, wird in der paint-Methode entschieden
    if (e.getSource() == levelLinesTextField) {
      newCalc(true);
      repaint();
    }
  }


  /**
   * Bearbeitet alle Checkboxnderungen
   */
  public void itemStateChanged(ItemEvent e){
    //neu Zeichnen; ob Gitter gezeichnet wird, wird in der paint-Methode entschieden
    if (e.getSource() == gridCheckbox) {
      newCalc(true);
      repaint();
    }

    //neu Zeichnen; ob Gitter gezeichnet wird, wird in der paint-Methode entschieden
    if (e.getSource() == withPointsCheckbox) {
      newCalc(true);
      repaint();
    }

    //neu Zeichnen; ob die Hhenlinien gezeichnet werden, wird in der paint-Methode entschieden
    if (e.getSource() == levelLinesCheckbox) {
      newCalc(true);
      repaint();
    }

    //die Frames fr die Matrizen erschaffen
    if (e.getSource() == showMatrixCheckbox) {
      if (showMatrixCheckbox.getState()){
        unsolvedMatrixFrame = new MatrixOutputFrame("Unsolved Matrix",grid.getUnSolvedMatrix());
        unsolvedMatrixFrame.setLocation(0,0);
        unsolvedMatrixFrame.show();
        solvedMatrixFrame = new MatrixOutputFrame("Solved Matrix",grid.getSolvedMatrix());
        solvedMatrixFrame.setLocation(20,20);
        solvedMatrixFrame.show();
      }
      else {
        unsolvedMatrixFrame.hide();
        unsolvedMatrixFrame = null;
        solvedMatrixFrame.hide();
        solvedMatrixFrame = null;
      }
    }
  }

  /**
   * unbenutzt (muss wegen WindowListener eingebunden werden)
   **/
  public void windowDeactivated(WindowEvent e){}

  /**
   * unbenutzt (muss wegen WindowListener eingebunden werden)
   **/
  public void windowActivated(WindowEvent e){}

  /**
   * unbenutzt (muss wegen WindowListener eingebunden werden)
   **/
  public void windowDeiconified(WindowEvent e){}

  /**
   * unbenutzt (muss wegen WindowListener eingebunden werden)
   **/
  public void windowIconified(WindowEvent e){}

  /**
   * unbenutzt (muss wegen WindowListener eingebunden werden)
   **/
  public void windowClosed(WindowEvent e){}

  /**
   * Schliessen des Frame
   **/
  public void windowClosing(WindowEvent e){
    this.hide();
  }

  /**
   * unbenutzt (muss wegen WindowListener eingebunden werden)
   **/
  public void windowOpened(WindowEvent e){}


}