package ch.w3p.currgrid;

import java.awt.*;
import javax.swing.*;
import javax.swing.table.*;

/**
 * MatrixOutputFrame -  Stellt eine Matrix in einer Tabelle dar.<br>
 * Simulates a Current Grid. Mathematic Project I2<br>
 * Authors <a href="mailto:schroeterd@freesurf.ch">Daniel Schrter</a>; <a href="mailto:f.heusser@tic.ch">Fabian Heusser</a><br>
 * Teacher: Dr. Josef F. Brgler<br>
 * School: <a href="http://www.hta.fhz.ch">hta.fhz.ch</a>, Horw;<br>
 * Project Homepage: <a href="http://www.w3p.ch/currgrid/">http://www.w3p.ch/currgrid/</a><br>
 * Project Maillist: <a href="mailto:currgrid@w3p.ch">currgrid@w3p.ch</a><br>
 * <br>
 * supported features:<br>
 * interpolatet Plot:<br>
 * interpolatet VoltageOutput;<br>
 * change Voltage Points;<br>
 * delete Voltage Points;<br>
 * delete a Singel Voltage Point;<br>
 * drawLevelLinesM;<br>
 * Matrix ScrPrintOut<br>
 * <br>
 *
 * LEGAL NOTICE<br>
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 * WITH THE RESTRICTION OF SENDING US A MAIL WITH THE MODIFIED
 * SOURCODE IF THE PROJECT IS MODIEFIED.<br>
 *<br>
 * if you like this progi feel free to send us something (beer, chips, playmates, houses....).<br>
 *<br>
 *
 * @author Daniel Schrter
 * @author Fabian Heusser
 * @version 1.02, 07/03/01
 * @(#) MatrixOutputFrame.java
 */
public class MatrixOutputFrame extends JFrame {
  JTable table;
  JScrollPane scrollpane;
  MyTableModel model;


  /** Konstruktor<BR>
   *  Erstellt ein neues Frame mit einer Ax=C Tabelle der mitgelieferten Matrix
   *  @param title Der Titel des Frames
   *  @param matrix Die Matrix von der die Daten Stammen
   */
  public MatrixOutputFrame(String title, Matrix matrix) {
    this.setTitle(title);
    model = new MyTableModel(matrix);
    table = new JTable(model);
    scrollpane = new JScrollPane(table);
    initCommon();
  }

  /** Konstruktor<BR>
   *  Erstellt ein neues Frame mit einer Ax=C Tabelle der mitgelieferten Matrix
   *  @param matrix Die Matrix von der die Daten Stammen
   */
  public MatrixOutputFrame(Matrix matrix) {
    model = new MyTableModel(matrix);
    table = new JTable(model);
    scrollpane = new JScrollPane(table);
    initCommon();
  }

  /**
   * Gemeinsame Initialisierung<BR>
   */
  public void initCommon() {
    this.setBounds(0,0,500,500);
    table.setAutoResizeMode(table.AUTO_RESIZE_OFF);
    table.setRowHeight(20);
    this.getContentPane().add(scrollpane);
    scrollpane.setHorizontalScrollBarPolicy(scrollpane.HORIZONTAL_SCROLLBAR_ALWAYS);
    scrollpane.setVerticalScrollBarPolicy(scrollpane.VERTICAL_SCROLLBAR_ALWAYS);
  }
}

