/*
 * Decompiled with CFR 0.152.
 */
package ch.w3p.currgrid;

import ch.w3p.currgrid.Matrix;
import java.awt.Color;
import java.awt.Graphics;

public class SimGrid {
    private boolean calculated = false;
    private boolean changed = false;
    private double[] voltagePoints;
    private double[] voltage;
    private int xPos;
    private int yPos;
    private int height;
    private int width;
    private int col;
    private int row;
    private final boolean debug = false;
    private long timeToCalculate;
    private long timeToDraw;
    private long timeToAssamble;
    private long timeToDrawLevelLine;
    private Matrix unSolvedMatrix;
    private Matrix solvedMatrix;

    private void calculate() {
        Matrix currentMatrix;
        int k;
        int i;
        long timeCalulationBase = System.currentTimeMillis();
        int[] unknowPoints = new int[(this.col + 1) * (this.row + 1)];
        int pointNr = 0;
        for (i = 0; i <= this.row; ++i) {
            for (k = 0; k <= this.col; ++k) {
                if (!Double.isNaN(this.getDefVoltage(k, i))) continue;
                unknowPoints[i * (this.col + 1) + k] = pointNr++;
            }
        }
        if (pointNr != 0) {
            int k2;
            int i2;
            currentMatrix = new Matrix(pointNr);
            int matrixSize = currentMatrix.getSize();
            int nrOfNeighbors = 0;
            pointNr = 0;
            for (i2 = 0; i2 <= this.row; ++i2) {
                for (k2 = 0; k2 <= this.col; ++k2) {
                    if (!Double.isNaN(this.getDefVoltage(k2, i2))) continue;
                    pointNr = unknowPoints[i2 * (this.col + 1) + k2];
                    if (i2 > 0) {
                        if (Double.isNaN(this.getDefVoltage(k2, i2 - 1))) {
                            currentMatrix.setElement(unknowPoints[(i2 - 1) * (this.col + 1) + k2], pointNr, 1.0);
                        } else {
                            currentMatrix.setElement(matrixSize, pointNr, currentMatrix.getElement(matrixSize, pointNr) - this.getDefVoltage(k2, i2 - 1));
                        }
                        ++nrOfNeighbors;
                    }
                    if (k2 > 0) {
                        if (Double.isNaN(this.getDefVoltage(k2 - 1, i2))) {
                            currentMatrix.setElement(unknowPoints[i2 * (this.col + 1) + k2 - 1], pointNr, 1.0);
                        } else {
                            currentMatrix.setElement(matrixSize, pointNr, currentMatrix.getElement(matrixSize, pointNr) - this.getDefVoltage(k2 - 1, i2));
                        }
                        ++nrOfNeighbors;
                    }
                    if (k2 < this.col) {
                        if (Double.isNaN(this.getDefVoltage(k2 + 1, i2))) {
                            currentMatrix.setElement(unknowPoints[i2 * (this.col + 1) + k2 + 1], pointNr, 1.0);
                        } else {
                            currentMatrix.setElement(matrixSize, pointNr, currentMatrix.getElement(matrixSize, pointNr) - this.getDefVoltage(k2 + 1, i2));
                        }
                        ++nrOfNeighbors;
                    }
                    if (i2 < this.row) {
                        if (Double.isNaN(this.getDefVoltage(k2, i2 + 1))) {
                            currentMatrix.setElement(unknowPoints[(i2 + 1) * (this.col + 1) + k2], pointNr, 1.0);
                        } else {
                            currentMatrix.setElement(matrixSize, pointNr, currentMatrix.getElement(matrixSize, pointNr) - this.getDefVoltage(k2, i2 + 1));
                        }
                        ++nrOfNeighbors;
                    }
                    currentMatrix.setElement(pointNr, pointNr, -nrOfNeighbors);
                    nrOfNeighbors = 0;
                }
            }
            this.timeToAssamble = System.currentTimeMillis() - timeCalulationBase;
            this.unSolvedMatrix = currentMatrix.copy();
            currentMatrix.gaussEliminate();
            this.solvedMatrix = currentMatrix.copy();
            this.timeToCalculate = System.currentTimeMillis() - timeCalulationBase - this.timeToAssamble;
            for (i2 = 0; i2 <= this.row; ++i2) {
                for (k2 = 0; k2 <= this.col; ++k2) {
                    this.voltage[i2 * (this.col + 1) + k2] = Double.isNaN(this.getDefVoltage(k2, i2)) ? currentMatrix.getX(unknowPoints[i2 * (this.col + 1) + k2]) : this.getDefVoltage(k2, i2);
                }
            }
        } else {
            for (i = 0; i <= this.row; ++i) {
                for (k = 0; k <= this.col; ++k) {
                    if (Double.isNaN(this.getDefVoltage(k, i))) continue;
                    this.voltage[i * (this.col + 1) + k] = this.getDefVoltage(k, i);
                }
            }
            this.unSolvedMatrix = new Matrix(1);
            this.solvedMatrix = new Matrix(1);
        }
        currentMatrix = null;
        this.calculated = true;
        this.changed = false;
    }

    public void display(Graphics g) {
        if (!this.calculated || this.changed) {
            this.calculate();
        }
        long timeCalculationBase = System.currentTimeMillis();
        double maxVoltage = this.getMaxVoltage();
        double minVoltage = this.getMinVoltage();
        double deltaVoltage = maxVoltage - minVoltage;
        for (int i = 0; i < this.row; ++i) {
            for (int k = 0; k < this.col; ++k) {
                double v0 = this.getVoltage(k, i);
                double v1 = this.getVoltage(k + 1, i);
                double v3 = this.getVoltage(k, i + 1);
                double v2 = this.getVoltage(k + 1, i + 1);
                double h = (double)this.height / (double)this.row;
                double w = (double)this.width / (double)this.col;
                int l = 0;
                while ((double)l <= h) {
                    int m = 0;
                    while ((double)m <= w) {
                        double vP = (v2 - v3 - v1 + v0) * ((double)m / w) * ((double)l / h) + (v1 - v0) * ((double)m / w) + (v3 - v0) * ((double)l / h) + v0;
                        g.setColor(new Color((int)((double)255 * ((vP - minVoltage) / deltaVoltage)), 0, (int)((double)255 - (double)255 * ((vP - minVoltage) / deltaVoltage))));
                        g.drawLine((int)((double)this.xPos + (double)k * w + (double)m), (int)((double)this.yPos + (double)i * h + (double)l), (int)((double)this.xPos + (double)k * w + (double)m), (int)((double)this.yPos + (double)i * h + (double)l));
                        ++m;
                    }
                    ++l;
                }
            }
        }
        this.timeToDraw = System.currentTimeMillis() - timeCalculationBase;
    }

    public void drawGrid(Graphics g, Color c, int xPos, int yPos) {
        g.setColor(c);
        int i = this.col;
        while (--i > 0) {
            g.drawLine(xPos + this.width * i / this.col, yPos, xPos + this.width * i / this.col, yPos + this.height);
        }
        i = this.row;
        while (--i > 0) {
            g.drawLine(xPos, yPos + this.height * i / this.row, xPos + this.width, yPos + this.height * i / this.row);
        }
    }

    public void drawGrid(Graphics g, Color c) {
        g.setColor(c);
        int i = this.col;
        while (--i > 0) {
            g.drawLine(this.xPos + this.width * i / this.col, this.yPos, this.xPos + this.width * i / this.col, this.yPos + this.height);
        }
        i = this.row;
        while (--i > 0) {
            g.drawLine(this.xPos, this.yPos + this.height * i / this.row, this.xPos + this.width, this.yPos + this.height * i / this.row);
        }
    }

    public void drawGrid(Graphics g) {
        this.drawGrid(g, Color.gray);
    }

    public void drawGridWithPoints(Graphics g, Color cGrid, Color cPoints, int xPos, int yPos) {
        Color c = g.getColor();
        this.drawGrid(g, cGrid, xPos, yPos);
        g.setColor(cPoints);
        for (int i = 0; i <= this.row; ++i) {
            for (int k = 0; k <= this.col; ++k) {
                if (Double.isNaN(this.getDefVoltage(k, i))) continue;
                g.fillOval(xPos + this.width * k / this.col - this.width / this.col / 4, yPos + this.height * i / this.row - this.height / this.row / 4, this.width / this.col / 2, this.height / this.row / 2);
            }
        }
        g.setColor(c);
    }

    public void drawGridWithPoints(Graphics g, Color cGrid, Color cPoints) {
        this.drawGrid(g, cGrid);
        for (int i = 0; i <= this.row; ++i) {
            for (int k = 0; k <= this.col; ++k) {
                if (Double.isNaN(this.getDefVoltage(k, i))) continue;
                g.fillOval(this.xPos + this.width * k / this.col - this.width / this.col / 8, this.yPos + this.height * i / this.row - this.height / this.row / 8, this.width / this.col / 4, this.height / this.row / 4);
            }
        }
    }

    public void drawGridWithPoints(Graphics g, Color cPoints) {
        this.drawGridWithPoints(g, Color.gray, cPoints);
    }

    public void drawGridWithPoints(Graphics g) {
        this.drawGridWithPoints(g, Color.gray, Color.red);
    }

    public void drawLevelLine(double level, Color c, Graphics g, double toleranzRelativ) {
        long timeCalculationBase = System.currentTimeMillis();
        Color cBack = g.getColor();
        g.setColor(c);
        double toleranz = (this.getMaxVoltage() - this.getMinVoltage()) * (toleranzRelativ / (double)100);
        for (int i = 0; i < this.row; ++i) {
            for (int k = 0; k < this.col; ++k) {
                double v0 = this.getVoltage(k, i);
                double v1 = this.getVoltage(k + 1, i);
                double v3 = this.getVoltage(k, i + 1);
                double v2 = this.getVoltage(k + 1, i + 1);
                double h = (double)this.height / (double)this.row;
                double w = (double)this.width / (double)this.col;
                int l = 0;
                while ((double)l <= h) {
                    int m = 0;
                    while ((double)m <= w) {
                        double vP = (v2 - v3 - v1 + v0) * ((double)m / w) * ((double)l / h) + (v1 - v0) * ((double)m / w) + (v3 - v0) * ((double)l / h) + v0;
                        if (vP < level + toleranz && vP > level - toleranz) {
                            g.drawLine((int)((double)this.xPos + (double)k * w + (double)m), (int)((double)this.yPos + (double)i * h + (double)l), (int)((double)this.xPos + (double)k * w + (double)m), (int)((double)this.yPos + (double)i * h + (double)l));
                        }
                        ++m;
                    }
                    ++l;
                }
            }
        }
        g.setColor(cBack);
        this.timeToDrawLevelLine = System.currentTimeMillis() - timeCalculationBase;
    }

    public void drawLevelLine(double level, Color c, Graphics g) {
        this.drawLevelLine(level, c, g, 0.1);
    }

    public double getVoltage(int col, int row) {
        boolean i = false;
        if (!this.calculated) {
            return this.getDefVoltage(col, row);
        }
        try {
            double d = this.voltage[row * (this.col + 1) + col];
            return d;
        }
        catch (Exception e) {
            double d = Double.NaN;
            return d;
        }
    }

    public double[] getVoltagesForSave() {
        return this.voltage;
    }

    public double getDefVoltage(int col, int row) {
        return this.voltagePoints[row * (this.col + 1) + col];
    }

    public double getVoltageInterpolated(int x, int y) {
        int i;
        int k;
        for (k = 0; k <= this.col && x - (this.xPos + this.width * k / this.col) >= 0; ++k) {
        }
        for (i = 0; i <= this.row && y - (this.yPos + this.height * i / this.row) >= 0; ++i) {
        }
        double v0 = this.getVoltage(--k, --i);
        double v1 = this.getVoltage(k + 1, i);
        double v3 = this.getVoltage(k, i + 1);
        double v2 = this.getVoltage(k + 1, i + 1);
        double h = this.height / this.row;
        double w = this.width / this.col;
        int l = y + 1 - (this.yPos + this.height * i / this.row);
        int m = x - (this.xPos + this.width * k / this.col);
        return (v2 - v3 - v1 + v0) * ((double)m / h) * ((double)l / w) + (v1 - v0) * ((double)m / h) + (v3 - v0) * ((double)l / w) + v0;
    }

    public double getMaxVoltage() {
        double maxVoltage = 0.0;
        int i = this.voltage.length;
        while (--i >= 0) {
            if (!(this.voltage[i] > maxVoltage)) continue;
            maxVoltage = this.voltage[i];
        }
        return maxVoltage;
    }

    public double getMinVoltage() {
        double minVoltage = 0.0;
        int i = this.voltage.length;
        while (--i >= 0) {
            if (!(this.voltage[i] < minVoltage)) continue;
            minVoltage = this.voltage[i];
        }
        return minVoltage;
    }

    public void resetVoltagePoints() {
        this.voltagePoints = new double[this.row * this.col];
        this.voltage = new double[this.row * (this.col + 1) + this.col + 1];
        this.timeToCalculate = 0L;
        this.timeToAssamble = 0L;
        this.timeToDraw = 0L;
        this.timeToDrawLevelLine = 0L;
    }

    public int getVoltagePointX(int x) {
        int k = this.col + 1;
        while (--k >= 0) {
            if (Math.abs(this.xPos + this.width * k / this.col - x) >= Math.abs(this.xPos + this.width * (k - 1) / this.col - x)) continue;
            return k;
        }
        return Integer.MAX_VALUE;
    }

    public int getVoltagePointX(int x, int y) {
        return this.getVoltagePointX(x);
    }

    public int getVoltagePointY(int y) {
        int i = this.row + 1;
        while (--i >= 0) {
            if (Math.abs(this.yPos + this.height * i / this.row - y) >= Math.abs(this.yPos + this.height * (i - 1) / this.row - y)) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    public int getVoltagePointY(int x, int y) {
        return this.getVoltagePointY(y);
    }

    public long getTimeToCalculate() {
        return this.timeToCalculate;
    }

    public long getTimeToAssamable() {
        return this.timeToAssamble;
    }

    public long getTimeToDraw() {
        return this.timeToDraw;
    }

    public long getTimeToDrawLevelLine() {
        return this.timeToDrawLevelLine;
    }

    public Matrix getSolvedMatrix() {
        return this.solvedMatrix;
    }

    public Matrix getUnSolvedMatrix() {
        return this.unSolvedMatrix;
    }

    public void setPos(int xPos, int yPos) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.changed = true;
    }

    public void setDimension(int height, int width) {
        this.height = height;
        this.width = width;
        this.changed = true;
    }

    public void setGrid(int col, int row) {
        this.col = col;
        this.row = row;
        this.changed = true;
    }

    public void setVoltage(int col, int row, double voltage) {
        this.voltagePoints[row * (this.col + 1) + col] = voltage;
        this.changed = true;
    }

    public SimGrid(int xPos, int yPos, int width, int height, int col, int row) {
        this.setPos(xPos, yPos);
        this.setDimension(height, width);
        this.setGrid(col, row);
        this.voltagePoints = new double[(row + 1) * (col + 1)];
        int i = this.voltagePoints.length;
        while (--i >= 0) {
            this.voltagePoints[i] = Double.NaN;
        }
        this.voltage = new double[(row + 1) * (col + 1)];
        this.changed = false;
        this.calculated = false;
        this.timeToAssamble = 0L;
        this.timeToCalculate = 0L;
        this.timeToDraw = 0L;
        this.timeToDrawLevelLine = 0L;
    }

    public SimGrid(int xPos, int yPos, int width, int height) {
        this(xPos, yPos, height, width, height / 10, width / 10);
    }
}

