/*
 * Decompiled with CFR 0.152.
 */
package ch.w3p.currgrid;

import ch.w3p.currgrid.MatrixOutputFrame;
import ch.w3p.currgrid.SimGrid;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class OutputFrame
extends Frame
implements WindowListener,
ActionListener,
ItemListener,
MouseListener,
MouseMotionListener {
    private Image outputImage;
    private Graphics outputGraphics;
    private boolean outputImageCreated = false;
    private SimGrid grid;
    private Panel controlPanel = new Panel(null);
    private Checkbox gridCheckbox = new Checkbox("grid", false);
    private Checkbox withPointsCheckbox = new Checkbox("points", false);
    private Checkbox levelLinesCheckbox = new Checkbox("hightlines", false);
    private Checkbox interpolQuickinfoCheckbox = new Checkbox("interp. Quickinfo");
    private Checkbox showMatrixCheckbox = new Checkbox("show Matrix");
    private TextField levelLinesTextField = new TextField("5", 3);
    private Label timeToAssemble = new Label("Assembling:  ms");
    private Label timeToCalculate = new Label("Calculating: ms");
    private Label timeToDraw = new Label("Drawing:     ms");
    private Image doubleBufferImage;
    private boolean newCalcBoolean = false;
    private MatrixOutputFrame unsolvedMatrixFrame;
    private MatrixOutputFrame solvedMatrixFrame;
    private String quickinfo;
    private int quickinfoX = 0;
    private int quickinfoY = 0;

    public OutputFrame() {
        this.addWindowListener(this);
        this.setTitle("Ausgabe");
        ((Component)this).setLocation(100, 100);
        ((Component)this).setSize(705, 545);
        this.setResizable(false);
        this.setEnabled(true);
        ((Component)this).setBackground(Color.lightGray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setLayout(null);
        this.add(this.controlPanel);
        this.controlPanel.setBounds(510, 303, 195, 220);
        this.controlPanel.setBackground(Color.lightGray);
        this.controlPanel.add((Component)this.interpolQuickinfoCheckbox, null);
        this.interpolQuickinfoCheckbox.setBounds(10, 50, 150, 20);
        this.controlPanel.add((Component)this.gridCheckbox, null);
        this.gridCheckbox.addItemListener(this);
        this.gridCheckbox.setBounds(10, 10, 60, 20);
        this.controlPanel.add((Component)this.withPointsCheckbox, null);
        this.withPointsCheckbox.addItemListener(this);
        this.withPointsCheckbox.setBounds(70, 10, 60, 20);
        this.controlPanel.add((Component)this.levelLinesCheckbox, null);
        this.levelLinesCheckbox.addItemListener(this);
        this.levelLinesCheckbox.setBounds(10, 30, 80, 20);
        this.controlPanel.add(this.levelLinesTextField);
        this.levelLinesTextField.addActionListener(this);
        this.levelLinesTextField.setBounds(100, 30, 40, 20);
        this.controlPanel.add((Component)this.showMatrixCheckbox, null);
        this.showMatrixCheckbox.addItemListener(this);
        this.showMatrixCheckbox.setBounds(10, 70, 100, 20);
        this.controlPanel.add(this.timeToAssemble);
        this.timeToAssemble.setBounds(10, 160, 180, 20);
        this.controlPanel.add(this.timeToCalculate);
        this.timeToCalculate.setBounds(10, 175, 180, 20);
        this.controlPanel.add(this.timeToDraw);
        this.timeToDraw.setBounds(10, 190, 180, 20);
    }

    public void newCalc(boolean b) {
        this.newCalcBoolean = b;
    }

    public void setGrid(SimGrid g) {
        this.grid = g;
    }

    public Graphics getOutputGraphics() {
        if (this.outputImageCreated) {
            this.repaint();
        }
        return this.outputGraphics;
    }

    public void paint(Graphics g) {
        Graphics doubleBufferGraphics;
        ((Component)this).setBackground(Color.lightGray);
        long timeToSayGoodBye = 0L;
        if (!this.outputImageCreated) {
            this.outputImage = this.createImage(500, 500);
            this.outputGraphics = this.outputImage.getGraphics();
            this.outputImageCreated = true;
            this.doubleBufferImage = this.createImage(200, 528);
            doubleBufferGraphics = this.doubleBufferImage.getGraphics();
            doubleBufferGraphics.setColor(((Component)this).getBackground());
            doubleBufferGraphics.fillRect(0, 0, 200, 528);
        }
        if (this.newCalcBoolean) {
            this.outputGraphics.setColor(((Component)this).getBackground());
            this.outputGraphics.fillRect(0, 0, 500, 500);
            doubleBufferGraphics = this.doubleBufferImage.getGraphics();
            doubleBufferGraphics.setColor(((Component)this).getBackground());
            doubleBufferGraphics.fillRect(0, 0, 200, 528);
            g.setColor(((Component)this).getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.fill3DRect(3, 23, 501, 501, false);
            g.setColor(Color.black);
            g.drawString("Calculating...", 50, 73);
            this.grid.display(this.getOutputGraphics());
            if (this.gridCheckbox.getState()) {
                this.grid.drawGrid(this.getOutputGraphics());
            }
            if (this.withPointsCheckbox.getState()) {
                this.grid.drawGridWithPoints(this.getOutputGraphics(), new Color(0, 0, 0, 0), new Color(0, 255, 0, 80), 0, 0);
            }
            if (this.levelLinesCheckbox.getState()) {
                int lines = 0;
                try {
                    lines = Integer.parseInt(this.levelLinesTextField.getText());
                }
                catch (NumberFormatException exeption) {
                    this.levelLinesTextField.setText("0");
                }
                if (lines < 0) {
                    lines = 0;
                    this.levelLinesTextField.setText("0");
                }
                if (lines > 100) {
                    lines = 100;
                    this.levelLinesTextField.setText("100");
                }
                double level = (this.grid.getMaxVoltage() - this.grid.getMinVoltage()) / (double)(lines + 1);
                double currentLevel = this.grid.getMinVoltage() + level;
                for (int i = 0; i < lines; ++i) {
                    this.grid.drawLevelLine(currentLevel, Color.yellow, this.getOutputGraphics());
                    currentLevel += level;
                    timeToSayGoodBye += this.grid.getTimeToDrawLevelLine();
                }
            }
            this.timeToAssemble.setText(String.valueOf(String.valueOf(new StringBuffer("Assembling: ").append(this.grid.getTimeToAssamable()).append("ms"))));
            this.timeToCalculate.setText(String.valueOf(String.valueOf(new StringBuffer("Calculating: ").append(this.grid.getTimeToCalculate()).append("ms"))));
            this.timeToDraw.setText(String.valueOf(String.valueOf(new StringBuffer("Drawing: ").append(this.grid.getTimeToDraw() + timeToSayGoodBye).append("ms"))));
            if (this.showMatrixCheckbox.getState()) {
                this.unsolvedMatrixFrame.hide();
                this.unsolvedMatrixFrame = null;
                this.solvedMatrixFrame.hide();
                this.solvedMatrixFrame = null;
                this.unsolvedMatrixFrame = new MatrixOutputFrame("Unsolved Matrix", this.grid.getUnSolvedMatrix());
                ((Component)this.unsolvedMatrixFrame).setLocation(0, 0);
                this.unsolvedMatrixFrame.show();
                this.solvedMatrixFrame = new MatrixOutputFrame("Solved Matrix", this.grid.getSolvedMatrix());
                ((Component)this.solvedMatrixFrame).setLocation(20, 20);
                this.solvedMatrixFrame.show();
                this.requestFocus();
                this.toFront();
            }
            this.newCalcBoolean = false;
        }
        g.drawImage(this.doubleBufferImage, 505, 0, this);
        doubleBufferGraphics = this.doubleBufferImage.getGraphics();
        doubleBufferGraphics.setColor(((Component)this).getBackground());
        doubleBufferGraphics.draw3DRect(20, 40, 20, 257, false);
        for (int i = 0; i <= 255; ++i) {
            doubleBufferGraphics.setColor(new Color(255 - i, 0, i));
            doubleBufferGraphics.drawLine(21, 41 + i, 39, 41 + i);
        }
        doubleBufferGraphics.setColor(Color.black);
        String str = "".concat(String.valueOf(String.valueOf(this.grid.getMaxVoltage())));
        try {
            str = str.substring(0, 10);
        }
        catch (StringIndexOutOfBoundsException level) {
            // empty catch block
        }
        doubleBufferGraphics.drawString(String.valueOf(String.valueOf(str)).concat(" V"), 45, 49);
        str = "".concat(String.valueOf(String.valueOf(this.grid.getMinVoltage())));
        try {
            str = str.substring(0, 10);
        }
        catch (StringIndexOutOfBoundsException level) {
            // empty catch block
        }
        doubleBufferGraphics.drawString(String.valueOf(String.valueOf(str)).concat(" V"), 45, 296);
        g.drawImage(this.outputImage, 4, 24, this);
        g.setColor(Color.darkGray);
        g.draw3DRect(3, 23, 501, 501, true);
        if (this.quickinfo != null) {
            Color col = new Color(255, 255, 0, 150);
            g.setColor(col);
            g.fillRect(this.quickinfoX, this.quickinfoY, 70, 15);
            g.setColor(Color.black);
            g.drawRect(this.quickinfoX, this.quickinfoY, 70, 15);
            g.drawString(this.quickinfo, this.quickinfoX + 3, this.quickinfoY + 12);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void mouseMoved(MouseEvent e) {
        if (e.getX() >= 4 && e.getX() <= 504 && e.getY() >= 25 && e.getY() <= 525) {
            this.quickinfo = !this.interpolQuickinfoCheckbox.getState() ? new String("".concat(String.valueOf(String.valueOf((double)Math.round(this.grid.getVoltage(this.grid.getVoltagePointX(e.getX() - 4), this.grid.getVoltagePointY(e.getY() - 25)) * 100000.0) / 100000.0)))) : new String("".concat(String.valueOf(String.valueOf((double)Math.round(this.grid.getVoltageInterpolated(e.getX() - 4, e.getY() - 25) * 100000.0) / 100000.0))));
            try {
                this.quickinfo = this.quickinfo.substring(0, 10);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            this.quickinfoX = e.getX() + 10;
            this.quickinfoY = e.getY() + 20;
            if (this.quickinfoY > 510) {
                this.quickinfoY -= 35;
            }
            if (this.quickinfoX > 439 && this.quickinfoY > 295) {
                this.quickinfoX -= 70;
            }
        } else {
            this.quickinfo = null;
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.levelLinesTextField) {
            this.newCalc(true);
            this.repaint();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.gridCheckbox) {
            this.newCalc(true);
            this.repaint();
        }
        if (e.getSource() == this.withPointsCheckbox) {
            this.newCalc(true);
            this.repaint();
        }
        if (e.getSource() == this.levelLinesCheckbox) {
            this.newCalc(true);
            this.repaint();
        }
        if (e.getSource() == this.showMatrixCheckbox) {
            if (this.showMatrixCheckbox.getState()) {
                this.unsolvedMatrixFrame = new MatrixOutputFrame("Unsolved Matrix", this.grid.getUnSolvedMatrix());
                ((Component)this.unsolvedMatrixFrame).setLocation(0, 0);
                this.unsolvedMatrixFrame.show();
                this.solvedMatrixFrame = new MatrixOutputFrame("Solved Matrix", this.grid.getSolvedMatrix());
                ((Component)this.solvedMatrixFrame).setLocation(20, 20);
                this.solvedMatrixFrame.show();
            } else {
                this.unsolvedMatrixFrame.hide();
                this.unsolvedMatrixFrame = null;
                this.solvedMatrixFrame.hide();
                this.solvedMatrixFrame = null;
            }
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.hide();
    }

    public void windowOpened(WindowEvent e) {
    }
}

