/*
 * Decompiled with CFR 0.152.
 */
package ch.w3p.currgrid;

public class Matrix {
    private double[][] matrix;
    private double[] x;
    private int n;

    public Matrix(int numberOfUnknown) {
        if (numberOfUnknown > 0) {
            this.n = numberOfUnknown;
            this.x = new double[this.n];
            this.matrix = new double[this.n + 1][this.n];
            for (int zY = 0; zY < this.matrix[0].length; ++zY) {
                for (int zX = 0; zX < this.matrix.length; ++zX) {
                    this.matrix[zX][zY] = 0.0;
                }
            }
            for (int z = 0; z < this.x.length; ++z) {
                this.x[z] = 0.0;
            }
        } else {
            System.out.println("numberOfUnknown out of boundaries Error while creating Matrix-Object");
        }
    }

    public int getSize() {
        return this.n;
    }

    public void setElement(int zX, int zY, double value) {
        if (zX < this.matrix.length && zY < this.matrix[0].length) {
            this.matrix[zX][zY] = value;
        } else {
            System.out.println("Error while accessing method matrix.setElement");
        }
    }

    public double getElement(int zX, int zY) {
        if (zX < this.matrix.length && zY < this.matrix[0].length) {
            return this.matrix[zX][zY];
        }
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Error while accessing method Matrix.getElement X=").append(zX).append(" Y=").append(zY))));
        return Double.NaN;
    }

    public double getX(int z) {
        if (z < this.x.length) {
            return this.x[z];
        }
        System.out.println("Error while accessing method matrix.getX X=".concat(String.valueOf(String.valueOf(z))));
        return Double.NaN;
    }

    public void setX(int z, double value) {
        if (z < this.x.length) {
            this.x[z] = value;
        } else {
            System.out.println("Error while accessing method matrix.setX X=".concat(String.valueOf(String.valueOf(z))));
        }
    }

    public void gaussEliminate() {
        for (int k = 0; k < this.n - 1; ++k) {
            for (int i = k + 1; i < this.n; ++i) {
                double factor = this.matrix[k][i] / this.matrix[k][k];
                for (int j = k; j <= this.n; ++j) {
                    double[] dArray = this.matrix[j];
                    int n = i;
                    dArray[n] = dArray[n] - factor * this.matrix[j][k];
                }
            }
        }
        this.x[this.n - 1] = this.matrix[this.n][this.n - 1] / this.matrix[this.n - 1][this.n - 1];
        for (int i = this.n - 2; i >= 0; --i) {
            double sum = 0.0;
            for (int j = this.n - 1; j >= i + 1; --j) {
                sum += this.matrix[j][i] * this.x[j];
            }
            this.x[i] = (this.matrix[this.n][i] - sum) / this.matrix[i][i];
        }
    }

    public Matrix copy() {
        Matrix clone = new Matrix(this.n);
        for (int zY = 0; zY < this.matrix[0].length; ++zY) {
            for (int zX = 0; zX < this.matrix.length; ++zX) {
                clone.setElement(zX, zY, this.matrix[zX][zY]);
            }
        }
        for (int z = 0; z < this.x.length; ++z) {
            clone.setX(z, this.x[z]);
        }
        return clone;
    }
}

