/*
 * Decompiled with CFR 0.152.
 */
package ch.w3p.currgrid;

import ch.w3p.currgrid.OutputFrame;
import ch.w3p.currgrid.SimGrid;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class CurrSimLet
extends Applet
implements ActionListener,
AdjustmentListener,
MouseListener,
MouseMotionListener {
    private Label titel = new Label("Simgrid by Heusser & Schr\u00f6ter");
    private Panel controlPanel;
    private Panel gridPanel;
    private Label rowsLabel;
    private Label colsLabel;
    private Label rowsActualLabel;
    private Label colsActualLabel;
    private Scrollbar rowsBar;
    private Scrollbar colsBar;
    private Label vLabel;
    private TextField vTextField;
    private int mouseKlickedX = 0;
    private int mouseKlickedY = 0;
    private Button randomButton;
    private Button setDefButton;
    private Choice setDefChoice;
    private Button resetButton;
    private Button calcButton;
    private OutputFrame outputFrame1;
    private Image simImage;
    private Graphics simGraphics;
    private boolean simImageCreated = false;
    private boolean simImageChanged = false;
    private SimGrid grid;
    private static int gridCols = 20;
    private static int gridRows = 20;
    private String quickinfo;
    private int quickinfoX = 0;
    private int quickinfoY = 0;

    public void init() {
        this.setEnabled(true);
        this.setBackground(Color.lightGray);
        this.controlPanel = new Panel(null);
        this.add(this.controlPanel);
        this.controlPanel.setBounds(0, 0, 503, 90);
        this.controlPanel.add(this.titel);
        this.titel.setBounds(170, 5, 250, 20);
        this.setName("Projekt Simgrid by Heusser & Schr\u00f6ter");
        this.rowsLabel = new Label("cols:");
        this.controlPanel.add(this.rowsLabel);
        this.rowsLabel.setBounds(15, 15, 40, 10);
        this.rowsBar = new Scrollbar(0, 0, 1, 1, 50);
        this.controlPanel.add(this.rowsBar);
        this.rowsBar.addAdjustmentListener(this);
        this.rowsBar.setBounds(15, 35, 60, 15);
        this.colsLabel = new Label("rows:");
        this.controlPanel.add(this.colsLabel);
        this.colsLabel.setBounds(80, 15, 60, 10);
        this.colsBar = new Scrollbar(0, 0, 1, 1, 50);
        this.controlPanel.add(this.colsBar);
        this.colsBar.addAdjustmentListener(this);
        this.colsBar.setBounds(80, 35, 60, 15);
        this.rowsActualLabel = new Label("".concat(String.valueOf(String.valueOf(gridCols))));
        this.controlPanel.add(this.rowsActualLabel);
        this.rowsActualLabel.setBounds(15, 50, 40, 10);
        this.colsActualLabel = new Label("".concat(String.valueOf(String.valueOf(gridRows))));
        this.controlPanel.add(this.colsActualLabel);
        this.colsActualLabel.setBounds(80, 50, 70, 10);
        this.rowsBar.setValue(gridCols);
        this.colsBar.setValue(gridRows);
        this.vLabel = new Label("U (in V):");
        this.controlPanel.add(this.vLabel);
        this.vLabel.setBounds(125, 65, 45, 15);
        this.vTextField = new TextField("", 5);
        this.controlPanel.add(this.vTextField);
        this.vTextField.addActionListener(this);
        this.vTextField.setBounds(170, 60, 70, 20);
        this.vTextField.setText("0");
        this.randomButton = new Button("random");
        this.controlPanel.add(this.randomButton);
        this.randomButton.addActionListener(this);
        this.randomButton.setBounds(250, 60, 60, 20);
        this.setDefButton = new Button("set");
        this.controlPanel.add(this.setDefButton);
        this.setDefButton.addActionListener(this);
        this.setDefButton.setBounds(360, 35, 40, 20);
        this.setDefChoice = new Choice();
        this.controlPanel.add(this.setDefChoice);
        this.setDefChoice.setBounds(250, 35, 100, 20);
        this.setDefChoice.add("Dr.J.B.Muster");
        this.setDefChoice.add("Muster2");
        this.setDefChoice.add("Muster3");
        this.resetButton = new Button("reset");
        this.controlPanel.add(this.resetButton);
        this.resetButton.addActionListener(this);
        this.resetButton.setBounds(430, 10, 60, 20);
        this.calcButton = new Button("calculate");
        this.controlPanel.add(this.calcButton);
        this.calcButton.addActionListener(this);
        this.calcButton.setBounds(430, 60, 60, 20);
        this.outputFrame1 = new OutputFrame();
        this.grid = new SimGrid(0, 0, 500, 500, gridCols, gridRows);
        this.outputFrame1.setGrid(this.grid);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(Color.lightGray);
    }

    public void paint(Graphics g) {
        if (!this.simImageCreated) {
            this.simImage = this.createImage(500, 500);
            this.simGraphics = this.simImage.getGraphics();
            this.simGraphics.setColor(this.getBackground());
            this.simGraphics.fillRect(0, 0, 500, 500);
            this.grid.drawGridWithPoints(this.simGraphics, Color.black, Color.red);
        }
        if (this.simImageChanged) {
            this.grid.drawGridWithPoints(this.simGraphics, Color.black, Color.red, 0, 0);
        }
        g.drawImage(this.simImage, 1, 97, this);
        g.setColor(Color.darkGray);
        g.draw3DRect(0, 96, 501, 501, true);
        if (this.quickinfo != null) {
            Color col = new Color(255, 255, 0, 150);
            g.setColor(col);
            g.fillRect(this.quickinfoX, this.quickinfoY, 100, 15);
            g.setColor(Color.black);
            g.drawRect(this.quickinfoX, this.quickinfoY, 100, 15);
            g.drawString(this.quickinfo, this.quickinfoX + 3, this.quickinfoY + 12);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void actionPerformed(ActionEvent e) {
        boolean error = false;
        if (e.getSource() == this.vTextField) {
            double v;
            try {
                v = Double.parseDouble(this.vTextField.getText());
            }
            catch (NumberFormatException exeption) {
                this.vTextField.setText("0");
                v = 0.0;
            }
            if (v < -100000.0 || v > 100000.0) {
                this.vTextField.setText("0");
            }
        }
        if (e.getSource() == this.randomButton) {
            for (int i = 0; i < 8; ++i) {
                this.grid.setVoltage((int)(Math.random() * (double)(this.colsBar.getValue() + 1)), (int)(Math.random() * (double)(this.rowsBar.getValue() + 1)), (Math.random() - 0.5) * (double)2000);
            }
            this.simImageChanged = true;
            this.repaint();
        }
        if (e.getSource() == this.setDefButton) {
            if (this.setDefChoice.getSelectedItem() == "Muster3") {
                this.grid.setVoltage(0, 0, 100.0);
                this.grid.setVoltage(this.rowsBar.getValue(), this.colsBar.getValue(), 100.0);
                this.grid.setVoltage(this.rowsBar.getValue(), 0, -100.0);
                this.grid.setVoltage(0, this.colsBar.getValue(), -100.0);
            }
            if (this.setDefChoice.getSelectedItem() == "Muster2") {
                this.grid.setVoltage(0, 0, -100.0);
                this.grid.setVoltage(this.rowsBar.getValue(), this.colsBar.getValue(), -100.0);
                this.grid.setVoltage(this.rowsBar.getValue(), 0, 100.0);
                this.grid.setVoltage(0, this.colsBar.getValue(), 100.0);
                this.grid.setVoltage(this.rowsBar.getValue() / 2, this.colsBar.getValue() / 2, 100.0);
            }
            if (this.setDefChoice.getSelectedItem() == "Dr.J.B.Muster") {
                int i;
                for (i = 0; i < this.rowsBar.getValue() / 2 + 1; ++i) {
                    this.grid.setVoltage(i, 0, 5.0);
                }
                for (i = this.rowsBar.getValue() / 2; i <= this.rowsBar.getValue(); ++i) {
                    this.grid.setVoltage(i, this.colsBar.getValue(), 0.0);
                }
            }
            this.simImageChanged = true;
            this.repaint();
        }
        if (e.getSource() == this.calcButton) {
            this.outputFrame1.newCalc(true);
            this.outputFrame1.repaint();
            ((Component)this.outputFrame1).setVisible(true);
            this.outputFrame1.setEnabled(true);
        }
        if (e.getSource() == this.resetButton) {
            this.grid = new SimGrid(0, 0, 500, 500, this.rowsBar.getValue(), this.colsBar.getValue());
            this.outputFrame1.setGrid(this.grid);
            this.simImageChanged = true;
            this.repaint();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.rowsBar) {
            this.rowsActualLabel.setText("".concat(String.valueOf(String.valueOf(this.rowsBar.getValue()))));
            this.grid = new SimGrid(0, 0, 500, 500, this.rowsBar.getValue(), this.colsBar.getValue());
            this.outputFrame1.setGrid(this.grid);
        }
        if (e.getSource() == this.colsBar) {
            this.colsActualLabel.setText("".concat(String.valueOf(String.valueOf(this.colsBar.getValue()))));
            this.grid = new SimGrid(0, 0, 500, 500, this.rowsBar.getValue(), this.colsBar.getValue());
            this.outputFrame1.setGrid(this.grid);
        }
        this.simImageChanged = true;
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (this.mouseKlickedX > -1 && this.mouseKlickedY > -1) {
            double v = Double.NaN;
            boolean error = false;
            if (e.getModifiers() == 16) {
                try {
                    v = Double.parseDouble(this.vTextField.getText());
                }
                catch (NumberFormatException exeption) {
                    this.vTextField.setText("0");
                    v = 0.0;
                    error = true;
                }
                if (v < -100000.0 || v > 100000.0) {
                    this.vTextField.setText("0");
                    error = true;
                }
            }
            if (e.getModifiers() == 8) {
                // empty if block
            }
            if (e.getModifiers() == 4) {
                v = Double.NaN;
            }
            if (!error) {
                int tmp;
                int rowEnd = this.grid.getVoltagePointX(e.getX() - 1);
                int colEnd = this.grid.getVoltagePointY(e.getY() - 97);
                int rowStart = this.grid.getVoltagePointX(this.mouseKlickedX - 1);
                int colStart = this.grid.getVoltagePointY(this.mouseKlickedY - 97);
                if (rowEnd > this.rowsBar.getValue()) {
                    rowEnd = this.rowsBar.getValue();
                }
                if (colEnd > this.colsBar.getValue()) {
                    colEnd = this.colsBar.getValue();
                }
                if (rowStart > this.rowsBar.getValue()) {
                    rowStart = this.rowsBar.getValue();
                }
                if (colStart > this.colsBar.getValue()) {
                    colStart = this.colsBar.getValue();
                }
                if (rowEnd < rowStart) {
                    tmp = rowEnd;
                    rowEnd = rowStart;
                    rowStart = tmp;
                }
                if (colEnd < colStart) {
                    tmp = colEnd;
                    colEnd = colStart;
                    colStart = tmp;
                }
                for (int rowI = rowStart; rowI <= rowEnd; ++rowI) {
                    for (int colI = colStart; colI <= colEnd; ++colI) {
                        this.grid.setVoltage(rowI, colI, v);
                    }
                }
                this.mouseKlickedX = 0;
                this.mouseKlickedY = 0;
                this.simImageChanged = true;
                this.repaint();
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getX() >= 1 && e.getX() <= 501 && e.getY() >= 97 && e.getY() <= 597) {
            this.mouseKlickedX = e.getX();
            this.mouseKlickedY = e.getY();
        } else {
            this.mouseKlickedX = -1;
            this.mouseKlickedY = -1;
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (e.getX() >= 1 && e.getX() <= 501 && e.getY() >= 97 && e.getY() <= 597) {
            double v = this.grid.getDefVoltage(this.grid.getVoltagePointX(e.getX() - 1), this.grid.getVoltagePointY(e.getY() - 97));
            if (Double.isNaN(v)) {
                this.quickinfo = new String(String.valueOf(String.valueOf(new StringBuffer("(").append(this.grid.getVoltagePointX(e.getX() - 1)).append(",").append(this.grid.getVoltagePointY(e.getY() - 97)).append(")"))));
            } else {
                v = (double)Math.round(v * (double)10000) / 10000.0;
                this.quickinfo = new String(String.valueOf(String.valueOf(new StringBuffer("(").append(this.grid.getVoltagePointX(e.getX() - 1)).append(",").append(this.grid.getVoltagePointY(e.getY() - 97)).append(")=").append(v))));
            }
            try {
                this.quickinfo = this.quickinfo.substring(0, 15);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            this.quickinfoX = e.getX() + 10;
            this.quickinfoY = e.getY() + 20;
            if (this.quickinfoY >= 577) {
                this.quickinfoY -= 35;
            }
            if (this.quickinfoX >= 431) {
                this.quickinfoX -= 80;
            }
        } else {
            this.quickinfo = null;
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
    }
}

