package antLogger.testApps;

import java.net.*;
import java.io.*;

/**
 * Dies ist ein Netzwerk Client um eine Verbindung zu testen. Im Modus stdin liest er von der Standard eingabe,
 * sonst gibt er Zeilen mit Zeichen von 32 bis 112 aus.
 *
 * JAVA-Logger antLogger; Projekt der HTA Luzern->Abteilung Informatik->Software Engineering
 * Authoren Patrick Brndler, Pascal Mengelt, Andy Wyss, Fabian Heusser
 * Teacher: Jrg Hofstetter
 * School: hta.fhz.ch, Horw;
 * Project Homepage: http://www.w3p.ch/antLogger/
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 *
 * @author Fabian Heusser
 * @author Patrick Brndler
 * @author Pascal Mengelt
 * @author Andy Wyss
 * @version 1.0 $Date$ $Revision$
 * @(#) Connection
 */

public class TestNetClient {

private final boolean stdin = true;


  public TestNetClient (){
      try {

      //setting up connection details
      String hostname = "127.0.0.1";
      int port = 1234;

      //setting up socket with BUFFERED streams
      Socket s = new Socket(hostname, port);

      InputStream sIn = s.getInputStream();
      BufferedReader fromServer = new BufferedReader( new InputStreamReader(sIn));

      OutputStream sOut = s.getOutputStream();
      PrintWriter toServer = new PrintWriter( new OutputStreamWriter (sOut));


      //setting up Console Stream
      BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
      System.out.println("System ready.");

      if (stdin) {
          System.out.println("Type in Data whitch you like to send:");
         //Loop til a singel dot on a line is read.
         String text;
         do {
           text = in.readLine();
           toServer.println(text);
           toServer.flush();      //nessecary because were using buffered streams
           //System.out.println(fromServer.readLine());
         } while (!text.equals(new String("."))) ;
      } else {
        System.out.println("Sending Data...");
        String text = "";
        long lineNumber = 0;
        for (;;) {
        a:
          for (int i = 32; i<112; i++){
            text = text + (char) i;
            if (text.length()>68){
              toServer.println(new PrintfFormat("%07d-").sprintf(lineNumber) + text);
              toServer.flush();
              lineNumber++;
              //toServer.flush();      //nessecary because were using buffered streams
              text = "";
            }
          }

        }
      }


      toServer.flush();

      //text = in.readLine();

      toServer.close();
      fromServer.close();
      s.close();
    } catch (Exception ex) {
      ex.printStackTrace();
    }
  }

  /**Main method*/
  public static void main(String[] args) {
    new TestNetClient();
  }
}