package antLogger.logServer;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.TableModelListener;
import javax.swing.event.TableModelEvent;

/**
 * Copyright (c) 2002
 * TablePanelModel
 * TableModel of a table to show the messages
 * the newest messages on top
 * sorting by column doesn't work, 'cause of problem with the dynamic table and it also brings performance problems
 * all functions concerning sort are with comments
 * @author Pascal Mengelt
 * @version 1.0 - 25. april 2002
 */
public class TablePanelModel extends AbstractTableModel implements TableModelListener
{
	//	  private int indexes[];
	//	 private static int activeColumn = -1;
	//	  private static boolean sortUp = false;

	/** holds all the messages */
	private ArrayList values = new ArrayList(5000);

	//    private ArrayList indexArray = new ArrayList();
	public TablePanelModel()
	{
		addTableModelListener(this);
	}

	/** @see TableModel */
	public Object getValueAt(int row, int column)
	{
		//        return ((String[])(values.get(indexes[row]))) [column];
		return ((String[]) (values.get(row))) [column];
	}

	/** @see TableModel */
	public void setValueAt(Object aValue, int row, int column)
	{
		//        String[] temp = (String[]) values.get(indexes[row]);
		String[] temp = (String[]) values.get(row);
		temp[column] = (String)aValue;
	}

	/** @see TableModel */
	public void tableChanged(TableModelEvent e)
	{
		//        updateIndexes();
	}

/*
    public void sort(int column)
	{
        int rowCount = getRowCount();
        if (sortUp)
	    {
	        for (int i = 0; i < rowCount; i++)
	        {
	            for (int j = i + 1; j < rowCount; j++)
	            {
	                if (compare(indexes[i], indexes[j], column) < 0)
	                {
	                    swap(i, j);
	                }
	            }
	        }
	    }
	    else
	    {
	        for (int i = 0; i < rowCount; i++)
	        {
	            for (int j = i + 1; j < rowCount; j++)
	            {
	                if (compare(indexes[i], indexes[j], column) > 0)
	                {
	                    swap(i, j);
	                }
	            }
	        }
	    }
	    activeColumn = column;

    }

    public void swap(int i, int j)
	{
        int tmp = indexes[i];
	    indexes[i] = indexes[j];
	    indexes[j] = tmp;
	}

    public int compare(int i, int j, int column)
	{
        Object io = getValueAt(i, column);
	    Object jo = getValueAt(j, column);
	    int c = jo.toString().compareTo(io.toString());
	    return (c < 0) ? -1 : ((c > 0) ? 1 : 0);
	}

    public void updateIndexes()
	{
        if(indexes!=null)
        {
            int temp[] = new int[values.size()];
            int oldLength = indexes.length;
            System.arraycopy(indexes,0,temp,0,oldLength);
            int oldSize = indexes.length;
            indexes = new int[values.size()];
            System.arraycopy(temp,0,indexes,0,indexes.length);
            for (int i = oldLength; i < temp.length; ++i)
            {
                indexes[i] = i;
            }
            for (int i = 0; i < indexes.length; ++i)
            {
        System.out.println("i "+i);
        System.out.println("indexes "+indexes[i]);
            }

        }else
        {
            indexes = new int[values.size()];
            for (int i = 0; i < indexes.length; ++i)
            {
                indexes[i] = i;
            }
        }
	}
*/

	// TableModel pass-through methods follow ...
	public int getRowCount()
	{
		return values.size();
	}

	public int getColumnCount()
	{
		return 5;
	}

	/** @see TableModel */
	public String getColumnName(int columnIndex)
	{
		switch (columnIndex)
		{
			case 0:
				return "date";
			case 1:
				return "application";
			case 2:
				return "module";
			case 3:
				return "priority";
			case 4:
				return "message";
		}
		return "error";
	}

	/** @see TableModel */
	public Class getColumnClass(int columnIndex)
	{
		return String.class;
	}

	/** @see TableModel */
	public boolean isCellEditable(int rowIndex, int columnIndex)
	{
		return false;
	}

/*
    public int getActiveColumn()
	{
        return activeColumn;
	}

    public boolean isSortUp() { return sortUp; }

    public void setSortUp(boolean su) { sortUp = su; }

    public void incrRowSize()
	{
        rowSize++;
    }
*/

	/** creates a new ArrayList values */
	public void resetValues()
	{
		values = new ArrayList();
		//		indexes=null;
	}

	/** add a new message to the table */
	public void addNewMessage(String[] newMsg)
	{
		values.add(0, newMsg);
		//        updateIndexes();
		setValueAt(newMsg[0], 0, 0);
		setValueAt(newMsg[1], 0, 1);
		setValueAt(newMsg[2], 0, 2);
		setValueAt(newMsg[3], 0, 3);
		setValueAt(newMsg[4], 0, 4);
	}
}
