package antLogger.logServer;

import javax.swing.JTable;
import javax.swing.table.TableModel;
import java.util.ArrayList;

public class TableLoader extends Thread
{
	private LogBuffer logBuffer;
	private LogViewer logViewer;
	private boolean running = true;
	private int refreshTime = 5000;
	private ArrayList msg = new ArrayList();

	/**
	 * Copyright (c) 2002
	 * TableLoader
	 * Thread that loads continously new messages and filters them
	 * @author Pascal Mengelt
	 * @version 1.0 - 25. april 2002
	 */
	public TableLoader(LogViewer logViewer, LogBuffer logBuffer)
	{
		this.logViewer = logViewer;
		this.logBuffer = logBuffer;
	}

	/** stops the thread */	
	public void finish()
	{
		running = false;
  }

	/** @see Thread */
	public void run()
	{
		while (running)
		{
			try
			{
//				System.out.println("refreshTime " + refreshTime);
				sleep(refreshTime);
				addNewMessages(logBuffer.getMsgs());
			}
			catch (InterruptedException ie)
			{
				System.out.println(ie);
			}
		}
	}

	/** sets the refresh time */
	public void setRefreshTime(int refreshTime)
	{
		this.refreshTime = 1000 * refreshTime;
	}

	/** adds nes messages */
	public void addNewMessages(String[][] newMsg)
	{
		for (int i = 0; i < newMsg.length; i++)
		{
//                System.out.println("newMsg[i] " + newMsg[i]);
			msg.add(newMsg[i]);
			if(filter(newMsg[i]))
			    logViewer.addNewMessage(newMsg[i]);
		}
//        logViewer.sort();
	}

	/** fills the Table of the LogViewer with the actual messages */
	public void fillTable()
	{
		for (int i = 0; i < msg.size(); i++)
		{
			if(filter((String[]) msg.get(i)))
                logViewer.addNewMessage((String[]) msg.get(i));
		}
	}

	/** Generated by Together on 26.04.2002 */
	private boolean filter(String[] msg)
	{
		if (msg[0] != null && (msg[0].compareTo(logViewer.getDates() [0]) >= 0 || logViewer.getDates() [0].equals("")) &&
		    (msg [0].compareTo(logViewer.getDates() [1]) <= 0 || logViewer.getDates() [1].equals("")))
			    if (msg [1].equals(logViewer.getApplication()) || logViewer.getApplication().equals(""))
				    if (msg [2].equals(logViewer.getModule()) || logViewer.getModule().equals(""))
					    if (logViewer.getPriorities().contains(msg [3]))
						    if ((msg [4].equals(logViewer.getMessage()) || logViewer.getMessage().equals("")))
                                return true;
		    return false;
	}
}
