package antLogger.logServer;

import java.io.*;
import java.net.*;

/**
 * StreamCollector -
 * Dieser Server erstellt einen Netzwerkserver (Klasse Server)
 * und nimmt alle Daten von den Verbindungen an.
 * gegen aussen stellt er einen PipedOutputstream zur Verfgung ber die alle Daten von allen
 * Client-Verbindungen gelesen werden knnen, Dabei ist nicht ersichtlich von welchem.
 *
 * JAVA-Logger antLogger; Projekt der HTA Luzern->Abteilung Informatik->Software Engineering
 * Authoren Patrick Brndler, Pascal Mengelt, Andy Wyss, Fabian Heusser
 * Teacher: Jrg Hofstetter
 * School: hta.fhz.ch, Horw;
 * Project Homepage: http://www.w3p.ch/antLogger/
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 *
 * @author Fabian Heusser
 * @author Patrick Brndler
 * @author Pascal Mengelt
 * @author Andy Wyss
 * @version 1.0 $Date$ $Revision$
 * @(#) StreamCollector
 */

public class StreamCollector {

  private PipedOutputStream writeEnd = new PipedOutputStream();
  private PipedInputStream readEnd = new PipedInputStream();

  private PrintStream ps = new PrintStream(writeEnd, true); //create a smart stream with auto flush.

  /**
   * Konstruiert einen Message Server.
   * @param port int, An welchem Port verbindugen Aktzeptiert werden.
   */
  public StreamCollector (int port) {
    Server s  = new Server(port,this);
    try {
      readEnd.connect(writeEnd);
    } catch (Exception ex) {ex.printStackTrace();}
  }

  /**
   * Speist die Empfangs-Daten in eine Pipe.
   * Diese Synchronisierte Methode wir von allen Client Verbindungen aufgerufen wenn sie Daten Empfangen haben.
   * Diese werden dann in eine Pipe geleitet
   * @param s String, Daten vom Client
   */
  public synchronized void append (String s){
    if (s != null){
      ps.println(s);
      ps.flush();
    }
  }

  /**
   * Liefert das Lese-Ende der Pipe zurck.
   * @return das Lese-Ende der Pipe. (am besten mit
   *    BufferedReader input = new BufferedReader(new InputStreamReader(ms.getReadPipe()));
   * auslesen)
   */
  public PipedInputStream getReadPipe(){
    return readEnd;
  }
}