package antLogger.logServer;

import java.util.*;
import java.io.*;

/**
 * LogWriter -
 * Diese Klasse ist fr das Schreiben und Rotieren, sowie Lschen der logfiles zustndig.
 *
 * JAVA-Logger antLogger; Projekt der HTA Luzern->Abteilung Informatik->Software Engineering
 * Authoren Patrick Brndler, Pascal Mengelt, Andy Wyss, Fabian Heusser
 * Teacher: Jrg Hofstetter
 * School: hta.fhz.ch, Horw;
 * Project Homepage: http://www.w3p.ch/antLogger/
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 *
 * @author Fabian Heusser
 * @author Patrick Brndler
 * @author Pascal Mengelt
 * @author Andy Wyss
 * @version 1.0 $Date$ $Revision$
 * @(#) LogWriter
 */

public class LogWriter
{
  private String defaultDirectory = "logs";
  private String defaultFilename = "log.ant";
  private File actualFile;
  private FileWriter fileWriter;
  private PrintWriter printWriter;
  private int maxFiles = 5;										// min. 2
  private long maxFileSize = 2000000;
  private long fileSize;

  /**
  * Constructor erstellt einen default-Printwriter
  */
  public LogWriter()
  {
    actualFile = new File(defaultDirectory, defaultFilename);
    fileSize = actualFile.length();
    try
    {
      fileWriter = new FileWriter(actualFile.getAbsolutePath(), true);
      printWriter = new PrintWriter(new BufferedWriter(fileWriter));
    }
    catch (IOException e)
    {
      e.printStackTrace();
    }
  }

  /**
  * Offene Dateien schliessen
  */
  public void close()
  {
    try
    {
      fileWriter.close();
    }
    catch (IOException e)
    {
      e.printStackTrace();
    }
  }

  /**
  * Eine message ins logfile schreiben
  * @param msg kompletter message string
  */
  public void writeMsg(String msg)
  {
    if (fileSize+msg.length() > maxFileSize)
    {
      fileSize = 0;
      deleteOldFiles();
      try
      {
        fileWriter.close();
        actualFile.renameTo(new File(defaultDirectory, "log_"+getActualDate()+".ant"));
        actualFile = new File(defaultDirectory, defaultFilename);
        fileWriter = new FileWriter(actualFile.getAbsolutePath(), true);
        printWriter = new PrintWriter(new BufferedWriter(fileWriter));
        System.out.println("> rotated at: "+getActualDate());
      }
      catch (IOException e)
      {
        e.printStackTrace();
      }
    }

    printWriter.println(msg);
    printWriter.flush();
    fileSize += msg.length() + 2;							// 2 correspond to a ms-dos cr+lf
  }

  /**
  * Gibt das aktuelle Datum und Uhrzeit zurck
  * @return date (YYYYMMDD-HHMMSS)
  */
  private String getActualDate()
  {
    Calendar cal = new GregorianCalendar();
    int temp;
    int year = cal.get(Calendar.YEAR);
    String month, day, hour, minute, second;

    if ((temp = cal.get(Calendar.MONTH)) < 10)
      month = "0" + temp;
    else
      month = "" + temp;
    if ((temp = cal.get(Calendar.DAY_OF_MONTH)) < 10)
      day = "0" + temp;
    else
      day = "" + temp;
    if ((temp = cal.get(Calendar.HOUR)) < 10)
      hour = "0" + temp;
    else
      hour = "" + temp;
    if ((temp = cal.get(Calendar.MINUTE)) < 10)
      minute = "0" + temp;
    else
      minute = "" + temp;
    if ((temp = cal.get(Calendar.SECOND)) < 10)
      second = "0" + temp;
    else
      second = "" + temp;

    return year+month+day+"-"+hour+minute+second;
  }

  /**
  * Alte Datein lschen
  */
  private void deleteOldFiles()
  {
    String[] logfiles = new File(defaultDirectory).list();
    if (logfiles.length >= maxFiles)
    {
    	Arrays.sort(logfiles);
     	for (int i = 1; i <= logfiles.length-maxFiles+1; i++)
        new File(defaultDirectory, logfiles[i]).delete();
    }
  }

  /**
  * Angegebene Datei lschen
  * @param file zu lschendes file
  */
  public void deleteFile(File file)
  {
  	file.delete();
  }

  /**
  * Maximale logfile-Grsse setzen
  * @param maxFileSize maximale logfile-Grsse in Bytes
  */
  public void setMaxFileSize(long maxFileSize)
  {
    this.maxFileSize = maxFileSize;
    System.out.println("> new maxfilesize: "+maxFileSize);
  }

  /**
  * Maximale logfile-Anzahl setzen
  * @param maxFiles maximale Anzahl
  */
  public void setMaxFiles(int maxFiles)
  {
    this.maxFiles = maxFiles;
    System.out.println("> new maxfiles: "+maxFiles);
  }
}
