package antLogger.logServer;

import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JSlider;
import javax.swing.table.TableModel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.JButton;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.table.JTableHeader;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.JFileChooser;
import java.io.FileReader;

/**
 * Copyright (c) 2002
 * LogViewer
 * GUI to show messages of the antLogger
 * @author Pascal Mengelt
 * @version 1.0 - 25. april 2002
 */
public class LogViewer extends JFrame
{
	private JMenuBar jMenuBar1 = new JMenuBar();
	private JMenu jMenu1 = new JMenu();
	private JMenuItem jMIClose = new JMenuItem();
	private JMenuItem jMIOpenOldMessages = new JMenuItem();
	private JMenuItem jMIRemoveOldMessages = new JMenuItem();
	private JPanel jPanel1 = new JPanel();
	private JPanel jPanel2 = new JPanel();
	private JPanel jPanel3 = new JPanel();
	private JPanel jPanel4 = new JPanel();
	private JPanel jPanel5 = new JPanel();
	private JLabel jLabel1 = new JLabel();
	private JTable jTable;
	private TablePanelModel tm;
	private JRadioButton jRBError = new JRadioButton();
	private JRadioButton jRBWarning = new JRadioButton();
	private JRadioButton jRBMessage = new JRadioButton();
	private JRadioButton jRBInfo = new JRadioButton();
	private JLabel jLabel2 = new JLabel();
	private JPanel jPanel6 = new JPanel();
	private JTextField dateFrom = new JTextField(5);
	private JTextField dateTo = new JTextField(5);
	private JLabel jLabel3 = new JLabel();
	private JLabel jLabel4 = new JLabel();
	private JLabel jLabel5 = new JLabel();
	private JLabel jLabel6 = new JLabel();
	private JTextField jTFApplic = new JTextField(12);
	private JTextField jTFMessage = new JTextField(12);
	private JTextField jTFModul = new JTextField(12);
	private JLabel jLabel7 = new JLabel();
	private JSlider jSRefreshTime = new JSlider();
	private JLabel jLabel8 = new JLabel();
	private JSlider jSNumberOfFiles = new JSlider();
	private JLabel jLabel9 = new JLabel();
	private JSlider jSSizeOfFiles = new JSlider();
	private JPanel jPanel7 = new JPanel();
	private JScrollPane jScrollPane1 = new JScrollPane();
	private JButton jBApplyChanges = new JButton();
	private JLabel jLabel10 = new JLabel();
	private JPanel jPanel8 = new JPanel();
	private JButton jBFilter = new JButton();
	private JLabel jLabel11 = new JLabel();
	private LogServer logServer;
	private TableLoader tableLoader;

	/** @param logServer Class to get the messages from */
	LogViewer(LogServer logServer)
	{
		this.logServer = logServer;
		initGUI();
		pack();
		// Fit to screen
		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
		setBounds(dim.width / 8, dim.height / 8, 830, 600);
		setVisible(true);
		tableLoader = new TableLoader(this, new LogBuffer(new BufferedReader(new InputStreamReader(logServer.getReadPipe()))));
		tableLoader.start();
		tableLoader.fillTable();
	}

	/** initialize the GUI */
	public void initGUI()
	{
		addWindowListener(new LogViewerWindowAdapter(logServer));
		tm = new TablePanelModel();
		jTable = new JTable(tm);
		jScrollPane1.getViewport().add(jTable);
		jScrollPane1.setDoubleBuffered(true);
		jTable.setRowHeight(20);
		jTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		TableColumnModel tcm = jTable.getColumnModel();
		TableColumn tc = tcm.getColumn(4);
		tc.setMinWidth(550);
		// set a mouseListener to the header of the JTable
		// to sort the JTable
		// doesn't work with dynamic table

/*
        JTableHeader hdr = (JTableHeader)jTable.getTableHeader();
	    hdr.addMouseListener(
	        new MouseAdapter()
	        {
	            public void mouseClicked(MouseEvent e)
	            {
	                TableColumnModel tcm = jTable.getColumnModel();
	                int vc = tcm.getColumnIndexAtX(e.getX());
	                int mc = jTable.convertColumnIndexToModel(vc);
                    if(tm.isSortUp()&& tm.getActiveColumn()==mc)
                        tm.setSortUp(false);
                    else
                        tm.setSortUp(true);
//                    tm.allocate();
	                tm.sort(mc);
	            }
	        });
*/

		jBApplyChanges.setText("apply changes");
		jBApplyChanges.setToolTipText("nderungen anwenden.");
		jLabel3.setText("to");
		jLabel2.setText("date:           ");
		jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		jRBInfo.setText("INFO");
		jRBInfo.setActionCommand("INFO");
		jRBInfo.setToolTipText("Listet alle Infos auf.");
		jRBMessage.setText("MESSAGE");
		jRBMessage.setActionCommand("MESSAGE");
		jRBMessage.setSelected(true);
		jRBMessage.setToolTipText("Listet alle Messages auf.");
		jRBWarning.setText("WARNING");
		jRBWarning.setActionCommand("WARNING");
		jRBWarning.setToolTipText("Listet alle Warnings auf.");
		jRBWarning.setSelected(true);
		jLabel1.setText("priority:");
		jLabel1.setFont(new java.awt.Font("SansSerif", java.awt.Font.PLAIN, 11));
		jMenu1.setText("File");
		jMenu1.setActionCommand("File");
		jMenu1.add(jMIClose);
		jMenu1.add(jMIOpenOldMessages);
		jMenu1.add(jMIRemoveOldMessages);
		setTitle("antLogger LogViewer");
		setIconImage((new javax.swing.ImageIcon("logo.jpg")).getImage());
		setJMenuBar(jMenuBar1);
		setResizable(false);
		jMenuBar1.add(jMenu1);
		jMIClose.setText("close");
		jMIOpenOldMessages.setText("open old messages");
		jMIOpenOldMessages.setActionCommand("open old messages");
		jMIOpenOldMessages.setToolTipText("ffnen einer Sicherungsdatei von 'alten' Nachrichten.");
		jMIRemoveOldMessages.setText("remove old messages");
		jMIRemoveOldMessages.setActionCommand("remove old messages");
		getContentPane().add(jPanel1, java.awt.BorderLayout.NORTH);
		getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);
		jPanel1.setLayout(new java.awt.BorderLayout());
		jPanel1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(212, 208, 200), 3));
		jPanel1.add(jPanel7, java.awt.BorderLayout.CENTER);
		jPanel1.add(jPanel2, java.awt.BorderLayout.WEST);
		jPanel1.add(jPanel3, java.awt.BorderLayout.EAST);
		jPanel2.setLayout(new java.awt.BorderLayout());
		jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(153, 153, 153), 1),
		    "filter", javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.TOP, new java.awt.Font("SansSerif", 0, 11),
		    new java.awt.Color(60, 60, 60)));
		jPanel2.add(jPanel8, java.awt.BorderLayout.EAST);
		jPanel2.add(jPanel4, java.awt.BorderLayout.WEST);
		jPanel2.add(jPanel5, java.awt.BorderLayout.CENTER);
		jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(153, 153, 153), 1),
		    "options", javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.TOP, new java.awt.Font("SansSerif", 0, 11),
		    new java.awt.Color(60, 60, 60)));
		jPanel3.setLayout(new java.awt.GridLayout(4, 2));
		jPanel3.add(jLabel7);
		jPanel3.add(jSRefreshTime);
		jPanel3.add(jLabel8);
		jPanel3.add(jSNumberOfFiles);
		jPanel3.add(jLabel9);
		jPanel3.add(jSSizeOfFiles);
		jPanel3.add(jLabel10);
		jPanel3.add(jBApplyChanges);
		jPanel4.setLayout(new java.awt.GridLayout(5, 1));
		jPanel4.add(jLabel1);
		jPanel4.add(jRBError);
		jPanel4.add(jRBWarning);
		jPanel4.add(jRBMessage);
		jPanel4.add(jRBInfo);
		jRBError.setText("ERROR");
		jRBError.setActionCommand("ERROR");
		jRBError.setSelected(true);
		jRBError.setToolTipText("Listet alle Errors auf.");
		jPanel5.setLayout(new java.awt.GridLayout(4, 2));
		jPanel5.add(jLabel2);
		jPanel5.add(jPanel6);
		jPanel5.add(jLabel4);
		jPanel5.add(jTFApplic);
		jPanel5.add(jLabel6);
		jPanel5.add(jTFModul);
		jPanel5.add(jLabel5);
		jPanel5.add(jTFMessage);
		dateFrom.setText("");
		dateFrom.setColumns(7);
		jPanel6.setAlignmentX(0.0f);
		jPanel6.setAlignmentY(0.0f);
		jPanel6.add(dateFrom);
		jPanel6.add(jLabel3);
		jPanel6.add(dateTo);
		dateTo.setText("");
		dateTo.setColumns(7);
		dateTo.setToolTipText("Datum, bis zu welchem gesucht wird. Format: JJJJ:MM:TT:SS");
		jLabel4.setText("application:");
		jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		jLabel5.setText("message:  ");
		jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		jLabel6.setText("modul:       ");
		jLabel6.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		jTFApplic.setText("");
		jTFApplic.setToolTipText("");
		jTFApplic.setMinimumSize(new java.awt.Dimension(12, 20));
		jTFApplic.setColumns(18);
		jTFMessage.setText("");
		jTFMessage.setMinimumSize(new java.awt.Dimension(12, 20));
		jTFModul.setText("");
		jTFModul.setMinimumSize(new java.awt.Dimension(34, 20));
		jLabel7.setText("refresh time:");
		jLabel8.setText("number of files:");
		jLabel9.setText("size of files:");
		jSRefreshTime.setPaintLabels(true);
		jSRefreshTime.setPreferredSize(new java.awt.Dimension(100, 16));
		jSRefreshTime.setMajorTickSpacing(10);
		jSRefreshTime.setMinimum(5);
		jSRefreshTime.setMaximum(65);
		jSRefreshTime.setFont(new java.awt.Font("Dialog", java.awt.Font.PLAIN, 6));
		jSRefreshTime.setToolTipText("Refresh Zeit der Daten in Sekunden");
		jSRefreshTime.setValue(5);
		jSNumberOfFiles.setPreferredSize(new java.awt.Dimension(100, 16));
		jSNumberOfFiles.setSize(new java.awt.Dimension(100, 40));
		jSNumberOfFiles.setMinimum(2);
		jSNumberOfFiles.setMaximum(10);
		jSNumberOfFiles.setMajorTickSpacing(2);
		jSNumberOfFiles.setPaintLabels(true);
		jSNumberOfFiles.setValue(5);
		jSNumberOfFiles.setToolTipText("Anzahl Dateien um die Nachrichten zu speichern.");
		jSSizeOfFiles.setPreferredSize(new java.awt.Dimension(100, 16));
		jSSizeOfFiles.setMajorTickSpacing(1);
		jSSizeOfFiles.setMaximum(6);
		jSSizeOfFiles.setMinimum(1);
		jSSizeOfFiles.setPaintLabels(true);
		jSSizeOfFiles.setToolTipText("Grsse einer Datei um die Nachrichten zu speichern");
		jSSizeOfFiles.setValue(2);
		jLabel10.setText("");
		jBFilter.setText("filter");
		jBFilter.setToolTipText("Dateien nach Angaben filtern.");
		jPanel8.setLayout(new java.awt.BorderLayout());
		jPanel8.add(jLabel11, java.awt.BorderLayout.WEST);
		jPanel8.add(jBFilter, java.awt.BorderLayout.CENTER);
		jLabel11.setText("    ");
		jLabel11.setToolTipText("");
		jBFilter.addActionListener(
		    new ActionListener()
		    {
			    public void actionPerformed(ActionEvent e) { jBFilterActionPerformed(e); }
		    });
		jBApplyChanges.addActionListener(
		    new ActionListener()
		    {
			    public void actionPerformed(ActionEvent e) { jBApplyChangesActionPerformed(e); }
		    });
		jMIClose.addActionListener(
		    new ActionListener()
		    {
			    public void actionPerformed(ActionEvent e) { jMICloseActionPerformed(e); }
		    });
		jMIOpenOldMessages.addActionListener(
		    new ActionListener()
		    {
			    public void actionPerformed(ActionEvent e) { jMIOpenOldMessagesActionPerformed(e); }
		    });
		jMIRemoveOldMessages.addActionListener(
		    new ActionListener()
		    {
			    public void actionPerformed(ActionEvent e) { jMIRemoveOldMessagesActionPerformed(e); }
		    });
	}

	/** action when filter button pushed */
	public void jBFilterActionPerformed(ActionEvent e)
	{
		tm.resetValues();
		tableLoader.fillTable();
		jTable.revalidate();
		//        sort();
	}

	/** action when apply button pushed */
	public void jBApplyChangesActionPerformed(ActionEvent e)
	{
		tableLoader.setRefreshTime(jSRefreshTime.getValue());
		logServer.setMaxFiles(jSNumberOfFiles.getValue());
		logServer.setMaxFileSize(jSSizeOfFiles.getValue() * 1000000);
	}

	/** closes the LogViewer (from the menu) */
	public void jMICloseActionPerformed(ActionEvent e)
	{
		logServer.hideMsgWindow();
	}

	/** @return an Array with the start- and the end date (filter) */
	public String[] getDates()
	{
		return new String[] { dateFrom.getText(), dateTo.getText() };
	}

	/** @return the name of the application (filter) */
	public String getApplication()
	{
		return jTFApplic.getText();
	}

	/** @return name of the module (filter) */
	public String getModule()
	{
		return jTFModul.getText();
	}

	/** @return message */
	public String getMessage()
	{
		return jTFMessage.getText();
	}

	/** @return the priorities in an ArrayList ("ERROR", . .) */
	public ArrayList getPriorities()
	{
		ArrayList al = new ArrayList();
		if (jRBError.isSelected())
			al.add("ERROR");
		if (jRBWarning.isSelected())
			al.add("WARNING");
		if (jRBMessage.isSelected())
			al.add("MESSAGE");
		if (jRBInfo.isSelected())
			al.add("INFO");
		return al;
	}

	/**
	 * set the new messages in a new JTable
	 * if necessary sorts them
	 * @param msg Array with all messages to display (already filtered)
	 * @param index the number of messages
	 */

/*
    public void setMessages(String[] [] msg, int index)
	{
        tm.setRowSize(index);
        jTable.revalidate();
        // fills the new table
	    for (int i = 0; i < index; i++)
	    {
        System.out.println("msg[i] [0]  "+msg[i] [0]);
	        tm.setValueAt(msg[i] [0], i, 0);
	        tm.setValueAt(msg[i] [1], i, 1);
	        tm.setValueAt(msg[i] [2], i, 2);
	        tm.setValueAt(msg[i] [3], i, 3);
	        tm.setValueAt(msg[i] [4], i, 4);
	    }
        // sorts the messages if the messages were already sorted
	    if (tm.getActiveColumn() >= 0)
	    {
	        tm.sort(tm.getActiveColumn());
	    }
        jTable.revalidate();
	}
*/

	public void addNewMessage(String[] newMsg)
	{
		tm.addNewMessage(newMsg);
		jTable.revalidate();
	}

	/** closes the frame */
	public void close()
	{
		tableLoader.finish();
		dispose();
	}

	/** open a file dialog to choose an old message file you want remove */
	public void jMIRemoveOldMessagesActionPerformed(ActionEvent e)
	{
		JFileChooser chooser = new JFileChooser("remove old message file");
		chooser.setMultiSelectionEnabled(false);
		chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
		chooser.setDialogType(JFileChooser.CUSTOM_DIALOG);
		chooser.setDialogTitle("File delete");
		String[] ext = {"ant"};
		chooser.addChoosableFileFilter(new AntLoggerFileFilter(ext, "antLogger-files (*.ant)"));
		int option = chooser.showDialog(this, "Lschen");
		if (option == JFileChooser.APPROVE_OPTION)
		{
			String text = "";
			try
			{
//				FileReader fileReader = new FileReader(chooser.getSelectedFile());
//				System.out.println("chooser.getSelectedFile() " + chooser.getSelectedFile());
//				fileReader.close();
        logServer.deleteFile(chooser.getSelectedFile());
			}
			catch (Exception ex)
			{
				System.err.println("File Error: " + ex.toString());
			}
		}
	}

	/** open a file dialog to choose an old message file you want open */
	public void jMIOpenOldMessagesActionPerformed(ActionEvent e)
	{
		JFileChooser chooser = new JFileChooser("open old message file");
		chooser.setMultiSelectionEnabled(false);
		chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
		chooser.setDialogTitle("File open");
		String[] ext = {"ant"};
		chooser.addChoosableFileFilter(new AntLoggerFileFilter(ext, "antLogger-files (*.ant)"));
		int option = chooser.showOpenDialog(this);
		if (option == JFileChooser.APPROVE_OPTION)
		{
			String text = "";
			try
			{
//				FileReader fileReader = new FileReader(chooser.getSelectedFile());
//				System.out.println("chooser.getSelectedFile() " + chooser.getSelectedFile());
//				fileReader.close();
        logServer.readFile(chooser.getSelectedFile());
			}
			catch (Exception ex)
			{
				System.err.println("File Error: " + ex.toString());
			}
		}
	}

/*
    public void sort()
    {
        // sorts the messages if the messages were already sorted
	    if (tm.getActiveColumn() >= 0)
	    {
	        tm.sort(tm.getActiveColumn());
	    }
        jTable.revalidate();
    }
*/
}
