package antLogger.logServer;

import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;

/**
 * LogServer -
 * Diese Klasse beschreibt die Applikation LogServer. ber sie wird der
 * LogViewer geffnet und geschlossen, sowie der LogWriter und LogReader
 * erstellt. ber den StreamCollector werden die messages abgeholt und
 * ber eine pipe an den LogBuffer weitergereicht. Aus diesem knnen die
 * messages dann vom LogViewer abgeholt werden.
 *
 * JAVA-Logger antLogger; Projekt der HTA Luzern->Abteilung Informatik->Software Engineering
 * Authoren Patrick Brndler, Pascal Mengelt, Andy Wyss, Fabian Heusser
 * Teacher: Jrg Hofstetter
 * School: hta.fhz.ch, Horw;
 * Project Homepage: http://www.w3p.ch/antLogger/
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 *
 * @author Fabian Heusser
 * @author Patrick Brndler
 * @author Pascal Mengelt
 * @author Andy Wyss
 * @version 1.0 $Date$ $Revision$
 * @(#) LogServer
 */

class LogServer extends JFrame implements Runnable
{
  private Thread thread;
  private LogViewer logViewer;
  private LogWriter logWriter;
  private StreamCollector streamCollector;
  private final PipedOutputStream writeEnd = new PipedOutputStream();
  private final PipedInputStream readEnd = new PipedInputStream();
  private PrintStream printStream = new PrintStream(writeEnd, false);
  private InputStreamReader inputStreamReader;
  private JTextArea statusTextArea;
  private boolean running = true;
  private static LogServer logServer;

  /*hef*/
  private JMenuBar mmMenu = new JMenuBar();
  private JMenu fileMenu = new JMenu("File");
  private JMenuItem newMenu = new JMenuItem("Open Log Window");
  private JMenuItem exitMenu = new JMenuItem("Exit");

  private JMenu logMenu = new JMenu("Log");
  private JCheckBoxMenuItem showMenu = new JCheckBoxMenuItem("Show incoming Messages",false);
  private JCheckBoxMenuItem filterMenu = new JCheckBoxMenuItem("Filter incoming Messages",false);
  private JMenuItem clearMenu = new JMenuItem("Clear Log Window");
  private String filter = "";

  /**
  * Constructor
  */
  public LogServer()
  {
    logWriter = new LogWriter();

    try
    {
      readEnd.connect(writeEnd);
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }


    statusTextArea = new JTextArea(10, 40);
    JScrollPane textScrollPane = new JScrollPane(statusTextArea, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

    /*hef*/
    fileMenu.add(newMenu);
    newMenu.addActionListener(new ActionListener(){ public void actionPerformed(ActionEvent e) {showMsgWindow(); }});
    fileMenu.add(exitMenu);
    exitMenu.addActionListener(new ActionListener(){ public void actionPerformed(ActionEvent e) {System.exit(0); }});
    //fileMenu.add(fileMenu);
    mmMenu.add(fileMenu);

    logMenu.add(showMenu);
    showMenu.addActionListener(new ActionListener(){ public void actionPerformed(ActionEvent e) {showMenu.setSelected(  showMenu.isSelected() ); }});
    logMenu.add(filterMenu);
    filterMenu.addActionListener(new ActionListener(){
         public void actionPerformed(ActionEvent e) {
            filterMenu.setSelected(  filterMenu.isSelected() );
            if  (filterMenu.isSelected()) {
              filter = JOptionPane.showInputDialog(logServer,new String("Es werden nur noch Meldungen angezeigt die folgendes Enthalten:"),"Filter", JOptionPane.QUESTION_MESSAGE );
              filterMenu.setText("Filter incoming Messages for " + filter);
            } else {filterMenu.setText("Filter incoming Messages (Display)");}
    }});
    logMenu.add(clearMenu);
    clearMenu.addActionListener(new ActionListener(){ public void actionPerformed(ActionEvent e) {  statusTextArea.setText("");  }});
    mmMenu.add(logMenu);


    this.setJMenuBar(mmMenu);

    getContentPane().add(textScrollPane);
    statusTextArea.insert("Versio 0.92\n", 0);
    statusTextArea.insert("init antLogger.LogServer.LogServer ...\n", 0);

    streamCollector = new StreamCollector(1234);
    inputStreamReader = new InputStreamReader(streamCollector.getReadPipe());
    thread = new Thread(this);
    thread.start();
  }

  /**
  * berschriebene run-Methode des Threads. Holt die messages beim
  * StreamCollector ab und sendet sie weiter an den LogBuffer und an den
  * LogWriter.
  */
  public void run()
  {
    String msg = "";
    int ch = 0;
    boolean newline = false;

    try
    {
      while (running)
      {
        while (inputStreamReader.ready())
        {
          ch = inputStreamReader.read();
          if (ch == 0x1c)
          {
            while(!inputStreamReader.ready()){thread.sleep(1);}
            ch = inputStreamReader.read();
            switch (ch)
            {
              case 0x11: showMsgWindow(); break;
              case 0x12: hideMsgWindow(); break;
            }
          }
          else if (!newline && (ch == 10 || ch == 13))
          {
            newline = true;
//            statusTextArea.insert(" >"+msg+"< \n", 0);
            logMsg(msg);
            msg = "";
          }
          else if (newline)
          {
            newline = false;
            if (ch != 10 && ch != 13)
              msg += (char)ch;
          }
          else
          {
            msg += (char)ch;
          }
        }
        thread.sleep(1);
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

  /**
  * Eine message in die pipe schreiben (pipe zum LogBuffer)
  * @param msg kompletter message string
  */
  public synchronized void sendMsg(String msg)
  {
    printStream.println(msg);
  }

  /**
  * Das Leseender der pipe abholen
  * @return Leseende der pipe
  */
  public PipedInputStream getReadPipe()
  {
    return readEnd;
  }

  /**
  * LogReader mit angegebender Datei erstellen
  * @param file zu lesendes file
  */
  public void readFile(File file)
  {
    new LogReader(this, file);
  }

  /**
  * Lscht angebene Datei (wird vom LogWriter ausgefhrt)
  * @param file zu lschendes file
  */
  public void deleteFile(File file)
  {
    logWriter.deleteFile(file);
  }

  /**
  * Den LogViewer ffnen
  */
  private void showMsgWindow()
  {
    if (logViewer == null)
    {
      logViewer = new LogViewer(this);
    }
  }

  /**
  * Den LogViewer schliessen
  */
  public void hideMsgWindow()
  {
    if (logViewer != null)
    {
    	logViewer.close();
      logViewer = null;
    }
  }

  /**
  * Maximale logfile-Grsse setzen
  * @param maxFileSize maximale logfile-Grsse in Bytes
  */
  public void setMaxFileSize(long maxFileSize)
  {
    logWriter.setMaxFileSize(maxFileSize);
  }

  /**
  * Maximale logfile-Anzahl setzen
  * @param maxFiles maximale Anzahl
  */
  public void setMaxFiles(int maxFiles)
  {
    logWriter.setMaxFiles(maxFiles);
  }

  /**
  * Eine message an die pipe und den LogWriter senden
  * @param msg kompletter message string
  */
  private void logMsg(String msg)
  {
    if (logViewer != null)
    {
      sendMsg(msg);
    }

    /*hef*/
    if (showMenu.isSelected() &&   //es ist anzeigen gewhlt filter ist ausgeschalten oder trifft zu so wird angezeigt.
       (!filterMenu.isSelected() || (filterMenu.isSelected() && (msg.indexOf(filter)>=0))))
    {
      statusTextArea.append(msg + "\n");
      statusTextArea.setCaretPosition(statusTextArea.getText().length());
    }
    logWriter.writeMsg(msg);
  }

  /**
  * Main-Methode fr den LogServer
  * @param args Kommandozeilen-Parameter
  */
  public static void main(String[] args)
  {
    logServer = new LogServer();
    logServer.setTitle("LogServer");
    logServer.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    logServer.pack();
    logServer.setVisible(true);
  }
}
