package antLogger.logServer;

import java.io.*;

/**
 * LogReader -
 * Diese Klasse ist fr das Lesen einzelner logfiles zustndig. Die gelesenen
 * Daten werden ber den LogServer an den LogViewer gesendet.
 *
 * JAVA-Logger antLogger; Projekt der HTA Luzern->Abteilung Informatik->Software Engineering
 * Authoren Patrick Brndler, Pascal Mengelt, Andy Wyss, Fabian Heusser
 * Teacher: Jrg Hofstetter
 * School: hta.fhz.ch, Horw;
 * Project Homepage: http://www.w3p.ch/antLogger/
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 *
 * @author Fabian Heusser
 * @author Patrick Brndler
 * @author Pascal Mengelt
 * @author Andy Wyss
 * @version 1.0 $Date$ $Revision$
 * @(#) LogReader
 */

public class LogReader extends Thread
{
  private LogServer logServer;
  private FileReader fileReader;
  private BufferedReader bufferedReader;
  private boolean running = true;

  /**
  * Constructor
  * @param logServer Referenz zum LogServer
  * @param file das zu lesende file
  */
  public LogReader(LogServer logServer, File file)
  {
    this.logServer = logServer;
    try
    {
      fileReader = new FileReader(file);
      bufferedReader = new BufferedReader(fileReader);
    }
    catch (IOException e)
    {
      e.printStackTrace();
    }
    start();
  }

  /**
  * berschriebene run-Methode des Threads. Luft so lange bis die Datei gelesen ist.
  */
  public void run()
  {
    String msg;

    try
    {
      while (running)
      {
        while (bufferedReader.ready())
        {
         if ((msg = bufferedReader.readLine()) == null) // Dateiende -> Thread stoppen
        	  running = false;
        	else
        	  logServer.sendMsg(msg);
        	sleep(10);
        }
      }
      fileReader.close();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }
}
