package antLogger.logClient;

import java.util.*;


/**
* MessageLogger -
* Dies ist die Messagelogger Klasse die uns die Interface-Gruppe zur Verfgung gestellt hat.
* Diese Leitet (delegiert) alle Anfragen an den Concrete MessageLogger weiter, dabei bernimmt
* sie die zugriffs regeln. So werden in dieser Klasse Meldungen abgewiesen die gefilter werden,
* Auch knnen keine Meldungen gesendet werden, wenn noch kein Name mit CreateLogger gesetzt wurde.
* AccessProxy;
*
* JAVA-Logger antLogger; Projekt der HTA Luzern->Abteilung Informatik->Software Engineering
* Authoren Patrick Brndler, Pascal Mengelt, Andy Wyss, Fabian Heusser
* Teacher: Jrg Hofstetter
* School: hta.fhz.ch, Horw;
* Project Homepage: http://www.w3p.ch/antLogger/
*
*
* LEGAL NOTICE
* THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
* THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
* UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
*
* @author Fabian Heusser
* @author Patrick Brndler
* @author Pascal Mengelt
* @author Andy Wyss
* @version 1.0 $Date$ $Revision$
* @(#) MessageLogger
*/

public class MessageLogger {


  //hier sind die Priorittslevel definiert
  public final static int ERROR = 3;
  public final static int WARNING = 2;
  public final static int MESSAGE = 1;
  public final static int INFO = 0;
  public final static String[] TYPENAMES = {"INFO", "MESSAGE", "WARNING", "ERROR"};

  //hier wird die EINZIGE instanz erzeugt; war im orginal nicht so, nur funktioniert das.
  private static MessageLogger instance = new MessageLogger();
  private static ConcreteMessageLogger logger = ConcreteMessageLogger.getInstance();

  private static boolean[] filter = {true,true,true,true};
  private static boolean isNameSet = false;

  /**
   * private constructor, da singelton
   */
  private MessageLogger(){}

  /**
   * Zeichenet eine Meldung im Log-File auf sofern type nicht unterdrckt wird.
   * @param msg string, Meldung die geschrieben werden soll.
   * @param type int, INFO, MESSAGE, WARNING or ERROR
   * @param objectName String, Name oder beizeichnung wo die Meldung generiert wurde
   * @param c Calendar, Date and Time of logging typischerweise mit Calendar.getInstance() realisiert
   * @return true fals die Message weitergeleitet wurde; false fals ein filter die Nachricht blockiert
   */
  public boolean logMsg(String msg, int type_, String objectName, Calendar c){
    if (this.filter[type_] && isNameSet) {
      logger.logMsg(msg, type_, objectName, c);
      return true;
    }
    return false;
  }

  /**
   * setzt den Filter, welche Nachrichten geloggt werden.
   * Um eine bestimmte art Meldungen zu blokieren wird der Arry-Eintrag an der stelle des Priorittslevels auf flase gesetzt.
   * boolean_array[ERROR] = false; blokiert alle ERROR Meldunge.
   * Ist das Boolean Array NICHT gleicher lnge wie das TYPENAMES Array, so
   * kehr die Methode zurck ohne Filter zu setzten.
   *
   * @param type boolean[], ein Filter Array das wirksam werden soll.
   */
  public void setTypeFilter(boolean[] type_){
    if (type_.length == filter.length && isNameSet) this.filter = type_;
  }

  /**
   * The console window will be shown
   */
  public void showMsgWindow(){
    if (isNameSet) logger.showMsgWindow();
  }

  /**
   * The Console window will be hidden
   */
  public void hideMsgWindow(){
    if (isNameSet) logger.hideMsgWindow();
  }

  /**
   * Im orginale Interface wurde hier die Instanz kreirt. Hier wird nur noch
   * der Name der Applikation zugeiesen. Es ist jedoch so gelsst dass keine
   * Message geloggt werden kann wenn knnen wenn kein name zugewiesen wurde
   * Wenn der name einmal zugewiesen wurde kann er nicht mehr gndert werden.
   *
   * @param name String, name der Applikation welche im Logfile erscheint
   */
  public static void createLogger(String name){
    //instance = new MessageLogger(); WHAT IF WE CALL THAT TWICE????
    if (!isNameSet) {logger.setName(name); isNameSet = true;}
  }

  /**
   * Get the instance
   * @return MessageLogger instanz
   */
  public static MessageLogger getInstance(){
    if (isNameSet) return instance;
    return null;
  }

  public void destroy(String msg, int type_, String objectName, Calendar c) {
    logger.close(msg, type_, objectName, c);
  }
}