package antLogger.logClient;

import java.util.*;
import java.io.*;
import java.text.*;

/**
* ConcreteMessageLogger -
* In dieser Klasse werden die Meldungen generiert und am NetClient weitergeleitet.
*
* JAVA-Logger antLogger; Projekt der HTA Luzern->Abteilung Informatik->Software Engineering
* Authoren Patrick Brndler, Pascal Mengelt, Andy Wyss, Fabian Heusser
* Teacher: Jrg Hofstetter
* School: hta.fhz.ch, Horw;
* Project Homepage: http://www.w3p.ch/antLogger/
*
*
* LEGAL NOTICE
* THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
* THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
* UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
*
* @author Fabian Heusser
* @author Patrick Brndler
* @author Pascal Mengelt
* @author Andy Wyss
* @version 1.0 $Date$ $Revision$
* @(#) ConcreteMessageLogger
*/

public class ConcreteMessageLogger {

  //Kommando um die Fester anzuzeigen.
  public static final String SHOW_MSG_WNDOW_COMMAND = ""+(char)0x1C+(char)0x11;
  public static final String HIDE_MSG_WNDOW_COMMAND = ""+(char)0x1C+(char)0x12;

  //erzeugt die Instanz
  private static ConcreteMessageLogger instance = new ConcreteMessageLogger();
  private static String name;

  //Streams erzeugen.
  private PipedOutputStream writeEnd = new PipedOutputStream();
  private PipedInputStream readEnd = new PipedInputStream();
  private BufferedOutputStream bufferStream = new BufferedOutputStream(writeEnd); // additional buffer.... not necessary...
  private PrintStream ps = new PrintStream(bufferStream, true);

  private NetClient netcl = new NetClient(readEnd, 1234); {netcl.start();}
  SimpleDateFormat formatter = new SimpleDateFormat ("yyyy-MM-dd hh:mm:ss");


  /**
   * public constructor overwritten (singleton)
   */
  private ConcreteMessageLogger(){
    name = null;
    try {
      readEnd.connect(writeEnd);
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
  }

  /**
   * @param msg
   * @param type INFO, MESSAGE, WARNING or ERROR
   * @param objectName Name of Sender
   * @param c Date and Time of logging
   * @return true if message was logged, false if message couldn't be logged
   */
  public synchronized void logMsg(String msg, int type, String objectName, Calendar c){
    String s = formatter.format(c.getTime());
    msg = msg.replace((char)0x3b, (char) 0x3a);
    ps.println(s + ";" +  name + ";" +  objectName + ";" + MessageLogger.TYPENAMES[type] + ";" + msg);
  }

  /**
   * The console window will be shown
   */
  public void showMsgWindow(){
    ps.print(SHOW_MSG_WNDOW_COMMAND);
  }

  /**
   * The Console window will be hidden
   */
  public void hideMsgWindow(){
    ps.print(HIDE_MSG_WNDOW_COMMAND);
  }

  /**
   * A instance of the MessageLogger is created. The user has to give his name which
   * is his ID.
   * @param name
   */
  public void setName(String name_){
    name = name_;
  }

  /**
   * Get the single instance
   * @return
   */
  public static ConcreteMessageLogger getInstance(){
    return instance;
  }

 protected void close(String msg, int type_, String objectName, Calendar c){
   instance.logMsg(msg, type_, objectName, c);
   try {
     ps.flush();
     ps.close();
     netcl.close();
   }
   catch (Exception ex) {
     ex.printStackTrace();
   }
 }

}