package antLogger.testApps;

import antLogger.logClient.*;
import java.util.*;
import java.io.*;

/**
* TestClient -
* Dieser Test Client startet 4 Threads welche alle rnd*intervall Pause machen
* zwischen 2 meldungen. Jeder Thread erzeugt Messages eines bestimmten Typs.
* Weiter gibt es eine weiteren Thread welcher alle 10 Sekunden die Filter Regeln ndert.
*
* Mit enter kann er Beendet werden.
*
* @param arg_0 Nummer des Programms; Logeintrge mit arg_0 = 1 Stammen dann vom Programm "TestClient 1"
* @param arg_1 Maximale pause zwischen 2 Meldungen eines Threads, so sind bei einer
*              zahl von 4000 im durschnitt 4 meldungen pro sekunde zu erwarten.
*
* JAVA-Logger antLogger; Projekt der HTA Luzern->Abteilung Informatik->Software Engineering
* Authoren Patrick Brndler, Pascal Mengelt, Andy Wyss, Fabian Heusser
* Teacher: Jrg Hofstetter
* School: hta.fhz.ch, Horw;
* Project Homepage: http://www.w3p.ch/antLogger/
*
*
* LEGAL NOTICE
* THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
* THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
* UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
*
* @author Fabian Heusser
* @author Patrick Brndler
* @author Pascal Mengelt
* @author Andy Wyss
* @version 1.0 $Date$ $Revision$
* @(#) TestClient
*/

public class TestClient {

  private static long level;
  static boolean  running = true; //i know i know this is not clean but quick!

  public TestClient() {

    new MessageGenerator(level, MessageLogger.ERROR);
    new MessageGenerator(level, MessageLogger.WARNING);
    new MessageGenerator(level, MessageLogger.MESSAGE);
    new MessageGenerator(level, MessageLogger.INFO);
    new MessageFileterAlterer (10000,false);


    String text ="";
    do {
      showMenu();
      try {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        text = in.readLine();
      }
      catch (Exception ex) {
        ex.printStackTrace();
      }

      switch (text.charAt(0)){
        case 's': MessageLogger.getInstance().showMsgWindow(); break;
        case 'h': MessageLogger.getInstance().hideMsgWindow(); break;

      }

    } while (text.charAt(0) != 'q');

    running = false;
    //System.exit(0);
  }

  public static void main(String[] args) {
    System.out.println("Starting Test Client. V0.12");
    String postfix="";

    level = MessageGenerator.EASY;

    if (args.length>0){ postfix = args[0];}
    if (args.length>1){ level = Integer.parseInt(args[1]);}
    MessageLogger.createLogger("TestClient " + postfix );
    MessageLogger.getInstance().logMsg("---------- PROGRAMM START ------- at " + new Date().toString() ,MessageLogger.INFO,"TestClient", Calendar.getInstance());

    TestClient testClient1 = new TestClient();

 //   MessageLogger.getInstance().setTypeFilter(new boolean[] {true,true,true,true});
   // MessageLogger.getInstance().logMsg("---------- PROGRAMM EXIT ------- at " + new Date().toString() ,MessageLogger.INFO,"TestClient", Calendar.getInstance());
    MessageLogger.getInstance().destroy("---------- PROGRAMM EXIT ------- at " + new Date().toString() ,MessageLogger.INFO,"TestClient", Calendar.getInstance());

  }

  private void showMenu(){
    System.out.println("--- MENU ---");
    System.out.println("[s] show Message Window");
    System.out.println("[h] hide MEssage Window");
    System.out.println("[q] Quit");


  }

}


class MessageGenerator extends Thread {
   static int threadCount=0;
   static int msgCount=0;

   // Level der Belastungstest
   public static final long EASY = 2000;
   public static final long MEDIUM = 1000;
   public static final long HARD = 500;
   public static final long INSANE = 100;

   int thisThreadNumber, type; long level;
   MessageLogger m;

   public MessageGenerator(long level, int type){
     this.level = level;
     this.type = type;
     thisThreadNumber = threadCount++;
     m = MessageLogger.getInstance();
     m.logMsg("Thread Started", type, "thread " + thisThreadNumber, Calendar.getInstance());
     this.start();
   }

   public void run(){
     int threadMsgCount = 0;
     while (TestClient.running){
       try {
         sleep((long)(Math.random()*(double)level));
         m.logMsg("TEST " +  msgCount++ + "/" + threadMsgCount++, type, "thread " + thisThreadNumber, Calendar.getInstance());
         //System.out.print(".");
       }
       catch (Exception ex) {
         ex.printStackTrace();
       }
     }
   }
}

class MessageFileterAlterer extends Thread {
   static int threadCount=0;

   private long intervall = 2000;
   private boolean random = false;

   private int statepointer = 1;
   private boolean[][] state = {  {true, true, true, true},
                                  {false, true, true, true},
                                  {true, false, true, true},
                                  {false, false, true, true},
                                  {true, true, false, true},
                                  {false, true, false, true},
                                  {true, false, false, true},
                                  {false, false, false, true},
                                  {true, true, true, false},
                                  {false, true, true, false},
                                  {true, false, true, false},
                                  {false, false, true, false},
                                  {true, true, false, false},
                                  {false, true, false, false},
                                  {true, false, false, false},
                                  {false, false, false, false}};

   MessageLogger m;

   public MessageFileterAlterer(long intervall, boolean random){
     this.intervall = intervall;
     this.random = random;
     m = MessageLogger.getInstance();
     m.logMsg("MessageFilterAlterer Started", MessageLogger.MESSAGE, "MessageFilterAlterer", Calendar.getInstance());
     m.setTypeFilter(state[0]);
     this.start();
   }

   public void run(){
     int threadMsgCount = 0;
     while (TestClient.running){
       try {
         if (random) {sleep((long)(Math.random()*(double)intervall));} else {sleep(intervall);}
         m.setTypeFilter(new boolean[] {true,true,true,true,true} );
         m.logMsg("Filter set to " + byteToString(statepointer) + "", MessageLogger.MESSAGE, "MessageFilterAlterer", Calendar.getInstance() );
         m.setTypeFilter(state[statepointer++]);
         if (statepointer == state.length) statepointer = 0;
         //System.out.print(".");
       }
       catch (Exception ex) {
         ex.printStackTrace();
       }
     }
   }

   public String byteToString(int statepointer){
               String s = "";
               for(int i=0;i<4;i++){
                 if (state[statepointer][i]) {
                    s = s + MessageLogger.TYPENAMES[i] + ", ";
                 }
               }
               return s;
  }
}
