package antLogger.logServer;

import java.net.*;
import java.io.*;


/**
 * Netzwerk-Server
 * Ein Netzwerk Server, welcher auf einem bestimmten Port wartet
 * und bei einer ankommenden verbindung eine Connection Objekt
 * erzeugt welche dann mit dem Client Kommuniziert.
 * Dieser Server luft in Einem Thread, so blockiert er nicht die Anwendung, und nimmt
 * maximal 5 Verbindungen pro Sekunden an. Auch nimmt er nur Verbindungen vom localhost (127.0.0.1) an
 *
 * JAVA-Logger antLogger; Projekt der HTA Luzern->Abteilung Informatik->Software Engineering
 * Authoren Patrick Brndler, Pascal Mengelt, Andy Wyss, Fabian Heusser
 * Teacher: Jrg Hofstetter
 * School: hta.fhz.ch, Horw;
 * Project Homepage: http://www.w3p.ch/antLogger/
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 *
 * @author Fabian Heusser
 * @author Patrick Brndler
 * @author Pascal Mengelt
 * @author Andy Wyss
 * @version 1.0 $Date$ $Revision$
 * @(#) Server
 */

public class Server extends Thread{
  private int port;
  private StreamCollector ms;

  /**
   * Konstruirt einen Server welcher auf dem Angegebenen Port hrt.
   * @param port int, Portnummer auf welchem der Server Verbindungen entgegen nimmt
   * @param ms MessageServer, dieser nimmt Daten von allen Verbindungen auf und speist sie in einen Stream
   */
  public Server(int port, StreamCollector ms) {
    this.port = port;
    this.start();
    this.ms = ms;
  }

  /**
   * Wartet auf ankommende Verbindungen und erzeugt Connection Objekte.
   */
  public void run(){
    try {
      ServerSocket ss = new ServerSocket(port);
      for (;;){
        Socket client = ss.accept();
        //check hier for access right und Source address***********************************
        (new Connection(client,ms)).start();
        sleep(200); //maximal 5 verbindungen pro sekunde
      }
    } catch (Exception ex) {
      ex.printStackTrace();
    }
  }
}