package antLogger.logServer;

import java.io.*;
import java.util.*;

/**
 * LogBuffer -
 * Stellt den Zwischenspeicher zwischen LogServer und LogViewer dar. Er erhlt
 * die messages ber eine pipe und speichert sie in einem Vector. Der LogViewer
 * kann bei Bedarf diese gepufferten messages ber ein 2d-Array abholen.
 *
 * JAVA-Logger antLogger; Projekt der HTA Luzern->Abteilung Informatik->Software Engineering
 * Authoren Patrick Brndler, Pascal Mengelt, Andy Wyss, Fabian Heusser
 * Teacher: Jrg Hofstetter
 * School: hta.fhz.ch, Horw;
 * Project Homepage: http://www.w3p.ch/antLogger/
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 *
 * @author Fabian Heusser
 * @author Patrick Brndler
 * @author Pascal Mengelt
 * @author Andy Wyss
 * @version 1.0 $Date$ $Revision$
 * @(#) LogBuffer
 */

class LogBuffer extends Thread
{
  private BufferedReader bufferedReader;
  private Vector messageBuffer;
  private boolean running = true;

  /**
  * Constructor
  * @param bufferedReader das Leseende der pipe
  */
  public LogBuffer(BufferedReader bufferedReader)
  {
    this.bufferedReader = bufferedReader;
    messageBuffer = new Vector(1000, 200);
    start();
  }

  /**
  * Diese Methode beendet den Thread
  */
  public void finish()
  {
    running = false;
  }

  /**
  * berschriebene run-Methode des Threads.
  */
  public void run()
  {
    while(running)
    {
      addMsg();
      try
      {
      	sleep(5);
      }
      catch (Exception e)
      {
        e.printStackTrace();
      }      
    }
  }

  /**
  * Liest messages aus der pipe und fllt sie in den Vector.
  */
  private void addMsg()
  {
    String msg = null;
    try
    {
    	if (bufferedReader.ready() && (msg = bufferedReader.readLine()) != null)
        messageBuffer.add(msg);
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }
  
  /**
  * Gibt die neusten messages zurck
  * @return 2d-Array mit den neuen messages
  */
  public String[][] getMsgs()
  {
    String[][] messages = new String[messageBuffer.size()][5];
    StringTokenizer rawMsg;
    for (int i = 0; i < messageBuffer.size(); i++)
    {
      rawMsg = new StringTokenizer((String)messageBuffer.get(i), ";");
      try
      {
        for (int j = 0; j < 5; j++)
        messages[i][j] = rawMsg.nextToken();
      }
      catch (Exception ex)
      { }
    }
    messageBuffer.removeAllElements();
    return messages;
  }
}
