package antLogger.logServer;

import java.net.*;
import java.io.*;

/**
 * Connection
 * Diese Klasse Stellt eine Verbindung mit einem Client dar.
 * Diese luft in einem Tread, trennt der Client die Verbindung, stribt der Thread.
 * Alle ankommenenden Daten leitet er an den Message Server weiter
 *
 * JAVA-Logger antLogger; Projekt der HTA Luzern->Abteilung Informatik->Software Engineering
 * Authoren Patrick Brndler, Pascal Mengelt, Andy Wyss, Fabian Heusser
 * Teacher: Jrg Hofstetter
 * School: hta.fhz.ch, Horw;
 * Project Homepage: http://www.w3p.ch/antLogger/
 *
 *
 * LEGAL NOTICE
 * THIS PROJECT AND ITS FILES ARE COPYRIGHTED BY THE AUTHORS
 * THIS PROJECT CAN BE COPIED, MODIFIED AND DISTRIBUTED
 * UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENCE
 *
 * @author Fabian Heusser
 * @author Patrick Brndler
 * @author Pascal Mengelt
 * @author Andy Wyss
 * @version 1.0 $Date$ $Revision$
 * @(#) Connection
 */

public class Connection extends Thread {
  private Socket client;
  private Server server;
  private StreamCollector ms;

  /**
   * Erstellt eine Verbindung
   * @param client Socket, Verbindungs Socket, rckgabe wert von ServerSocket.accept()
   * @param ms MessageServer, hierher fliessen alle Empfangenen Zeilen.
   */
  public Connection(Socket client, StreamCollector ms) {
    this.client = client;
    this.server = server;
    this.ms = ms;
  }


  /**
   * Startet den Thread
   * Es werden Daten vom Socket Gelesen. Diese Daten werden einerseits wieder an den
   * Client zurckgesendet und andererseits an den Messageserver weitergeleitet
   */
  public void run() {
    String data;
    try {
      this.sleep(100);
      InputStream inS = client.getInputStream();
      BufferedReader in = new BufferedReader ( new InputStreamReader(client.getInputStream()));
      PrintWriter out = new PrintWriter (new OutputStreamWriter(client.getOutputStream()));

      /*long time;
      long i=0;
      try {for (;;){
            //while ((s = input.readLine()) != null){System.out.print(s);}  //funtioniert nicht da....
            time = System.currentTimeMillis();
            while (inS.available()>0){/*System.out.print((char)inS.read());*//*i++;}
            if (i>0) {
              System.out.println();
              System.out.println("----------------");
              System.out.println("Input Statistic:" + (double)(1.0/((System.currentTimeMillis()-time)/1000.0)) * i + " ch/s" );
              System.out.println("----------------");
              i = 0;
            }
            sleep(1);
        }} catch (Exception ex) {ex.printStackTrace();}*/

      while ((data = in.readLine()) != null) {
        ms.append(data);
        //out.println(data); //send the data right back...
        //out.flush();
      }
      client.close();
    }
    catch (Exception ex) {
      //System.out.println("Connection Broken; Exeption:");
      ex.printStackTrace();
    }
  }
}